/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExceptionUtilRt {
    public static void rethrowUnchecked(@Nullable Throwable t) throws RuntimeException, Error {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
    }

    @Contract(value="!null->fail")
    public static void rethrowAll(@Nullable Throwable t) throws Exception {
        if (t != null) {
            ExceptionUtilRt.rethrowUnchecked(t);
            throw (Exception)t;
        }
    }

    public static <T> T findCause(Throwable e, Class<T> klass) {
        while (e != null && !klass.isInstance(e)) {
            e = e.getCause();
        }
        return (T)e;
    }

    public static boolean causedBy(Throwable e, Class<?> klass) {
        return ExceptionUtilRt.findCause(e, klass) != null;
    }

    @NotNull
    public static Throwable unwrapInvocationTargetException(@NotNull Throwable throwable) {
        return ExceptionUtilRt.unwrapException(throwable, InvocationTargetException.class);
    }

    @NotNull
    public static Throwable unwrapException(@NotNull Throwable throwable, @NotNull Class<? extends Throwable> classToUnwrap) {
        while (classToUnwrap.isInstance(throwable) && throwable.getCause() != null && throwable.getCause() != throwable) {
            throwable = throwable.getCause();
        }
        return throwable;
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable aThrowable, @NotNull String stackFrameSkipPattern) {
        String prefix = "\tat ";
        String prefixProxy = "\tat $Proxy";
        String prefixRemoteUtil = "\tat com.intellij.execution.rmi.RemoteUtil";
        final String skipPattern = "\tat " + stackFrameSkipPattern;
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter((Writer)stringWriter){
            private boolean skipping;
            private boolean newLine;

            @Override
            public void print(String x) {
                if (x == null) {
                    return;
                }
                boolean curSkipping = this.skipping;
                if (!this.skipping && x.startsWith(skipPattern)) {
                    curSkipping = true;
                } else if (this.skipping && !x.startsWith("\tat ")) {
                    curSkipping = false;
                }
                if (curSkipping) {
                    if (!this.skipping) {
                        super.print("\tin " + ExceptionUtilRt.stripPackage(x, skipPattern.length()));
                        this.newLine = true;
                    }
                    this.skipping = !x.startsWith("\tat com.intellij.execution.rmi.RemoteUtil");
                } else if (!x.startsWith("\tat $Proxy")) {
                    super.print(x);
                    this.newLine = true;
                }
                this.skipping = curSkipping;
            }

            @Override
            public void println() {
                if (this.newLine) {
                    this.newLine = false;
                    super.println();
                }
            }
        };
        aThrowable.printStackTrace(writer);
        return stringWriter.toString();
    }

    private static String stripPackage(String x, int offset) {
        int idx = offset;
        while (idx > 0 && idx < x.length() && !Character.isUpperCase(x.charAt(idx))) {
            idx = x.indexOf(46, idx) + 1;
        }
        return x.substring(Math.max(idx, offset));
    }
}

