/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.diagnostic.LoggerRt;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NullAppendable;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class FileUtilRt {
    private static final int KILOBYTE = 1024;
    private static final int DEFAULT_INTELLISENSE_LIMIT = 2560000;
    public static final int MEGABYTE = 0x100000;
    public static final int LARGE_FOR_CONTENT_LOADING = Math.max(0x1400000, Math.max(FileUtilRt.getUserFileSizeLimit(), FileUtilRt.getUserContentLoadLimit()));
    public static final int LARGE_FILE_PREVIEW_SIZE = Math.min(FileUtilRt.getLargeFilePreviewSize(), LARGE_FOR_CONTENT_LOADING);
    private static final int MAX_FILE_IO_ATTEMPTS = 10;
    private static final boolean USE_FILE_CHANNELS = "true".equalsIgnoreCase(System.getProperty("idea.fs.useChannels"));
    private static String ourCanonicalTempPathCache;
    private static final Random RANDOM;

    public static boolean isJarOrZip(@NotNull File file) {
        return FileUtilRt.isJarOrZip(file, true);
    }

    public static boolean isJarOrZip(@NotNull File file, boolean isCheckIsDirectory) {
        if (isCheckIsDirectory && file.isDirectory()) {
            return false;
        }
        String path = file.getPath();
        return StringUtilRt.endsWithIgnoreCase(path, ".jar") || StringUtilRt.endsWithIgnoreCase(path, ".zip");
    }

    @NotNull
    public static List<String> splitPath(@NotNull String path, char separatorChar) {
        int nextSeparator;
        ArrayList<String> list = new ArrayList<String>();
        int index = 0;
        while ((nextSeparator = path.indexOf(separatorChar, index)) != -1) {
            list.add(path.substring(index, nextSeparator));
            index = nextSeparator + 1;
        }
        list.add(path.substring(index));
        return list;
    }

    public static boolean isFilePathAcceptable(@NotNull File root, @Nullable FileFilter fileFilter) {
        if (fileFilter == null) {
            return true;
        }
        File file = root;
        do {
            if (fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    @Contract(value="null, _, _ -> null; !null,_,_->!null")
    public static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash) {
        return FileUtilRt.toCanonicalPath(path, separatorChar, removeLastSlash, null);
    }

    @Contract(value="null, _, _, _ -> null; !null,_,_,_->!null")
    protected static String toCanonicalPath(@Nullable String path, char separatorChar, boolean removeLastSlash, @Nullable SymlinkResolver resolver) {
        char next;
        if (path == null || path.isEmpty()) {
            return path;
        }
        if (path.charAt(0) == '.') {
            if (path.length() == 1) {
                return "";
            }
            char c = path.charAt(1);
            if (c == '/' || c == separatorChar) {
                path = path.substring(2);
            }
        }
        if (separatorChar != '/') {
            path = path.replace(separatorChar, '/');
        }
        int index = -1;
        do {
            char c = next = (index = path.indexOf(47, index + 1)) == path.length() - 1 ? (char)'\u0000' : path.charAt(index + 1);
        } while (next != '.' && next != '/' && index != -1);
        if (index == -1) {
            if (removeLastSlash) {
                int start = FileUtilRt.processRoot(path, NullAppendable.INSTANCE);
                int slashIndex = path.lastIndexOf(47);
                return slashIndex != -1 && slashIndex > start && slashIndex == path.length() - 1 ? path.substring(0, path.length() - 1) : path;
            }
            return path;
        }
        StringBuilder result = new StringBuilder(path.length());
        int start = FileUtilRt.processRoot(path, result);
        int dots = 0;
        boolean separator = true;
        for (int i = start; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '/') {
                if (!separator) {
                    if (!FileUtilRt.processDots(result, dots, start, resolver)) {
                        return resolver.resolveSymlinksAndCanonicalize(path, separatorChar, removeLastSlash);
                    }
                    dots = 0;
                }
                separator = true;
                continue;
            }
            if (c == '.') {
                if (separator || dots > 0) {
                    ++dots;
                } else {
                    result.append('.');
                }
                separator = false;
                continue;
            }
            while (dots > 0) {
                result.append('.');
                --dots;
            }
            result.append(c);
            separator = false;
        }
        if (dots > 0 && !FileUtilRt.processDots(result, dots, start, resolver)) {
            return resolver.resolveSymlinksAndCanonicalize(path, separatorChar, removeLastSlash);
        }
        int lastChar = result.length() - 1;
        if (removeLastSlash && lastChar >= 0 && result.charAt(lastChar) == '/' && lastChar > start) {
            result.deleteCharAt(lastChar);
        }
        return result.toString();
    }

    private static int processRoot(@NotNull String path, @NotNull Appendable result) {
        try {
            if (SystemInfoRt.isWindows && path.length() > 1 && path.charAt(0) == '/' && path.charAt(1) == '/') {
                int shareStart;
                int hostStart;
                result.append("//");
                for (hostStart = 2; hostStart < path.length() && path.charAt(hostStart) == '/'; ++hostStart) {
                }
                if (hostStart == path.length()) {
                    return hostStart;
                }
                int hostEnd = path.indexOf(47, hostStart);
                if (hostEnd < 0) {
                    hostEnd = path.length();
                }
                result.append(path, hostStart, hostEnd);
                result.append('/');
                for (shareStart = hostEnd; shareStart < path.length() && path.charAt(shareStart) == '/'; ++shareStart) {
                }
                if (shareStart == path.length()) {
                    return shareStart;
                }
                int shareEnd = path.indexOf(47, shareStart);
                if (shareEnd < 0) {
                    shareEnd = path.length();
                }
                result.append(path, shareStart, shareEnd);
                result.append('/');
                return shareEnd;
            }
            if (!path.isEmpty() && path.charAt(0) == '/') {
                result.append('/');
                return 1;
            }
            if (path.length() > 2 && path.charAt(1) == ':' && path.charAt(2) == '/') {
                result.append(path, 0, 3);
                return 3;
            }
            return 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Contract(value="_, _, _, null -> true")
    private static boolean processDots(@NotNull StringBuilder result, int dots, int start, @Nullable SymlinkResolver symlinkResolver) {
        if (dots == 2) {
            int pos = -1;
            if (!StringUtilRt.endsWith(result, "/../") && !"../".contentEquals(result)) {
                pos = StringUtilRt.lastIndexOf(result, '/', start, result.length() - 1);
                if (pos >= 0) {
                    ++pos;
                } else if (start > 0) {
                    pos = start;
                } else if (result.length() > 0) {
                    pos = 0;
                }
            }
            if (pos >= 0) {
                if (symlinkResolver != null && symlinkResolver.isSymlink(result)) {
                    return false;
                }
                result.delete(pos, result.length());
            } else {
                result.append("../");
            }
        } else if (dots != 1) {
            for (int i = 0; i < dots; ++i) {
                result.append('.');
            }
            result.append('/');
        }
        return true;
    }

    @NotNull
    public static String getExtension(@NotNull String fileName) {
        int index = fileName.lastIndexOf(46);
        if (index < 0) {
            return "";
        }
        return fileName.substring(index + 1);
    }

    @NotNull
    public static CharSequence getExtension(@NotNull CharSequence fileName) {
        return FileUtilRt.getExtension(fileName, "");
    }

    @Contract(value="_,!null -> !null")
    public static CharSequence getExtension(@NotNull CharSequence fileName, @Nullable String defaultValue) {
        int index = StringUtilRt.lastIndexOf(fileName, '.', 0, fileName.length());
        if (index < 0) {
            return defaultValue;
        }
        return fileName.subSequence(index + 1, fileName.length());
    }

    public static boolean extensionEquals(@NotNull @NonNls String filePath, @NotNull @NonNls String extension) {
        int extLen = extension.length();
        if (extLen == 0) {
            int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
            return filePath.indexOf(46, lastSlash + 1) == -1;
        }
        int extStart = filePath.length() - extLen;
        return extStart >= 1 && filePath.charAt(extStart - 1) == '.' && filePath.regionMatches(!SystemInfoRt.isFileSystemCaseSensitive, extStart, extension, 0, extLen);
    }

    public static boolean fileNameEquals(@NotNull File file, @NonNls @NotNull String name) {
        return FileUtilRt.fileNameEquals(file.getName(), (CharSequence)name);
    }

    public static boolean fileNameEquals(@NotNull @NonNls CharSequence fileName, @NotNull @NonNls CharSequence expectedName) {
        return StringUtilRt.equal(expectedName, fileName, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String path) {
        return FileUtilRt.toSystemDependentName(path, File.separatorChar);
    }

    @NotNull
    public static String toSystemDependentName(@NotNull String path, char separatorChar) {
        return path.replace('/', separatorChar).replace('\\', separatorChar);
    }

    @NotNull
    public static String toSystemIndependentName(@NotNull String path) {
        return path.replace('\\', '/');
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(File base, File file) {
        if (base == null || file == null) {
            return null;
        }
        if (base.equals(file)) {
            return ".";
        }
        String filePath = file.getAbsolutePath();
        String basePath = base.getAbsolutePath();
        return FileUtilRt.getRelativePath(basePath, filePath, File.separatorChar);
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator) {
        return FileUtilRt.getRelativePath(basePath, filePath, separator, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @Nullable
    @Contract(pure=true)
    public static String getRelativePath(@NotNull String basePath, @NotNull String filePath, char separator, boolean caseSensitive) {
        int len;
        CharComparingStrategy strategy;
        basePath = FileUtilRt.ensureEnds(basePath, separator);
        if (caseSensitive ? basePath.equals(FileUtilRt.ensureEnds(filePath, separator)) : basePath.equalsIgnoreCase(FileUtilRt.ensureEnds(filePath, separator))) {
            return ".";
        }
        int lastSeparatorIndex = 0;
        CharComparingStrategy charComparingStrategy = strategy = caseSensitive ? CharComparingStrategy.IDENTITY : CharComparingStrategy.CASE_INSENSITIVE;
        for (len = 0; len < filePath.length() && len < basePath.length() && strategy.charsEqual(filePath.charAt(len), basePath.charAt(len)); ++len) {
            if (basePath.charAt(len) != separator) continue;
            lastSeparatorIndex = len;
        }
        if (len == 0) {
            return null;
        }
        StringBuilder relativePath = new StringBuilder();
        for (int i = len; i < basePath.length(); ++i) {
            if (basePath.charAt(i) != separator) continue;
            relativePath.append("..");
            relativePath.append(separator);
        }
        relativePath.append(filePath.substring(lastSeparatorIndex + 1));
        return relativePath.toString();
    }

    @NotNull
    @Contract(pure=true)
    private static String ensureEnds(@NotNull String s, char endsWith) {
        return StringUtilRt.endsWithChar(s, endsWith) ? s : s + endsWith;
    }

    @NotNull
    public static CharSequence getNameWithoutExtension(@NotNull CharSequence name) {
        int i = StringUtilRt.lastIndexOf(name, '.', 0, name.length());
        return i < 0 ? name : name.subSequence(0, i);
    }

    @NotNull
    public static String getNameWithoutExtension(@NotNull String name) {
        return FileUtilRt.getNameWithoutExtension((CharSequence)name).toString();
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, deleteOnExit);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtilRt.createTempDirectory(dir, prefix, suffix, true);
    }

    @NotNull
    public static File createTempDirectory(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, true);
        if (deleteOnExit) {
            FilesToDeleteHolder.ourFilesToDelete.add(file.getPath());
        }
        if (!file.isDirectory()) {
            throw new IOException("Cannot create a directory: " + file);
        }
        return file;
    }

    @NotNull
    public static File createTempFile(@NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtilRt.createTempFile(prefix, suffix, false);
    }

    @NotNull
    public static File createTempFile(@NonNls @NotNull String prefix, @NonNls @Nullable String suffix, boolean deleteOnExit) throws IOException {
        File dir = new File(FileUtilRt.getTempDirectory());
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, deleteOnExit);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, true, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean create) throws IOException {
        return FileUtilRt.createTempFile(dir, prefix, suffix, create, true);
    }

    @NotNull
    public static File createTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean create, boolean deleteOnExit) throws IOException {
        File file = FileUtilRt.doCreateTempFile(dir, prefix, suffix, false);
        if (deleteOnExit) {
            file.deleteOnExit();
        }
        if (!create && !file.delete() && file.exists()) {
            throw new IOException("Cannot delete a file: " + file);
        }
        return file;
    }

    @NotNull
    private static File doCreateTempFile(@NotNull File dir, @NotNull String prefix, @Nullable String suffix, boolean isDirectory) throws IOException {
        dir.mkdirs();
        if (prefix.length() < 3) {
            prefix = (prefix + "___").substring(0, 3);
        }
        if (suffix == null) {
            suffix = "";
        }
        prefix = new File(prefix).getName();
        int attempts = 0;
        int i = 0;
        int maxFileNumber = 10;
        IOException exception = null;
        while (true) {
            File f = null;
            try {
                boolean success;
                f = FileUtilRt.calcName(dir, prefix, suffix, i);
                boolean bl = success = isDirectory ? f.mkdir() : f.createNewFile();
                if (success) {
                    return FileUtilRt.normalizeFile(f);
                }
            }
            catch (IOException e) {
                exception = e;
            }
            int MAX_ATTEMPTS = 100;
            if (++attempts > maxFileNumber / 2 || attempts > MAX_ATTEMPTS) {
                Object[] children = dir.list();
                int size = children == null ? 0 : children.length;
                maxFileNumber = Math.max(10, size * 10);
                if (attempts > MAX_ATTEMPTS) {
                    throw exception != null ? exception : new IOException("Unable to create a temporary file " + f + "\nDirectory '" + dir + "' list (" + size + " children): " + Arrays.toString(children));
                }
            }
            if (++i <= 2) continue;
            i = 2 + RANDOM.nextInt(maxFileNumber);
        }
    }

    @NotNull
    private static File calcName(@NotNull File dir, @NotNull String prefix, @NotNull String suffix, int i) throws IOException {
        File f;
        String name;
        String string = prefix = i == 0 ? prefix : prefix + i;
        if (prefix.endsWith(".") && suffix.startsWith(".")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        if (!(name = prefix + suffix).equals((f = new File(dir, name)).getName())) {
            throw new IOException("A generated name is malformed: '" + name + "' (" + f + ")");
        }
        return f;
    }

    @NotNull
    private static File normalizeFile(@NotNull File temp) throws IOException {
        File canonical = temp.getCanonicalFile();
        return SystemInfoRt.isWindows && canonical.getAbsolutePath().contains(" ") ? temp.getAbsoluteFile() : canonical;
    }

    @NotNull
    public static String getTempDirectory() {
        if (ourCanonicalTempPathCache == null) {
            ourCanonicalTempPathCache = FileUtilRt.calcCanonicalTempPath();
        }
        return ourCanonicalTempPathCache;
    }

    @NotNull
    private static String calcCanonicalTempPath() {
        File file = new File(System.getProperty("java.io.tmpdir"));
        try {
            String canonical = file.getCanonicalPath();
            if (!SystemInfoRt.isWindows || !canonical.contains(" ")) {
                return canonical;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.getAbsolutePath();
    }

    @TestOnly
    static void resetCanonicalTempPathCache(@NotNull String tempPath) {
        ourCanonicalTempPathCache = tempPath;
    }

    @NotNull
    public static File generateRandomTemporaryPath() throws IOException {
        return FileUtilRt.generateRandomTemporaryPath("", "");
    }

    @NotNull
    public static File generateRandomTemporaryPath(@NotNull String prefix, @NotNull String suffix) throws IOException {
        File file = new File(FileUtilRt.getTempDirectory(), prefix + UUID.randomUUID() + suffix);
        for (int i = 0; file.exists() && i < 5; ++i) {
            file = new File(FileUtilRt.getTempDirectory(), prefix + UUID.randomUUID() + suffix);
        }
        if (file.exists()) {
            throw new IOException("Couldn't generate unique random path.");
        }
        return FileUtilRt.normalizeFile(file);
    }

    @NotNull
    public static String loadFile(@NotNull File file) throws IOException {
        return FileUtilRt.loadFile(file, null, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, boolean convertLineSeparators) throws IOException {
        return FileUtilRt.loadFile(file, null, convertLineSeparators);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadFile(file, encoding, false);
    }

    @NotNull
    public static String loadFile(@NotNull File file, @Nullable String encoding, boolean convertLineSeparators) throws IOException {
        String s = new String(FileUtilRt.loadFileText(file, encoding));
        return convertLineSeparators ? StringUtilRt.convertLineSeparators(s) : s;
    }

    @NotNull
    public static char[] loadFileText(@NotNull File file) throws IOException {
        return FileUtilRt.loadFileText(file, (String)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @Nullable String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(file);
        InputStreamReader reader = encoding == null ? new InputStreamReader((InputStream)stream, Charset.defaultCharset()) : new InputStreamReader((InputStream)stream, encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static char[] loadFileText(@NotNull File file, @NotNull Charset encoding) throws IOException {
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(file), encoding);
        try {
            char[] cArray = FileUtilRt.loadText(reader, (int)file.length());
            return cArray;
        }
        finally {
            ((Reader)reader).close();
        }
    }

    @NotNull
    public static char[] loadText(@NotNull Reader reader, int length) throws IOException {
        int count;
        int n;
        char[] chars = new char[length];
        for (count = 0; count < chars.length && (n = reader.read(chars, count, chars.length - count)) > 0; count += n) {
        }
        if (count == chars.length) {
            return chars;
        }
        return Arrays.copyOf(chars, count);
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file) throws IOException {
        return FileUtilRt.loadLines(file.getPath());
    }

    @NotNull
    public static List<String> loadLines(@NotNull File file, @Nullable String encoding) throws IOException {
        return FileUtilRt.loadLines(file.getPath(), encoding);
    }

    @NotNull
    public static List<String> loadLines(@NotNull String path) throws IOException {
        return FileUtilRt.loadLines(path, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static List<String> loadLines(@NotNull String path, @Nullable String encoding) throws IOException {
        FileInputStream stream = new FileInputStream(path);
        BufferedReader reader = new BufferedReader(encoding == null ? new InputStreamReader((InputStream)stream, Charset.defaultCharset()) : new InputStreamReader((InputStream)stream, encoding));
        try {
            List<String> list = FileUtilRt.loadLines(reader);
            return list;
        }
        finally {
            reader.close();
        }
    }

    @NotNull
    public static List<String> loadLines(@NotNull BufferedReader reader) throws IOException {
        String line;
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = reader.readLine()) != null) {
            lines.add(line);
        }
        return lines;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        FileUtilRt.copy(stream, buffer);
        return buffer.toByteArray();
    }

    public static boolean isTooLarge(long len) {
        return len > (long)LARGE_FOR_CONTENT_LOADING;
    }

    @NotNull
    public static byte[] loadBytes(@NotNull InputStream stream, int length) throws IOException {
        int n;
        if (length == 0) {
            return ArrayUtilRt.EMPTY_BYTE_ARRAY;
        }
        byte[] bytes = new byte[length];
        for (int count = 0; count < length && (n = stream.read(bytes, count, length - count)) > 0; count += n) {
        }
        return bytes;
    }

    @Nullable
    public static File getParentFile(@NotNull File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean delete(@NotNull File file) {
        if (NIOReflect.IS_AVAILABLE) {
            try {
                FileUtilRt.deleteRecursivelyNIO(NIOReflect.toPath(file), null);
                return true;
            }
            catch (IOException e) {
                return false;
            }
            catch (Exception e) {
                FileUtilRt.logger().info(e);
                return false;
            }
        }
        return FileUtilRt.deleteRecursively(file);
    }

    static void deleteRecursivelyNIO(@NotNull Object path, @Nullable Consumer<Object> callback) throws IOException {
        try {
            NIOReflect.deleteRecursively(path, callback);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    private static boolean deleteRecursively(@NotNull File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File child : files) {
                if (FileUtilRt.deleteRecursively(child)) continue;
                return false;
            }
        }
        return FileUtilRt.deleteFile(file);
    }

    @Nullable
    public static <T, E extends Throwable> T doIOOperation(@NotNull RepeatableIOOperation<T, E> ioTask) throws E {
        for (int i = 10; i > 0; --i) {
            T result = ioTask.execute(i == 1);
            if (result != null) {
                return result;
            }
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return null;
    }

    protected static boolean deleteFile(final @NotNull File file) {
        Boolean result = FileUtilRt.doIOOperation(new RepeatableIOOperation<Boolean, RuntimeException>(){

            @Override
            public Boolean execute(boolean lastAttempt) {
                if (file.delete() || !file.exists()) {
                    return Boolean.TRUE;
                }
                if (lastAttempt) {
                    return Boolean.FALSE;
                }
                return null;
            }
        });
        return Boolean.TRUE.equals(result);
    }

    public static boolean ensureCanCreateFile(@NotNull File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        if (!FileUtilRt.createIfNotExists(file)) {
            return false;
        }
        return FileUtilRt.delete(file);
    }

    public static boolean createIfNotExists(@NotNull File file) {
        if (file.exists()) {
            return true;
        }
        try {
            if (!FileUtilRt.createParentDirs(file)) {
                return false;
            }
            FileOutputStream s = new FileOutputStream(file);
            ((OutputStream)s).close();
            return true;
        }
        catch (IOException e) {
            FileUtilRt.logger().info(e);
            return false;
        }
    }

    public static boolean createParentDirs(@NotNull File file) {
        File parentPath = file.getParentFile();
        return parentPath == null || FileUtilRt.createDirectory(parentPath);
    }

    public static boolean createDirectory(@NotNull File path) {
        return path.isDirectory() || path.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull File fromFile, @NotNull File toFile) throws IOException {
        if (!FileUtilRt.ensureCanCreateFile(toFile)) {
            return;
        }
        FileOutputStream fos = new FileOutputStream(toFile);
        try {
            FileInputStream fis = new FileInputStream(fromFile);
            try {
                FileUtilRt.copy(fis, fos);
            }
            finally {
                fis.close();
            }
        }
        finally {
            fos.close();
        }
        long timeStamp = fromFile.lastModified();
        if (timeStamp < 0L) {
            FileUtilRt.logger().warn("Invalid timestamp " + timeStamp + " of '" + fromFile + "'");
        } else if (!toFile.setLastModified(timeStamp)) {
            FileUtilRt.logger().warn("Unable to set timestamp " + timeStamp + " to '" + toFile + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(@NotNull InputStream inputStream, @NotNull OutputStream outputStream) throws IOException {
        block8: {
            int read;
            if (USE_FILE_CHANNELS && inputStream instanceof FileInputStream && outputStream instanceof FileOutputStream) {
                FileChannel fromChannel = ((FileInputStream)inputStream).getChannel();
                try {
                    FileChannel toChannel = ((FileOutputStream)outputStream).getChannel();
                    try {
                        fromChannel.transferTo(0L, Long.MAX_VALUE, toChannel);
                        break block8;
                    }
                    finally {
                        toChannel.close();
                    }
                }
                finally {
                    fromChannel.close();
                }
            }
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) >= 0) {
                outputStream.write(buffer, 0, read);
            }
        }
    }

    public static int getUserFileSizeLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.intellisense.filesize", 2560000);
    }

    public static int getUserContentLoadLimit() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.filesize", 0x1400000);
    }

    private static int getLargeFilePreviewSize() {
        return FileUtilRt.parseKilobyteProperty("idea.max.content.load.large.preview.size", 2560000);
    }

    private static int parseKilobyteProperty(String key, int defaultValue) {
        try {
            long i = Integer.parseInt(System.getProperty(key, String.valueOf(defaultValue / 1024)));
            if (i < 0L) {
                return Integer.MAX_VALUE;
            }
            return (int)Math.min(i * 1024L, Integer.MAX_VALUE);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static LoggerRt logger() {
        return LoggerRt.getInstance("#com.intellij.openapi.util.io.FileUtilRt");
    }

    @NotNull
    public static URI fileToUri(@NotNull File file) {
        String path = file.getAbsolutePath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (!path.startsWith("/")) {
            path = '/' + path;
        }
        if (path.startsWith("//")) {
            path = "//" + path;
        }
        try {
            return new URI("file", null, path, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(path, e);
        }
    }

    public static int pathHashCode(@Nullable String path) {
        if (path == null || path.isEmpty()) {
            return 0;
        }
        path = FileUtilRt.toCanonicalPath(path, File.separatorChar, true);
        return SystemInfoRt.isFileSystemCaseSensitive ? path.hashCode() : StringUtilRt.stringHashCodeInsensitive(path);
    }

    public static boolean filesEqual(@Nullable File file1, @Nullable File file2) {
        return FileUtilRt.pathsEqual(file1 == null ? null : file1.getPath(), file2 == null ? null : file2.getPath());
    }

    public static boolean pathsEqual(@Nullable String path1, @Nullable String path2) {
        if (path1 == path2) {
            return true;
        }
        if (path1 == null || path2 == null) {
            return false;
        }
        path1 = FileUtilRt.toCanonicalPath(path1, File.separatorChar, true);
        path2 = FileUtilRt.toCanonicalPath(path2, File.separatorChar, true);
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return path1.equals(path2);
        }
        return path1.equalsIgnoreCase(path2);
    }

    static {
        RANDOM = new Random();
    }

    private static interface CharComparingStrategy {
        public static final CharComparingStrategy IDENTITY = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return ch1 == ch2;
            }
        };
        public static final CharComparingStrategy CASE_INSENSITIVE = new CharComparingStrategy(){

            @Override
            public boolean charsEqual(char ch1, char ch2) {
                return StringUtilRt.charsEqualIgnoreCase(ch1, ch2);
            }
        };

        public boolean charsEqual(char var1, char var2);
    }

    public static interface RepeatableIOOperation<T, E extends Throwable> {
        @Nullable
        public T execute(boolean var1) throws E;
    }

    private static class FilesToDeleteHolder {
        private static final Queue<String> ourFilesToDelete = FilesToDeleteHolder.createFilesToDelete();

        private FilesToDeleteHolder() {
        }

        @NotNull
        private static Queue<String> createFilesToDelete() {
            final ConcurrentLinkedQueue<String> queue = new ConcurrentLinkedQueue<String>();
            Runtime.getRuntime().addShutdownHook(new Thread("FileUtil deleteOnExit"){

                @Override
                public void run() {
                    String name;
                    while ((name = (String)queue.poll()) != null) {
                        FileUtilRt.delete(new File(name));
                    }
                }
            });
            return queue;
        }
    }

    private static final class NIOReflect {
        static final boolean IS_AVAILABLE;
        private static Method ourFilesDeleteIfExistsMethod;
        private static Method ourFilesWalkMethod;
        private static Method ourFileToPathMethod;
        private static Method ourPathToFileMethod;
        private static Method ourAttributesIsOtherMethod;
        private static Object ourDeletionVisitor;
        private static Class<?> ourNoSuchFileExceptionClass;
        private static Class<?> ourAccessDeniedExceptionClass;
        private static final ThreadLocal<Consumer<Object>> ourCallback;

        private NIOReflect() {
        }

        static Object toPath(File file) throws InvocationTargetException, IllegalAccessException {
            return ourFileToPathMethod.invoke((Object)file, new Object[0]);
        }

        static void deleteRecursively(Object path, @Nullable Consumer<Object> callback) throws InvocationTargetException, IllegalAccessException {
            try {
                ourCallback.set(callback);
                ourFilesWalkMethod.invoke(null, path, ourDeletionVisitor);
            }
            catch (InvocationTargetException e) {
                if (!ourNoSuchFileExceptionClass.isInstance(e.getCause())) {
                    throw e;
                }
            }
            finally {
                ourCallback.remove();
            }
        }

        static {
            ourCallback = new ThreadLocal();
            boolean initSuccess = false;
            try {
                Class<?> pathClass = Class.forName("java.nio.file.Path");
                Class<?> visitorClass = Class.forName("java.nio.file.FileVisitor");
                Class<?> filesClass = Class.forName("java.nio.file.Files");
                ourNoSuchFileExceptionClass = Class.forName("java.nio.file.NoSuchFileException");
                ourAccessDeniedExceptionClass = Class.forName("java.nio.file.AccessDeniedException");
                ourFileToPathMethod = Class.forName("java.io.File").getMethod("toPath", new Class[0]);
                ourPathToFileMethod = pathClass.getMethod("toFile", new Class[0]);
                ourFilesWalkMethod = filesClass.getMethod("walkFileTree", pathClass, visitorClass);
                ourAttributesIsOtherMethod = Class.forName("java.nio.file.attribute.BasicFileAttributes").getDeclaredMethod("isOther", new Class[0]);
                ourFilesDeleteIfExistsMethod = filesClass.getMethod("deleteIfExists", pathClass);
                final Object Result_Continue = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("CONTINUE").get(null);
                final Object Result_Skip = Class.forName("java.nio.file.FileVisitResult").getDeclaredField("SKIP_SUBTREE").get(null);
                ourDeletionVisitor = Proxy.newProxyInstance(FileUtilRt.class.getClassLoader(), new Class[]{visitorClass}, new InvocationHandler(){

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Override
                    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                        if (args.length != 2) return Result_Continue;
                        String methodName = method.getName();
                        Object second = args[1];
                        if (second instanceof Throwable) {
                            if (!SystemInfoRt.isWindows || !"visitFileFailed".equals(methodName) || !ourNoSuchFileExceptionClass.isInstance(second)) throw (Throwable)second;
                            this.performDelete(args[0]);
                            return Result_Continue;
                        }
                        if ("visitFile".equals(methodName) || "postVisitDirectory".equals(methodName)) {
                            Consumer consumer = (Consumer)ourCallback.get();
                            if (consumer != null) {
                                consumer.consume(args[0]);
                            }
                            this.performDelete(args[0]);
                            return Result_Continue;
                        }
                        if (!SystemInfoRt.isWindows || !"preVisitDirectory".equals(methodName)) return Result_Continue;
                        boolean notDirectory = false;
                        try {
                            notDirectory = Boolean.TRUE.equals(ourAttributesIsOtherMethod.invoke(second, new Object[0]));
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (!notDirectory) return Result_Continue;
                        this.performDelete(args[0]);
                        return Result_Skip;
                    }

                    private void performDelete(Object fileObject) throws IOException {
                        for (int attempt = 10; attempt > 0; --attempt) {
                            block11: {
                                try {
                                    ourFilesDeleteIfExistsMethod.invoke(null, fileObject);
                                    break;
                                }
                                catch (InvocationTargetException e) {
                                    Throwable cause = e.getCause();
                                    if (!(cause instanceof IOException)) {
                                        throw new IllegalStateException(e);
                                    }
                                    if (!SystemInfoRt.isWindows || attempt == 1) {
                                        throw (IOException)cause;
                                    }
                                    if (!ourAccessDeniedExceptionClass.isInstance(cause)) break block11;
                                    try {
                                        File file = (File)ourPathToFileMethod.invoke(fileObject, new Object[0]);
                                        if (file.delete() || !file.exists()) {
                                            break;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                    }
                                }
                                catch (IllegalAccessException e) {
                                    throw new IllegalStateException(e);
                                }
                            }
                            try {
                                Thread.sleep(10L);
                                continue;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                });
                initSuccess = true;
            }
            catch (Throwable ignored) {
                FileUtilRt.logger().info("Was not able to detect NIO API");
            }
            IS_AVAILABLE = initSuccess;
        }
    }

    protected static interface SymlinkResolver {
        @NotNull
        public String resolveSymlinksAndCanonicalize(@NotNull String var1, char var2, boolean var3);

        public boolean isSymlink(@NotNull CharSequence var1);
    }
}

