/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.io;

import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.ThrowableConsumer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class DataInputOutputUtilRt {
    public static int readINT(@NotNull DataInput record) throws IOException {
        int val = record.readUnsignedByte();
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = record.readUnsignedByte();
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static int readINT(@NotNull ByteBuffer byteBuffer) {
        int val = byteBuffer.get() & 0xFF;
        if (val < 192) {
            return val;
        }
        int res = val - 192;
        int sh = 6;
        while (true) {
            int next = byteBuffer.get() & 0xFF;
            res |= (next & 0x7F) << sh;
            if ((next & 0x80) == 0) {
                return res;
            }
            sh += 7;
        }
    }

    public static void writeINT(@NotNull DataOutput record, int val) throws IOException {
        if (0 > val || val >= 192) {
            record.writeByte(192 + (val & 0x3F));
            val >>>= 6;
            while (val >= 128) {
                record.writeByte(val & 0x7F | 0x80);
                val >>>= 7;
            }
        }
        record.writeByte(val);
    }

    public static void writeINT(@NotNull ByteBuffer byteBuffer, int val) {
        if (0 > val || val >= 192) {
            byteBuffer.put((byte)(192 + (val & 0x3F)));
            val >>>= 6;
            while (val >= 128) {
                byteBuffer.put((byte)(val & 0x7F | 0x80));
                val >>>= 7;
            }
        }
        byteBuffer.put((byte)val);
    }

    public static <T> void writeSeq(@NotNull DataOutput out, @NotNull Collection<? extends T> collection, @NotNull ThrowableConsumer<T, IOException> writeElement) throws IOException {
        DataInputOutputUtilRt.writeINT(out, collection.size());
        for (T t : collection) {
            writeElement.consume(t);
        }
    }

    @NotNull
    public static <T> List<T> readSeq(@NotNull DataInput in, @NotNull ThrowableComputable<? extends T, IOException> readElement) throws IOException {
        int size = DataInputOutputUtilRt.readINT(in);
        ArrayList<T> result = new ArrayList<T>(size);
        for (int i = 0; i < size; ++i) {
            result.add(readElement.compute());
        }
        return result;
    }

    public static <K, V> void writeMap(@NotNull DataOutput out, @NotNull Map<? extends K, ? extends V> map, @NotNull ThrowableConsumer<? super K, ? extends IOException> writeKey, @NotNull ThrowableConsumer<? super V, ? extends IOException> writeValue) throws IOException {
        DataInputOutputUtilRt.writeINT(out, map.size());
        for (Map.Entry<K, V> e : map.entrySet()) {
            writeKey.consume(e.getKey());
            writeValue.consume(e.getValue());
        }
    }

    @NotNull
    public static <K, V> Map<K, V> readMap(@NotNull DataInput in, @NotNull ThrowableComputable<? extends K, ? extends IOException> readKey, @NotNull ThrowableComputable<? extends V, ? extends IOException> readValue) throws IOException {
        int size = DataInputOutputUtilRt.readINT(in);
        HashMap<K, V> result = new HashMap<K, V>();
        for (int i = 0; i < size; ++i) {
            result.put(readKey.compute(), readValue.compute());
        }
        return result;
    }
}

