/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi.ssl;

import com.intellij.execution.rmi.ssl.DelegateSslSocketFactory;
import com.intellij.execution.rmi.ssl.SslUtil;
import com.intellij.security.CompositeX509TrustManager;
import com.intellij.util.ArrayUtilRt;
import java.io.IOException;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509TrustManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SslSocketFactory
extends DelegateSslSocketFactory {
    public SslSocketFactory() throws GeneralSecurityException {
        super(SslSocketFactory.createDelegate());
    }

    @NotNull
    private static SSLSocketFactory createDelegate() throws NoSuchAlgorithmException, KeyManagementException {
        KeyManager[] kms;
        TrustManager[] tms;
        SSLContext ctx = SSLContext.getInstance("TLS");
        try {
            KeyManager[] keyManagerArray;
            TrustManager[] trustManagerArray;
            String caCertPath = System.getProperty("sslCaCertPath");
            String clientCertPath = System.getProperty("sslClientCertPath");
            String clientKeyPath = System.getProperty("sslClientKeyPath");
            boolean trustEverybody = Boolean.parseBoolean(System.getProperty("sslTrustEverybody"));
            if (trustEverybody) {
                TrustManager[] trustManagerArray2 = new TrustManager[1];
                trustManagerArray = trustManagerArray2;
                trustManagerArray2[0] = new SslUtil.TrustEverybodyManager();
            } else {
                trustManagerArray = tms = caCertPath == null ? new TrustManager[]{} : SslSocketFactory.createTrustManagers(caCertPath);
            }
            if (clientCertPath != null && clientKeyPath != null) {
                KeyManager[] keyManagerArray2 = new KeyManager[1];
                keyManagerArray = keyManagerArray2;
                keyManagerArray2[0] = new MyKeyManager(clientCertPath, clientKeyPath);
            } else {
                keyManagerArray = new KeyManager[]{};
            }
            kms = keyManagerArray;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ctx.init(kms, tms, null);
        return ctx.getSocketFactory();
    }

    @NotNull
    public static TrustManager[] createTrustManagers(@NotNull String caCertPath) throws Exception {
        List<X509Certificate> certs = SslUtil.loadCertificates(caCertPath);
        ArrayList<MyTrustManager> result = new ArrayList<MyTrustManager>(certs.size());
        for (X509Certificate cert : certs) {
            result.add(new MyTrustManager(cert));
        }
        return new TrustManager[]{new CompositeX509TrustManager(new TrustManager[][]{result.toArray(new TrustManager[0])})};
    }

    private static final class MyKeyManager
    extends X509ExtendedKeyManager {
        private final String myAlias = UUID.randomUUID().toString();
        @NotNull
        private final X509Certificate[] myCertificates;
        @NotNull
        private final PrivateKey myPrivateKey;

        private MyKeyManager(@NotNull String certPath, @NotNull String keyPath) throws Exception {
            this.myCertificates = new X509Certificate[]{SslUtil.readCertificate(certPath)};
            this.myPrivateKey = SslUtil.readPrivateKey(keyPath);
        }

        @Override
        @NotNull
        public String[] getClientAliases(String s, Principal[] principals) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        public String chooseClientAlias(String[] strings, Principal[] principals, Socket socket) {
            return this.myAlias;
        }

        @Override
        @NotNull
        public String[] getServerAliases(String s, Principal[] principals) {
            return ArrayUtilRt.EMPTY_STRING_ARRAY;
        }

        @Override
        @Nullable
        public String chooseServerAlias(String s, Principal[] principals, Socket socket) {
            return null;
        }

        @Override
        @NotNull
        public X509Certificate[] getCertificateChain(String s) {
            return this.myCertificates;
        }

        @Override
        @NotNull
        public PrivateKey getPrivateKey(String s) {
            return this.myPrivateKey;
        }
    }

    private static final class MyTrustManager
    implements X509TrustManager {
        private X509TrustManager trustManager;

        private MyTrustManager(@NotNull X509Certificate caCertPath) throws Exception {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(MyTrustManager.createStore(caCertPath));
            for (TrustManager tm : tmf.getTrustManagers()) {
                if (!(tm instanceof X509TrustManager)) continue;
                this.trustManager = (X509TrustManager)tm;
                break;
            }
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
        }

        @NotNull
        private static KeyStore createStore(@NotNull X509Certificate certificate) throws CertificateException, IOException, KeyStoreException, NoSuchAlgorithmException {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            ks.setCertificateEntry(UUID.randomUUID().toString(), certificate);
            return ks;
        }

        @Override
        public void checkClientTrusted(X509Certificate[] x509Certificates, String s) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] x509Certificates, String s) throws CertificateException {
            if (this.trustManager == null) {
                throw new RuntimeException("No X509TrustManager found");
            }
            this.trustManager.checkServerTrusted(x509Certificates, s);
        }

        @Override
        @NotNull
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

