/*
 * Decompiled with CFR 0.152.
 */
package com.google.devrel.cluestick.studioclient;

import com.appspot.cluestick_server.search.model.Result;
import com.google.devrel.cluestick.searchservice.CluestickSearch;
import com.google.devrel.cluestick.studioclient.DynamicToolWindowWrapper;
import com.google.devrel.cluestick.studioclient.PsiHelpers;
import com.google.devrel.cluestick.studioclient.Symbol;
import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.TargetElementUtil;
import com.intellij.codeInsight.actions.CodeInsightAction;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiReference;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FindSampleUsageAction
extends CodeInsightAction
implements CodeInsightActionHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.google.devrel.cluestick.studioclient.FindSampleUsageAction");
    public static final String PLUGIN_ID = "com.google.cluestick.studioclient";

    public void update(AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction((AnActionEvent)event);
    }

    public void invoke(final @NotNull Project project, final @NotNull Editor editor, @NotNull PsiFile psiFile) {
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        int offset = editor.getCaretModel().getOffset();
        final Symbol symbol = this.findSymbol(editor, offset);
        if (symbol == null) {
            this.showMessage(editor, "Please highlight a variable, type or method");
            return;
        }
        IdeaPluginDescriptor pluginDescriptor = PluginManagerCore.getPlugin((PluginId)PluginId.getId((String)PLUGIN_ID));
        final String userAgent = pluginDescriptor.getName() + "/" + pluginDescriptor.getVersion();
        Task.Backgroundable task = new Task.Backgroundable(project, "Finding Samples"){

            public void run(@NotNull ProgressIndicator indicator) {
                List<Result> results;
                try {
                    results = ((CluestickSearch)ApplicationManager.getApplication().getService(CluestickSearch.class)).performSearch(symbol, userAgent);
                }
                catch (IOException ex) {
                    LOG.warn("Couldn't perform Cluestick search", (Throwable)ex);
                    FindSampleUsageAction.this.showMessage(editor, String.format("Samples are currently unavailable for: %s", symbol));
                    return;
                }
                if (results.isEmpty()) {
                    FindSampleUsageAction.this.showMessage(editor, String.format("No samples found for: %s", symbol));
                } else {
                    FindSampleUsageAction.this.showSamplesToolWindow(project, symbol, results);
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(task, (ProgressIndicator)new BackgroundableProcessIndicator(task));
    }

    public boolean startInWriteAction() {
        return false;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        return this;
    }

    @Nullable
    private Symbol findSymbol(@NotNull Editor editor, int offset) {
        TargetElementUtil util = TargetElementUtil.getInstance();
        PsiElement targetElement = util.findTargetElement(editor, util.getAllAccepted(), offset);
        Collection<Symbol> out = PsiHelpers.findSymbols(targetElement);
        if (out.isEmpty()) {
            String qualifiedName;
            PsiReference reference = TargetElementUtil.findReference((Editor)editor, (int)offset);
            if (reference instanceof PsiJavaCodeReferenceElement && (qualifiedName = ((PsiJavaCodeReferenceElement)reference).getQualifiedName()) != null) {
                return new Symbol(qualifiedName);
            }
            return null;
        }
        LOG.info("Symbols under cursor: " + out);
        Symbol fallback = null;
        for (Symbol symbol : out) {
            if (symbol.isQualified()) {
                return symbol;
            }
            if (fallback != null) continue;
            fallback = symbol;
        }
        return fallback;
    }

    private void showSamplesToolWindow(final @NotNull Project project, final Symbol symbol, final List<Result> results) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                DynamicToolWindowWrapper toolWindowWrapper = DynamicToolWindowWrapper.getInstance(project);
                ToolWindow toolWindow = toolWindowWrapper.getToolWindow(symbol, results);
                toolWindow.show((Runnable)null);
            }
        });
    }

    private void showMessage(final Editor editor, final String message) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                HintManager.getInstance().showErrorHint(editor, message);
            }
        });
    }
}

