/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.symtable;

import com.jetbrains.sourceglider.atttributes.Attribute;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.symtable.KnownDomainTypes;
import com.jetbrains.sourceglider.symtable.WrongAttributeException;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.UICallback;
import com.jetbrains.sourceglider.utils.PrettyName;
import com.jetbrains.sourceglider.utils.ReflectionHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SymbolTable {
    private DomainType[] availableTypes;
    private String[] availableTypeNames;
    private HashMap<String, DomainType> nameToType = new HashMap();
    private Set<Attribute>[] attributesSet;
    private Attribute[][] attributes;
    private Map<String, Integer>[] backwardMap;
    private Map<String, Map<Object, String>> metaInfos = new HashMap<String, Map<Object, String>>();
    private boolean allowDomainsResize;
    private final UICallback uiCallback;

    public SymbolTable(UICallback uiCallback, Map<Object, Object> options) {
        this.installDomainTypes(options);
        this.createDomains();
        this.uiCallback = uiCallback;
    }

    public void init() {
        this.attributesSet = new Set[this.availableTypes.length];
        for (int i = 0; i < this.availableTypes.length; ++i) {
            DomainType availableType = this.availableTypes[i];
            availableType.init();
            this.attributesSet[i] = new HashSet<Attribute>();
        }
    }

    public void setAllowDomainsResize(boolean value) {
        this.allowDomainsResize = value;
    }

    public boolean allowsDomainResize() {
        return this.allowDomainsResize;
    }

    private void installDomainTypes(Map<Object, Object> options) {
        int i;
        try {
            String[] customTypeNames = (String[])options.get(KnownDomainTypes.class);
            this.availableTypeNames = customTypeNames != null ? customTypeNames : (String[])ReflectionHelper.getAllFieldValues(KnownDomainTypes.class, String.class, "DOM_");
        }
        catch (Throwable e) {
            this.uiCallback.showException(e, true);
            return;
        }
        this.availableTypes = new DomainType[this.availableTypeNames.length];
        for (i = 0; i < this.availableTypeNames.length; ++i) {
            this.availableTypes[i] = new DomainType(this.availableTypeNames[i], this, i);
            this.nameToType.put(this.availableTypeNames[i], this.availableTypes[i]);
        }
        for (i = 0; i < KnownDomainTypes.metaInfo.length; ++i) {
            Map map2 = this.metaInfos.computeIfAbsent(KnownDomainTypes.metaInfo[i][0], k -> new HashMap());
            map2.put(KnownDomainTypes.metaInfo[i][1], KnownDomainTypes.metaInfo[i][2]);
        }
    }

    private void createDomains() {
        for (int i = 0; i < this.availableTypes.length; ++i) {
            this.availableTypes[i].installDomains(i);
        }
    }

    public void sortAttributes() {
        this.attributes = new Attribute[this.availableTypes.length][];
        this.backwardMap = new Map[this.availableTypes.length];
        for (int i = 0; i < this.availableTypes.length; ++i) {
            this.attributes[i] = (Attribute[])this.attributesSet[i].stream().sorted().toArray(Attribute[]::new);
            this.backwardMap[i] = new HashMap<String, Integer>();
            for (int j = 0; j < this.attributes[i].length; ++j) {
                this.backwardMap[i].put(this.attributes[i][j].getKey(), j);
                this.availableTypes[i].addAttribute();
            }
        }
    }

    public String[] getAvailableDomainTypeNames() {
        return this.availableTypeNames;
    }

    public DomainType[] getAvailableDomainTypes() {
        return this.availableTypes;
    }

    public DomainType getDomainType(String name) {
        return this.nameToType.get(name);
    }

    public Map<Object, String> getMetaInfo(DomainType domainType) {
        return this.metaInfos.get(domainType.getName());
    }

    public int getAttributeInt(DomainType type, String attribute) {
        Integer value = this.backwardMap[type.getIndex()].get(attribute);
        if (value == null) {
            throw new WrongAttributeException(Messages.getString(SymbolTable.class.getName() + "-1") + attribute + "\"");
        }
        return value;
    }

    public int findAttributeInt(DomainType type, String attribute) {
        if (type.isIntegerType()) {
            return Integer.parseInt(attribute);
        }
        Integer value = this.backwardMap[type.getIndex()].get(attribute);
        return value != null ? value : -1;
    }

    public Attribute getAttribute(DomainType domainType, int value) {
        if (domainType.isIntegerType()) {
            return new Attribute(String.valueOf(value), domainType, null, -1, -1, new PrettyName(String.valueOf(value)));
        }
        return this.attributes[domainType.getIndex()][value];
    }

    public void addAttribute(Attribute attribute) {
        this.addAttribute(attribute, false);
    }

    public void addAttribute(Attribute attribute, boolean replace) {
        DomainType domainType = attribute.getType();
        if (domainType.isIntegerType()) {
            int value = Integer.parseInt(attribute.getKey());
            if (value >= domainType.getNumOfAttrs()) {
                domainType.addAttributes(value - domainType.getNumOfAttrs() + 1);
            }
            return;
        }
        this.attributesSet[domainType.getIndex()].add(attribute);
    }
}

