/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.scripts.rml.parser.LexerConsts;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.HashMap;

public class Lexer {
    private String source;
    private int pos;
    private char curSymbol;
    private HashMap<String, Integer> standartIDs;
    private VariablesManager variablesManager;

    public Lexer(String source, VariablesManager variablesManager) {
        this.source = source + "\u0000\u0000";
        this.variablesManager = variablesManager;
        this.pos = 0;
        this.standartIDs = new HashMap();
        for (int i = 0; i < LexerConsts.IDTerms.length; ++i) {
            this.standartIDs.put(LexerConsts.IDTerms[i], LexerConsts.IDTermNums[i]);
        }
    }

    private int getOffset() {
        int linePos = 0;
        int nextLinePos;
        while ((nextLinePos = this.source.indexOf("\n", linePos + 1)) <= this.pos && nextLinePos != -1) {
            linePos = nextLinePos;
        }
        return this.pos - linePos - 1;
    }

    private int getLine() {
        int linePos = 0;
        int line = 0;
        int nextLinePos;
        while ((nextLinePos = this.source.indexOf("\n", linePos + 1)) <= this.pos && nextLinePos != -1) {
            linePos = nextLinePos;
            ++line;
        }
        return line + 1;
    }

    private void skipComments() throws ParseException {
        int start = this.pos;
        int symb1 = 47;
        int symb2 = 42;
        this.pos += 2;
        while (symb2 != 0) {
            symb1 = symb2;
            symb2 = this.source.charAt(this.pos++);
            if (symb1 != 42 || symb2 != 47) continue;
        }
        if (symb1 != 42 || symb2 != 47) {
            throw new ParseException(start, this.pos, this.getLine(), this.getOffset(), Messages.getString(Lexer.class.getName() + "-1"));
        }
    }

    private void skipLineComments() {
        this.pos += 2;
        this.curSymbol = this.source.charAt(this.pos++);
        while (this.curSymbol != '\n' && this.curSymbol != '\u0000') {
            this.curSymbol = this.source.charAt(this.pos++);
        }
    }

    private void skipSpace() throws ParseException {
        this.curSymbol = this.source.charAt(this.pos);
        while (true) {
            if (Character.isWhitespace(this.curSymbol)) {
                ++this.pos;
            } else if (this.curSymbol == '/' && this.source.charAt(this.pos + 1) == '*') {
                this.skipComments();
            } else {
                if (this.curSymbol != '/' || this.source.charAt(this.pos + 1) != '/') break;
                this.skipLineComments();
            }
            this.curSymbol = this.source.charAt(this.pos);
        }
    }

    private TokenInfo getID() {
        int start = this.pos;
        StringBuilder buf = new StringBuilder();
        while (Character.isLetterOrDigit(this.curSymbol) || this.curSymbol == '_') {
            buf.append(this.curSymbol);
            this.curSymbol = this.source.charAt(++this.pos);
        }
        String name = buf.toString();
        int lexem = this.standartIDs.containsKey(name) ? this.standartIDs.get(name) : (this.variablesManager.containsDomain(name) ? 6 : (this.variablesManager.containsDomainType(name) ? 28 : (this.variablesManager.containsRelation(name) ? 10 : (this.variablesManager.containsVariable(name) ? 22 : 2))));
        return new TokenInfo(lexem, start, this.pos, this.getLine(), this.getOffset(), name);
    }

    private TokenInfo getStrConst() throws ParseException {
        int start = this.pos++;
        StringBuilder strBuf = new StringBuilder();
        int lexem = 20;
        while (this.curSymbol == '\"') {
            this.curSymbol = this.source.charAt(this.pos++);
            if (this.curSymbol == '$') {
                lexem = 21;
                this.curSymbol = this.source.charAt(this.pos++);
            }
            while (this.curSymbol != '\u0000' && this.curSymbol != '\"') {
                if (this.curSymbol == '\n') {
                    throw new ParseException(start, this.pos, this.getLine(), this.getOffset(), Messages.getString(Lexer.class.getName() + "-2"));
                }
                strBuf.append(this.curSymbol);
                this.curSymbol = this.source.charAt(this.pos++);
            }
            if (this.curSymbol == '\u0000') {
                throw new ParseException(start, this.pos, this.getLine(), this.getOffset(), Messages.getString(Lexer.class.getName() + "-3"));
            }
            this.curSymbol = this.source.charAt(this.pos++);
        }
        --this.pos;
        String strConst = strBuf.toString();
        if (strConst.startsWith("%")) {
            strConst = Messages.getString(strConst.substring(1).trim());
        }
        return new TokenInfo(lexem, start, this.pos, this.getLine(), this.getOffset(), strConst);
    }

    private TokenInfo atmExec() throws ParseException {
        int next;
        int state = 0;
        int start = this.pos;
        while (state != -1 && (next = LexerConsts.atmTable[state][this.curSymbol]) != 0) {
            if ((next & 0x4000) != 0) {
                this.curSymbol = this.source.charAt(++this.pos);
                next ^= 0x4000;
            }
            if ((next & 0x2000) != 0) {
                return new TokenInfo(next ^ 0x2000, start, this.pos, this.getLine(), this.getOffset());
            }
            state = next;
        }
        throw new ParseException(start, this.pos, this.getLine(), this.getOffset(), Messages.getString(Lexer.class.getName() + "-4"));
    }

    private TokenInfo getNumberConst() {
        int start = this.pos;
        StringBuilder buf = new StringBuilder();
        while (Character.isDigit(this.curSymbol)) {
            buf.append(this.curSymbol);
            this.curSymbol = this.source.charAt(++this.pos);
        }
        int value = Integer.parseInt(buf.toString());
        return new TokenInfo(8, start, this.pos, this.getLine(), this.getOffset(), value);
    }

    public TokenInfo getNext() throws ParseException {
        this.skipSpace();
        this.curSymbol = this.source.charAt(this.pos);
        if (this.curSymbol == '\u0000') {
            return new TokenInfo(54, this.pos, this.pos, this.getLine(), this.getOffset());
        }
        if (Character.isLetter(this.curSymbol) || this.curSymbol == '_') {
            return this.getID();
        }
        if (Character.isDigit(this.curSymbol)) {
            return this.getNumberConst();
        }
        if (this.curSymbol == '\"') {
            return this.getStrConst();
        }
        return this.atmExec();
    }
}

