/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Implication;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;

public class Expression
extends Nonterm {
    public Expr expr;
    public RelExpr relExpr;
    public int type;
    public Implication implication;
    private int opCode = -1;

    public Expression(Context context) {
        super(context);
    }

    public void or(TokenInfo token) {
        this.opCode = this.type == 0 ? 0 : 0;
    }

    public void sub(TokenInfo token) {
        this.opCode = this.type == 0 ? 3 : 1;
    }

    public void add(TokenInfo token) {
        this.opCode = 6;
    }

    public void term() throws ParseException {
        if (this.opCode == -1) {
            this.expr = this.implication.expr;
            this.relExpr = this.implication.relExpr;
            this.type = this.implication.type;
        } else {
            if (this.type != this.implication.type) {
                throw new ParseException(this.implication.location, Messages.getString(Expression.class.getName() + "-0"));
            }
            if (this.type == 0) {
                if (this.opCode == 6) {
                    throw new ParseException(this.implication.location, Messages.getString(Expression.class.getName() + "-1"));
                }
                this.relExpr = new RelExprBinary(this.opCode, this.relExpr, this.implication.relExpr, this.context, this);
            } else {
                if (this.type == 2 ^ this.opCode == 0) {
                    throw new ParseException(this.implication.location, Messages.getString(Expression.class.getName() + "-2"));
                }
                this.expr = new ExprBinary(this.opCode, this.expr, this.implication.expr, this.context);
            }
        }
    }
}

