/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class StmtRepeat
extends Stmt {
    private Expr cond;
    private Stmt stmt;

    public StmtRepeat(Expr cond, Stmt stmt, Context context) {
        super(context, stmt);
        this.cond = cond;
        this.stmt = stmt;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        if (visitor.visitRepeatStart(this)) {
            this.stmt.accept(visitor);
        }
        visitor.visitRepeatEnd(this);
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.stmt = this.stmt.transform(transformer);
        return transformer.transformRepeat(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        do {
            if (threadCallback.checkCancelled()) {
                return;
            }
            this.stmt.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        } while (this.cond.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable) == 0);
    }

    @Override
    public String toLongString() {
        return "StmtRepeat{cond=" + this.cond.toLongString() + ", stmt=" + this.stmt.toLongString() + "}";
    }
}

