/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.PrettyPrintable;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.List;
import java.util.stream.Collectors;

public class StmtList
extends Stmt
implements PrettyPrintable {
    private final List<Stmt> stmts;

    public StmtList(List<Stmt> list, Context context, Nonterm nonterm) {
        super(context, nonterm, (QueryNode[])list.toArray(new Stmt[0]));
        this.stmts = list;
    }

    @Override
    public void accept(StmtVisitor visitor) {
        for (Stmt stmt : this.stmts) {
            stmt.accept(visitor);
        }
    }

    @Override
    public Stmt transform(StmtTransformer transformer) {
        this.stmts.replaceAll(stmt -> stmt.transform(transformer));
        return transformer.transformList(this);
    }

    @Override
    public void interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        for (Stmt stmt : this.stmts) {
            if (threadCallback.checkCancelled()) {
                return;
            }
            stmt.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        }
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, 0L, opCnt);
        }
    }

    @Override
    public String toLongString() {
        String statements = this.stmts.stream().map(PrettyPrintable::toLongString).collect(Collectors.joining("\n", "\n", "\n"));
        return "StmtList{" + statements + "}";
    }
}

