/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.sourceglider.bdd.IBDDManager;
import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Factor;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.IntStream;

public class RelExprVar
extends RelExpr {
    public static final int DOMAIN = 0;
    public static final int ATTRIBUTE = 1;
    public static final int UNDERSCORE = 2;
    public static final int REGEXP = 3;
    private final String relname;
    private final String[] values;
    private final int[] flags;
    private boolean fastRename;
    private Nonterm nonterm1;
    private Nonterm nonterm2;
    private Map<IBDDManager, LinkedList<IRelation>> precomputedResults = new HashMap<IBDDManager, LinkedList<IRelation>>();

    public RelExprVar(String relname, String[] values, int[] flags, Context context, Factor nonterm1, Nonterm nonterm2) {
        super(context, new QueryNode[0]);
        this.relname = relname;
        this.values = values;
        this.flags = flags;
        this.nonterm1 = nonterm1;
        this.nonterm2 = nonterm2;
        this.fastRename = true;
        for (int flag : flags) {
            if (flag == 0) continue;
            this.fastRename = false;
            break;
        }
    }

    public RelExprVar(String relname, String[] values, Context context) {
        super(context, new QueryNode[0]);
        this.relname = relname;
        this.values = values;
        this.fastRename = true;
        this.flags = new int[values.length];
        Arrays.fill(this.flags, 0);
    }

    public String getRelName() {
        return this.relname;
    }

    public String[] getValues() {
        return this.values;
    }

    public int[] getFlags() {
        return this.flags;
    }

    public int getValuesCnt() {
        return this.values.length;
    }

    public String getValue(int index) {
        return this.values[index];
    }

    public int getFlag(int index) {
        return this.flags[index];
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitVar(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformVar(this);
    }

    public void pushPrecomputedResults(IRelation result, IBDDManager bddManager) {
        if (!this.precomputedResults.containsKey(bddManager)) {
            this.precomputedResults.put(bddManager, new LinkedList());
        }
        this.precomputedResults.get(bddManager).push(result);
    }

    public void popPrecomputedResults(IBDDManager bddManager) {
        LinkedList<IRelation> stack = this.precomputedResults.get(bddManager);
        if (stack != null && !stack.isEmpty()) {
            stack.pop().kill();
        }
    }

    public void disposeResources() {
        this.precomputedResults.clear();
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        ArrayList<Domain> domains2 = new ArrayList<Domain>();
        for (int i = 0; i < this.values.length; ++i) {
            if (this.flags[i] != 0) continue;
            domains2.add(variablesManager.getDomain(this.values[i]));
        }
        return domains2.toArray(new Domain[0]);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        LinkedList<IRelation> precomputedStack = this.precomputedResults.get(relationsManager.getBDDManager());
        if (precomputedStack != null && !precomputedStack.isEmpty()) {
            return precomputedStack.peek().getClone();
        }
        IRelation result = relationsManager.makeRepositoryRelation(variablesManager.getRelation(this.relname), this.relname);
        if (this.fastRename) {
            Domain[] domains2 = new Domain[this.values.length];
            for (int i = 0; i < domains2.length; ++i) {
                domains2[i] = variablesManager.getDomain(this.values[i]);
            }
            IRelation oldResult = result;
            result = result.fastRename(domains2, threadCallback);
            oldResult.kill();
            return result;
        }
        for (int i = this.values.length - 1; i >= 0; --i) {
            IRelation oldResult = result;
            if (this.flags[i] == 1) {
                Domain domain = result.getDomain(i);
                int attr = symbolTable.findAttributeInt(domain.getType(), this.values[i]);
                if (attr == -1) {
                    result = relationsManager.makeEmptyRelation((Domain[])ArrayHelper.deleteElement(result.getDomains(), i, Domain.class));
                    uiInstancesProvider.getConsole().println(Messages.getString(RelExprVar.class.getName() + "-0") + this.values[i] + Messages.getString(RelExprVar.class.getName() + "-1"));
                } else {
                    result = result.project(i, attr, threadCallback);
                }
            } else if (this.flags[i] == 2) {
                result = result.exists(i, threadCallback);
            } else if (this.flags[i] == 3) {
                result = result.relprod(relationsManager.makeRegExprSet(result.getDomain(i), this.values[i], threadCallback), result.getDomain(i), threadCallback);
            } else if (this.flags[i] == 0) {
                result = result.rename(i, variablesManager.getDomain(this.values[i]), threadCallback);
            }
            oldResult.kill();
        }
        return result;
    }

    public Domain getDomain(RuntimeVariablesManager variablesManager, int index) {
        return variablesManager.getRelation(this.relname).getDomain(index);
    }

    public String getDomainName(int index) {
        return this.flags[index] == 0 ? this.values[index] : "_";
    }

    @Override
    public int[] getLocation() {
        if (this.nonterm1 != null && this.nonterm2 != null) {
            int[] loc1 = this.nonterm1.getLocation();
            int[] loc2 = this.nonterm2.getLocation();
            return new int[]{loc1[0], loc2[1], loc2[2], loc2[3]};
        }
        return null;
    }

    @Override
    public String toLongString() {
        return "RelExprVar{relname='" + this.relname + "', values=" + Arrays.toString(this.values) + ", flags=" + Arrays.toString(this.flags) + ", fastRename=" + this.fastRename + "}";
    }

    @Override
    public String toShortString() {
        return this.relname + "(" + (String)IntStream.range(0, this.values.length).mapToObj(i -> this.flags[i] == 2 ? "_" : this.values[i]).collect(StringUtil.joining()) + ")";
    }
}

