/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class RelExprUnary
extends RelExpr {
    public static final int NOT = 0;
    public static final int TC = 1;
    private RelExpr operand;
    private int opCode;

    public RelExprUnary(RelExpr operand, int opCode, Context context, Nonterm nonterm) {
        super(context, nonterm, operand);
        this.operand = operand;
        this.opCode = opCode;
    }

    public RelExpr getOperand() {
        return this.operand;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitUnaryStart(this)) {
            this.operand.accept(visitor);
        }
        visitor.visitUnaryEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.operand = this.operand.transform(transformer);
        return transformer.transformUnary(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return this.operand.getDomains(variablesManager, domainsPool);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        IRelation opResult = this.operand.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
        IRelation result = this.opCode == 0 ? opResult.complement(threadCallback) : opResult.transitiveClosure(threadCallback);
        opResult.kill();
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes(), opCnt);
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprUnary{operand=" + this.operand.toLongString() + ", opCode=" + this.opCode + "}";
    }

    @Override
    public String toShortString() {
        Object operandStr = this.operand.toShortString();
        if (this.operand instanceof RelExprBinary) {
            operandStr = "(" + (String)operandStr + ")";
        }
        return (this.opCode == 0 ? "!" : "TC ") + (String)operandStr;
    }
}

