/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class RelExprQuantify
extends RelExpr {
    public static final int EXIST = 0;
    public static final int FOR_ALL = 1;
    private int opCode;
    private String quantifier;
    private RelExpr expr;
    private DomainTypeReference typeRef;

    public RelExprQuantify(int opCode, String quantifier, DomainTypeReference typeRef, RelExpr expr, Context context, Nonterm nonterm) {
        super(context, nonterm, expr);
        this.opCode = opCode;
        this.quantifier = quantifier;
        this.expr = expr;
        this.typeRef = typeRef;
    }

    public String getQuantifier() {
        return this.quantifier;
    }

    public RelExpr getOperand() {
        return this.expr;
    }

    public DomainTypeReference getTypeRef() {
        return this.typeRef;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        if (visitor.visitQuantifyStart(this)) {
            this.expr.accept(visitor);
        }
        visitor.visitQuantifyEnd(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        this.expr = this.expr.transform(transformer);
        return transformer.transformQuantify(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain domain = this.pushDomain(variablesManager, domainsPool);
        ArrayList<Domain> domains2 = new ArrayList<Domain>(Arrays.asList(this.expr.getDomains(variablesManager, domainsPool)));
        domains2.remove(domain);
        this.popDomain(variablesManager);
        return domains2.toArray(new Domain[0]);
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        IRelation result;
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        Domain domain = this.pushDomain(variablesManager, domainsPool);
        if (this.opCode == 0) {
            IRelation opResult = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
            result = opResult.exists(domain, threadCallback);
            opResult.kill();
        } else if (this.opCode == 1) {
            ArrayList<RelExprQuantify> quantifiers = new ArrayList<RelExprQuantify>();
            RelExpr curExpr = this;
            while (curExpr instanceof RelExprQuantify && curExpr.opCode == 1) {
                quantifiers.add(0, (RelExprQuantify)curExpr);
                curExpr = curExpr.expr;
            }
            if (curExpr instanceof RelExprBinary && ((RelExprBinary)curExpr).getOpCode() == 2) {
                ArrayList<Domain> domains2 = new ArrayList<Domain>();
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier != this) {
                        domains2.add(quantifier.pushDomain(variablesManager, domainsPool));
                        continue;
                    }
                    domains2.add(domain);
                }
                IRelation leftResult = ((RelExprBinary)curExpr).getLeftOperand().interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation rightResult = ((RelExprBinary)curExpr).getRightOperand().interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation rightResultComplement = rightResult.complement(threadCallback);
                IRelation faComplement = leftResult.unsafeIntersect(rightResultComplement, threadCallback);
                for (Domain curDomain : domains2) {
                    IRelation faOld = faComplement;
                    faComplement = faComplement.exists(curDomain, threadCallback);
                    faOld.kill();
                }
                result = faComplement.complement(threadCallback);
                faComplement.kill();
                rightResultComplement.kill();
                rightResult.kill();
                for (RelExprQuantify quantifier : quantifiers) {
                    if (quantifier == this) continue;
                    quantifier.popDomain(variablesManager);
                }
            } else {
                IRelation opResult = this.expr.interpret(relationsManager, variablesManager, threadCallback, domainsPool, uiInstancesProvider, symbolTable, profileManager);
                IRelation opNotResult = opResult.complement(threadCallback);
                IRelation oldResult = result = opNotResult.exists(domain, threadCallback);
                result = result.complement(threadCallback);
                opResult.kill();
                opNotResult.kill();
                oldResult.kill();
            }
        } else {
            throw new UnsupportedOperationException("Unknown op code " + this.opCode);
        }
        this.popDomain(variablesManager);
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes(), opCnt);
        }
        return result;
    }

    @Nullable
    public Domain pushDomain(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        Domain domain = domainsPool.getDomain(this, this.quantifier);
        variablesManager.storeDomain(this.quantifier, domain);
        return domain;
    }

    public void popDomain(RuntimeVariablesManager variablesManager) {
        variablesManager.removeDomain(this.quantifier);
    }

    @Override
    public String toLongString() {
        return "RelExprQuantify{opCode=" + this.opCode + ", quantifier='" + this.quantifier + "', expr=" + this.expr.toLongString() + ", typeRef=" + this.typeRef.toLongString() + "}";
    }

    @Override
    public String toShortString() {
        return (this.opCode == 0 ? "EX.(" : "FA.(") + this.expr.toShortString() + ")";
    }
}

