/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RelExprComparison
extends RelExpr {
    private String leftDomain;
    private String rightDomain;
    private String opDomainName;
    private DomainType leftDomainType;
    private DomainType rightDomainType;
    private DomainType opDomainType;
    private BinOp binOp;

    public RelExprComparison(String leftDomainName, String rightDomainName, @Nullable String opDomainName, DomainType leftDomainType, DomainType rightDomainType, @Nullable DomainType opDomainType, BinOp binOp, Context context, Nonterm nonterm) {
        super(context, nonterm, new QueryNode[0]);
        this.leftDomain = leftDomainName;
        this.rightDomain = rightDomainName;
        this.opDomainName = opDomainName;
        this.leftDomainType = leftDomainType;
        this.rightDomainType = rightDomainType;
        this.opDomainType = opDomainType;
        this.binOp = binOp;
    }

    public String getLeftDomain() {
        return this.leftDomain;
    }

    public String getRightDomain() {
        return this.rightDomain;
    }

    public DomainType getLeftDomainType() {
        return this.leftDomainType;
    }

    public DomainType getRightDomainType() {
        return this.rightDomainType;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitComparison(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformReflexive(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        if (this.opDomainName != null) {
            return new Domain[]{variablesManager.getDomain(this.leftDomain), variablesManager.getDomain(this.rightDomain), variablesManager.getDomain(this.opDomainName)};
        }
        return new Domain[]{variablesManager.getDomain(this.leftDomain), variablesManager.getDomain(this.rightDomain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        long startMillis = System.currentTimeMillis();
        long startOpCnt = relationsManager.getBDDManager().getOperationsCnt();
        Domain left = variablesManager.getDomain(this.leftDomain);
        Domain right = variablesManager.getDomain(this.rightDomain);
        if (this.opDomainName != null) {
            List<String> opNames = Arrays.asList(">", "<", ">=", "<=");
            List<BinOp> ops = Arrays.asList(BinOp.GT, BinOp.LT, BinOp.GTEQ, BinOp.LTEQ);
            IRelation result = relationsManager.makeEmptyRelation(this.getDomains(variablesManager, domainsPool));
            for (int i = 0; i < ops.size(); ++i) {
                IRelation oldResult = result;
                int opAttr = symbolTable.findAttributeInt(this.opDomainType, opNames.get(i));
                if (opAttr == -1) continue;
                IRelation rel1 = RelExprComparison.getRelation(relationsManager, threadCallback, left, right, ops.get(i));
                IRelation rel2 = relationsManager.makeSingleTuple(variablesManager.getDomain(this.opDomainName), opAttr);
                result = result.unite(rel1.unsafeIntersect(rel2, threadCallback), threadCallback);
                oldResult.kill();
            }
            return result;
        }
        IRelation result = RelExprComparison.getRelation(relationsManager, threadCallback, left, right, this.binOp);
        if (profileManager != null) {
            long duration = System.currentTimeMillis() - startMillis;
            long opCnt = relationsManager.getBDDManager().getOperationsCnt() - startOpCnt;
            profileManager.addDuration(this, duration, result.getNumOfBDDNodes(), opCnt);
        }
        return result;
    }

    private static IRelation getRelation(IRelationsManager relationsManager, ThreadCallback threadCallback, Domain left, Domain right, BinOp binOp) {
        IRelation result = relationsManager.makeEmptyRelation(new Domain[]{left, right});
        boolean complement = false;
        switch (binOp) {
            case NEQ: {
                complement = true;
            }
            case EQ: {
                result = relationsManager.makeEqual(left, right, threadCallback);
                break;
            }
            case GT: {
                complement = true;
            }
            case LTEQ: {
                result = relationsManager.makeLess(left, right, true, threadCallback);
                break;
            }
            case GTEQ: {
                complement = true;
            }
            case LT: {
                result = relationsManager.makeLess(left, right, false, threadCallback);
            }
        }
        if (complement) {
            IRelation oldResult = result;
            result = result.complement(threadCallback);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprReflexive{leftDomain='" + this.leftDomain + "', rightDomain='" + this.rightDomain + "', binOp=" + this.binOp + "}";
    }

    @Override
    public String toShortString() {
        return "(" + this.leftDomain + " " + this.binOp + " " + this.rightDomain + ")";
    }

    public static enum BinOp {
        EQ,
        NEQ,
        LT,
        GT,
        LTEQ,
        GTEQ;

    }
}

