/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.ast;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.relations.IRelationsManager;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.ProfileManager;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprTransformer;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVisitor;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import com.jetbrains.sourceglider.ui.UIInstancesProvider;

public class RelExprAttributeRegexp
extends RelExpr {
    private String domain;
    private final DomainType domainType;
    private String regexp;
    private boolean equ;

    public RelExprAttributeRegexp(String domainName, DomainType domainType, String regexp, boolean equ, Context context) {
        super(context, new QueryNode[0]);
        this.domain = domainName;
        this.domainType = domainType;
        this.regexp = regexp;
        this.equ = equ;
    }

    public String getDomain() {
        return this.domain;
    }

    public DomainType getDomainType() {
        return this.domainType;
    }

    @Override
    public void accept(RelExprVisitor visitor) {
        visitor.visitAttributeRegexp(this);
    }

    @Override
    public RelExpr transform(RelExprTransformer transformer) {
        return transformer.transformAttributeRegexp(this);
    }

    @Override
    public Domain[] getDomains(RuntimeVariablesManager variablesManager, DomainsPool domainsPool) {
        return new Domain[]{variablesManager.getDomain(this.domain)};
    }

    @Override
    public IRelation interpret(IRelationsManager relationsManager, RuntimeVariablesManager variablesManager, ThreadCallback threadCallback, DomainsPool domainsPool, UIInstancesProvider uiInstancesProvider, SymbolTable symbolTable, ProfileManager profileManager) {
        Domain dom = variablesManager.getDomain(this.domain);
        IRelation result = relationsManager.makeRegExprSet(dom, this.regexp, threadCallback);
        if (!this.equ) {
            IRelation oldResult = result;
            result = result.complement(threadCallback);
            oldResult.kill();
        }
        return result;
    }

    @Override
    public String toLongString() {
        return "RelExprAttributeRegexp{domain='" + this.domain + "', regexp='" + this.regexp + "', equ=" + this.equ + "}";
    }
}

