/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml;

import com.jetbrains.sourceglider.domains.Domain;
import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.IRelation;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraint;
import com.jetbrains.sourceglider.scripts.rml.DomainConstraintCollector;
import com.jetbrains.sourceglider.scripts.rml.DomainsPool;
import com.jetbrains.sourceglider.scripts.rml.RuntimeVariablesManager;
import com.jetbrains.sourceglider.scripts.rml.ast.QueryNode;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprQuantify;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtVisitor;
import com.jetbrains.sourceglider.ui.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ:\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\t0\u0019J\u0018\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0007H\u0016R*\u0010\u0003\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005j\u0002`\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/sourceglider/scripts/rml/DomainsPoolWithConstraints;", "Lcom/jetbrains/sourceglider/scripts/rml/DomainsPool;", "()V", "domainsMap", "", "Lkotlin/Pair;", "", "", "Lcom/jetbrains/sourceglider/scripts/rml/DomainPlace;", "Lcom/jetbrains/sourceglider/domains/Domain;", "arrangeDomains", "", "stmt", "Lcom/jetbrains/sourceglider/scripts/rml/ast/Stmt;", "manager", "Lcom/jetbrains/sourceglider/scripts/rml/RuntimeVariablesManager;", "computeBestDomain", "variablesManager", "domainName", "domainType", "Lcom/jetbrains/sourceglider/domains/DomainType;", "constraints", "", "Lcom/jetbrains/sourceglider/scripts/rml/DomainConstraint;", "usedDomains", "", "getDomain", "node", "Lcom/jetbrains/sourceglider/scripts/rml/ast/QueryNode;", "name", "intellij.c.dfa"})
public final class DomainsPoolWithConstraints
implements DomainsPool {
    private final Map<Pair<Integer, String>, Domain> domainsMap = new LinkedHashMap();

    @Override
    @NotNull
    public Domain getDomain(@NotNull QueryNode node, @NotNull String name) {
        Domain domain = this.domainsMap.get(new Pair((Object)node.getAstNodeId(), (Object)name));
        Intrinsics.checkNotNull((Object)domain);
        return domain;
    }

    public final void arrangeDomains(@NotNull Stmt stmt, @NotNull RuntimeVariablesManager manager2) {
        DomainConstraintCollector domainConstraintCollector = new DomainConstraintCollector(manager2);
        stmt.accept(domainConstraintCollector);
        stmt.accept(new StmtVisitor(this, manager2, domainConstraintCollector){
            private Set<Domain> usedDomains;
            final /* synthetic */ DomainsPoolWithConstraints this$0;
            final /* synthetic */ RuntimeVariablesManager $manager;
            final /* synthetic */ DomainConstraintCollector $domainConstraintCollector;

            public final void pushDomain(@NotNull Domain domain) {
                this.usedDomains.add(domain);
            }

            public final void popDomain(@NotNull Domain domain) {
                if (!this.usedDomains.contains(domain)) {
                    throw (Throwable)new RuntimeException(Messages.getString(DomainsPool.class.getName() + "-0"));
                }
                this.usedDomains.remove(domain);
            }

            public final void assertEmpty() {
                if (!this.usedDomains.isEmpty()) {
                    throw (Throwable)new RuntimeException(Messages.getString(DomainsPool.class.getName() + "-1"));
                }
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitRelAssignStart(@NotNull StmtRelAssign stmt) {
                void $this$mapTo$iv$iv;
                IRelation relation = this.$manager.getRelation(stmt.getRelName());
                Iterable $this$map$iv = (Iterable)ArraysKt.getIndices((Object[])stmt.getDomainNames());
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                while (iterator.hasNext()) {
                    void it;
                    int item$iv$iv;
                    int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    List constraints = ArraysKt.toList((Object[])this.$domainConstraintCollector.getAssignConstraints(stmt)[it]);
                    String domainName = stmt.getDomainNames()[it];
                    Domain domain = this.this$0.computeBestDomain(this.$manager, domainName, relation.getDomainTypes()[it], constraints, this.usedDomains);
                    DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).put(new Pair((Object)stmt.getAstNodeId(), (Object)domainName), domain);
                    this.pushDomain(domain);
                    Unit unit = Unit.INSTANCE;
                    collection.add(unit);
                }
                List cfr_ignored_0 = (List)destination$iv$iv;
                return true;
            }

            public void visitRelAssignEnd(@NotNull StmtRelAssign stmt) {
                String[] $this$forEach$iv = stmt.getDomainNames();
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    String element$iv;
                    String it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    V v = DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).get(new Pair((Object)stmt.getAstNodeId(), (Object)it));
                    Intrinsics.checkNotNull(v);
                    this.popDomain((Domain)v);
                }
                this.assertEmpty();
            }

            /*
             * WARNING - void declaration
             */
            public boolean visitPrintStart(@NotNull StmtPrint stmt) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = stmt.getPrintTypes();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Integer it = (Integer)element$iv$iv;
                    boolean bl = false;
                    Integer n = it;
                    boolean bl2 = false;
                    if (!(n != null && n == 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    void $this$mapTo$iv$iv;
                    Integer it = (Integer)element$iv;
                    boolean bl = false;
                    E e = stmt.getPrintValues().get(it);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint.RelationPrintBundle");
                    }
                    StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)e;
                    Iterable $this$map$iv = (Iterable)CollectionsKt.getIndices((Collection)bundle.domainNames);
                    boolean $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        void it2;
                        int item$iv$iv;
                        int n = item$iv$iv = ((IntIterator)iterator).nextInt();
                        Collection collection = destination$iv$iv2;
                        boolean bl3 = false;
                        List constraints = ArraysKt.toList((Object[])this.$domainConstraintCollector.getPrintConstraints(bundle)[it2]);
                        String domainName = bundle.domainNames.get((int)it2);
                        E e2 = bundle.domainTypes.get((int)it2);
                        if (e2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.sourceglider.domains.DomainType");
                        }
                        Domain domain = this.this$0.computeBestDomain(this.$manager, domainName, (DomainType)e2, constraints, this.usedDomains);
                        DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).put(new Pair((Object)stmt.getAstNodeId(), (Object)domainName), domain);
                        this.pushDomain(domain);
                        Unit unit = Unit.INSTANCE;
                        collection.add(unit);
                    }
                    List cfr_ignored_0 = (List)destination$iv$iv2;
                }
                return true;
            }

            /*
             * WARNING - void declaration
             */
            public void visitPrintEnd(@NotNull StmtPrint stmt) {
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = stmt.getPrintTypes();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Integer it = (Integer)element$iv$iv;
                    boolean bl = false;
                    Integer n = it;
                    boolean bl2 = false;
                    if (!(n != null && n == 0)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$forEach$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    Integer it = (Integer)element$iv;
                    boolean bl = false;
                    E e = stmt.getPrintValues().get(it);
                    if (e == null) {
                        throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.sourceglider.scripts.rml.ast.StmtPrint.RelationPrintBundle");
                    }
                    StmtPrint.RelationPrintBundle bundle = (StmtPrint.RelationPrintBundle)e;
                    Iterable $this$forEach$iv2 = bundle.domainNames;
                    boolean $i$f$forEach2 = false;
                    for (T element$iv2 : $this$forEach$iv2) {
                        String it2 = (String)element$iv2;
                        boolean bl3 = false;
                        V v = DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).get(new Pair((Object)stmt.getAstNodeId(), (Object)it2));
                        Intrinsics.checkNotNull(v);
                        this.popDomain((Domain)v);
                    }
                }
                this.assertEmpty();
            }

            public boolean visitQuantifyStart(@NotNull RelExprQuantify expr) {
                DomainType type = expr.getTypeRef().resolve(this.$manager);
                Domain domain = this.this$0.computeBestDomain(this.$manager, expr.getQuantifier(), type, this.$domainConstraintCollector.getQuantifyConstraints(expr), this.usedDomains);
                DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).put(new Pair((Object)expr.getAstNodeId(), (Object)expr.getQuantifier()), domain);
                this.pushDomain(domain);
                return true;
            }

            public void visitQuantifyEnd(@NotNull RelExprQuantify expr) {
                V v = DomainsPoolWithConstraints.access$getDomainsMap$p(this.this$0).get(new Pair((Object)expr.getAstNodeId(), (Object)expr.getQuantifier()));
                Intrinsics.checkNotNull(v);
                this.popDomain((Domain)v);
            }
            {
                this.this$0 = this$0;
                this.$manager = $captured_local_variable$1;
                this.$domainConstraintCollector = $captured_local_variable$2;
                this.usedDomains = new LinkedHashSet<E>();
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Domain computeBestDomain(@NotNull RuntimeVariablesManager variablesManager, @NotNull String domainName, @NotNull DomainType domainType, @NotNull List<? extends DomainConstraint> constraints, @NotNull Set<? extends Domain> usedDomains) {
        int i;
        boolean[] been = new boolean[constraints.size()];
        int maxCost = -1;
        Domain bestDomain = null;
        int n = 0;
        int n2 = ((Collection)constraints).size();
        while (n < n2) {
            Domain domain;
            if (!been[i] && !usedDomains.contains(domain = constraints.get(i).getDomain(variablesManager))) {
                boolean bl = false;
                int cost = 0;
                int n3 = 0;
                int n4 = ((Collection)constraints).size();
                while (n3 < n4) {
                    void j;
                    if (Intrinsics.areEqual((Object)constraints.get((int)j).getDomain(variablesManager), (Object)domain)) {
                        been[j] = true;
                        if (Intrinsics.areEqual((Object)constraints.get((int)j).getDomainName(), (Object)domainName)) {
                            ++cost;
                        } else {
                            bl = true;
                            break;
                        }
                    }
                    ++j;
                }
                if (!bl && cost > maxCost) {
                    maxCost = cost;
                    bestDomain = domain;
                }
            }
            ++i;
        }
        if (maxCost > -1) {
            Domain domain = bestDomain;
            Intrinsics.checkNotNull((Object)domain);
            return domain;
        }
        i = 0;
        while (true) {
            Domain domain = domainType.getDomain(i);
            boolean unique = true;
            if (usedDomains.contains(domain)) {
                ++i;
                continue;
            }
            for (DomainConstraint domainConstraint : constraints) {
                if (!Intrinsics.areEqual((Object)domainConstraint.getDomain(variablesManager), (Object)domain)) continue;
                unique = false;
                break;
            }
            if (unique) {
                return domain;
            }
            ++i;
        }
    }

    public static final /* synthetic */ Map access$getDomainsMap$p(DomainsPoolWithConstraints $this) {
        return $this.domainsMap;
    }
}

