/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.bdd;

import com.jetbrains.sourceglider.bdd.IBDD;
import com.jetbrains.sourceglider.ui.IConfigs;
import com.jetbrains.sourceglider.ui.ThreadCallback;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public interface IBDDManager {
    public static final String KEY_BDD_NATIVE_LIBRARY = "BDDNativeLibrary";
    public static final String KEY_BDD_MAX_OP_CACHE_SIZE = "BDDMaxOpCacheSize";
    public static final String KEY_BDD_MAX_NODE_CACHE_SIZE = "BDDMaxNodeCacheSize";
    public static final String KEY_BDD_ENABLE_GC = "BDDEnableGC";
    public static final String KEY_BDD_GARBAGE_COLLECT_RATE = "BDDGarbageCollectRate";
    public static final String KEY_BDD_STATISTICS = "BDDStatistics";
    public static final String DEFAULT_BDD_NATIVE_LIBRARY = "engine-native";
    public static final int DEFAULT_MAX_OP_CACHE_SIZE = 4000000;
    public static final int DEFAULT_MAX_NODE_CACHE_SIZE = 10000000;
    public static final int DEFAULT_GARBAGE_COLLECT_RATE = 1000000;
    public static final boolean DEFAULT_ENABLE_GC = true;

    public void startInit();

    public void init(IConfigs var1);

    public int getManagerSerialID();

    public String[] getInfo();

    public int getMemoryState();

    public long getOperationsCnt();

    public void collectGarbage();

    public boolean decRefCountOnGC();

    public IBDD getZero();

    public IBDD getOne();

    public IBDD makeEquals(int var1, int var2);

    public IBDD makeSingleTuple(int var1, int var2, int var3);

    public IBDD makeSingleTuple(int[] var1, int[] var2, int[] var3);

    public IBDD makeLess(int var1, int var2, int var3, boolean var4);

    public void serialize(ObjectOutputStream var1, IBDD[] var2, ThreadCallback var3, double var4, String var6) throws IOException;

    public IBDD[] deserialize(ObjectInputStream var1, ThreadCallback var2, double var3, String var5) throws IOException, ClassNotFoundException;
}

