/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.atttributes;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.utils.PrettyName;

public class Attribute
implements Comparable {
    private String key;
    private DomainType type;
    private String compUnitPath;
    private int srcPos;
    private int srcLength;
    private PrettyName prettyName;

    public Attribute(String key, DomainType type, String compUnitPath, int srcPos, int srcLength, PrettyName prettyName) {
        this.key = key;
        this.type = type;
        this.compUnitPath = compUnitPath;
        this.srcPos = srcPos;
        this.srcLength = srcLength;
        this.prettyName = prettyName;
    }

    public String getKey() {
        return this.key;
    }

    public DomainType getType() {
        return this.type;
    }

    public void setType(DomainType type) {
        this.type = type;
    }

    public String getCompUnitPath() {
        return this.compUnitPath;
    }

    public int getSrcPos() {
        return this.srcPos;
    }

    public int getSrcLength() {
        return this.srcLength;
    }

    public PrettyName getPrettyName() {
        return this.prettyName;
    }

    public boolean isRevealable() {
        return this.type.isRevealable() && this.compUnitPath != null && this.srcPos != -1;
    }

    public String toString() {
        return this.prettyName.getMarked();
    }

    public int compareTo(Object obj) {
        Long left = Attribute.getInt(this.key);
        Long right = Attribute.getInt(((Attribute)obj).key);
        if (left == Long.MAX_VALUE && right == Long.MAX_VALUE) {
            return this.key.compareTo(((Attribute)obj).key);
        }
        return Long.compare(left, right);
    }

    private static Long getInt(String key) {
        if (key.equals("-inf")) {
            return -8589934592L;
        }
        if (key.equals("+inf")) {
            return 0x1FFFFFFFCL;
        }
        try {
            long value = Long.parseLong(key);
            return Math.max(-8589934592L, Math.min(0x1FFFFFFFCL, value));
        }
        catch (NumberFormatException e) {
            return Long.MAX_VALUE;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Attribute)) {
            return false;
        }
        Attribute attribute = (Attribute)obj;
        return this.key.equals(attribute.key) && this.type == attribute.type;
    }

    public int hashCode() {
        return this.key.hashCode() * 31 + this.type.hashCode();
    }
}

