/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.gsa.files;

import com.jetbrains.gsa.data.ListElem;
import com.jetbrains.gsa.others.GSAException;
import com.jetbrains.gsa.text.WriteString;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class File
extends ListElem {
    protected String filename;
    protected WriteString data;
    public static String packageName = null;

    public File(String filename) {
        this.filename = filename;
        this.data = new WriteString();
    }

    public void collect() throws GSAException {
        if (packageName != null) {
            this.data.appendf("package " + packageName + ";\n\n");
        }
    }

    public void writeToDisk(boolean rewriteIfExists) throws GSAException {
        if (!rewriteIfExists) {
            try {
                new FileInputStream(this.filename);
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            new java.io.File(this.filename).getParentFile().mkdirs();
            FileOutputStream file2 = new FileOutputStream(this.filename);
            String str = this.data.toString();
            for (int i = 0; i < str.length(); ++i) {
                ((OutputStream)file2).write(str.charAt(i));
            }
        }
        catch (FileNotFoundException ex) {
            throw new GSAException("File " + this.filename + " not found");
        }
        catch (IOException ex) {
            throw new GSAException("Can't open the file " + this.filename + " for writing");
        }
    }
}

