/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cmake.CMakeBundle;
import java.util.function.Supplier;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Case {
    TO_UPPER(0, (Supplier)CMakeBundle.messagePointer("cmake.settings.case.to.upper", new Object[0])){

        @Override
        @NotNull
        public String apply(@NonNls @NotNull String text) {
            return StringUtil.toUpperCase((String)text);
        }
    }
    ,
    TO_LOWER(1, (Supplier)CMakeBundle.messagePointer("cmake.settings.case.to.lower", new Object[0])){

        @Override
        @NotNull
        public String apply(@NonNls @NotNull String text) {
            return StringUtil.toLowerCase((String)text);
        }
    }
    ,
    DO_NOT_CHANGE(2, (Supplier)CMakeBundle.messagePointer("cmake.settings.case.do.not.change", new Object[0])){

        @Override
        @NotNull
        public String apply(@NotNull String text) {
            return text;
        }
    };

    private final int myValue;
    private final @NotNull Supplier<@Nls String> myUiDescription;

    @Nullable
    public static Case resolveByValue(int value) {
        for (int i = 0; i < Case.values().length; ++i) {
            Case aCase = Case.values()[i];
            if (aCase.getValue() != value) continue;
            return aCase;
        }
        return null;
    }

    private Case(int value, Supplier<String> uiDescription) {
        this.myValue = value;
        this.myUiDescription = uiDescription;
    }

    @Nls
    @NotNull
    public String getUiDescription() {
        return this.myUiDescription.get();
    }

    public int getValue() {
        return this.myValue;
    }

    @NotNull
    public abstract String apply(@NotNull String var1);

    public static String @NotNull [] getTokenCaseNames() {
        String[] caseNames = new String[Case.values().length];
        for (int i = 0; i < Case.values().length; ++i) {
            caseNames[i] = Case.values()[i].getUiDescription();
        }
        return caseNames;
    }

    public static int @NotNull [] getTokenCaseValues() {
        int[] caseValues = new int[Case.values().length];
        for (int i = 0; i < Case.values().length; ++i) {
            caseValues[i] = i;
        }
        return caseValues;
    }
}

