/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.SmartIndentOptionsEditor;
import com.intellij.lang.Language;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizableOptions;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.jetbrains.cmake.CMakeBundle;
import com.jetbrains.cmake.CMakeLanguage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return CMakeLanguage.INSTANCE;
    }

    @NotNull
    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        switch (settingsType) {
            case SPACING_SETTINGS: {
                return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Spaces.cmake");
            }
            case INDENT_SETTINGS: {
                return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Indent.cmake");
            }
            case WRAPPING_AND_BRACES_SETTINGS: {
                return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Wrapping.cmake");
            }
            case BLANK_LINES_SETTINGS: {
                return CodeStyleAbstractPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"Blank_lines.cmake");
            }
        }
        return "";
    }

    @Nullable
    public IndentOptionsEditor getIndentOptionsEditor() {
        return new SmartIndentOptionsEditor();
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.INDENT_SETTINGS) {
            consumer.showStandardOptions(new String[]{"INDENT_SIZE"});
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.SPACING_SETTINGS) {
            consumer.showStandardOptions(new String[]{"SPACE_BEFORE_METHOD_CALL_PARENTHESES", "SPACE_WITHIN_METHOD_CALL_PARENTHESES", "SPACE_BEFORE_METHOD_PARENTHESES", "SPACE_WITHIN_METHOD_PARENTHESES", "SPACE_BEFORE_IF_PARENTHESES", "SPACE_WITHIN_IF_PARENTHESES", "SPACE_BEFORE_WHILE_PARENTHESES", "SPACE_WITHIN_WHILE_PARENTHESES", "SPACE_BEFORE_FOR_PARENTHESES", "SPACE_WITHIN_FOR_PARENTHESES"});
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_CALL_PARENTHESES", CMakeBundle.message("cmake.settings.formatter.spaceBeforeMethodCallParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_BEFORE_METHOD_PARENTHESES", CMakeBundle.message("cmake.settings.formatter.spaceBeforeMethodParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_CALL_PARENTHESES", CMakeBundle.message("cmake.settings.formatter.spaceWithinMethodCallParentheses", new Object[0]));
            consumer.renameStandardOption("SPACE_WITHIN_METHOD_PARENTHESES", CMakeBundle.message("cmake.settings.formatter.spaceWithinMethodParentheses", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.WRAPPING_AND_BRACES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"ALIGN_MULTILINE_PARAMETERS_IN_CALLS"});
            consumer.renameStandardOption(CodeStyleSettingsCustomizableOptions.getInstance().WRAPPING_METHOD_ARGUMENTS_WRAPPING, CMakeBundle.message("cmake.settings.formatter.commandCallArguments", new Object[0]));
        } else if (settingsType == LanguageCodeStyleSettingsProvider.SettingsType.BLANK_LINES_SETTINGS) {
            consumer.showStandardOptions(new String[]{"KEEP_BLANK_LINES_IN_CODE"});
        }
    }
}

