/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.resolve;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.cache.CacheManager;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.CMakeRoutine;
import com.jetbrains.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cmake.resolve.CMakeCommandReferenceHelper;
import com.jetbrains.cmake.resolve.CMakeResolveLog;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CMakeCommandReference
extends PsiReferenceBase<PsiElement>
implements PsiPolyVariantReference {
    private static final boolean USE_CACHE = true;

    public CMakeCommandReference(PsiElement element, TextRange textRange) {
        super(element, textRange);
    }

    public boolean isReferenceTo(@NotNull PsiElement element) {
        if (CMakeCommandReferenceHelper.commandNamesEqualByText(element, this.myElement)) {
            CMakeArgument cMakeArgument;
            if (CMakeCommandReferenceHelper.isCommandCall(element)) {
                return true;
            }
            if (CMakeCommandReferenceHelper.isCommandDefinition(element) && (cMakeArgument = CMakeCommandReferenceHelper.getCMakeArgument(element)).isCommandDefinitionName()) {
                return true;
            }
        }
        return false;
    }

    public ResolveResult @NotNull [] multiResolve(boolean incompleteCode) {
        ResolveCache cache = ResolveCache.getInstance((Project)this.getElement().getProject());
        return cache.resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode1) -> reference.multiResolveWithoutCaching(), false, incompleteCode);
    }

    protected ResolveResult[] multiResolveWithoutCaching() {
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        this.fillCommandsFromProject(commands, true);
        return commands.toArray(ResolveResult.EMPTY_ARRAY);
    }

    private List<ResolveResult> fillCommandReferencesFromModule(@NotNull List<ResolveResult> commands, @NotNull PsiFile containingFile, @Nullable Module module, boolean checkForTextEquality) {
        if (module != null) {
            List virtualFiles;
            if (checkForTextEquality) {
                CacheManager cacheManager = CacheManager.getInstance((Project)module.getProject());
                virtualFiles = ContainerUtil.filter((Object[])cacheManager.getVirtualFilesWithWord(this.myElement.getText(), (short)255, module.getModuleWithLibrariesScope(), true), file2 -> FileTypeRegistry.getInstance().isFileOfType(file2, CMakeListsFileType.INSTANCE));
            } else {
                virtualFiles = new ArrayList();
                ArrayList finalVirtualFiles = virtualFiles;
                FileTypeIndex.processFiles((FileType)CMakeListsFileType.INSTANCE, file2 -> {
                    finalVirtualFiles.add(file2);
                    return true;
                }, (GlobalSearchScope)module.getModuleWithLibrariesScope());
            }
            virtualFiles.sort((o1, o2) -> o1.getPath().compareToIgnoreCase(o2.getPath()));
            for (VirtualFile virtualFile : virtualFiles) {
                PsiFile psiFile = this.myElement.getManager().findFile(virtualFile);
                if (containingFile.equals(psiFile)) continue;
                this.fillCommandsFromFile(commands, psiFile, checkForTextEquality);
            }
        }
        return commands;
    }

    private List<ResolveResult> fillCommandsFromFile(final @NotNull List<ResolveResult> commands, @Nullable PsiFile file2, final boolean checkForTextEquality) {
        PsiTreeUtil.processElements((PsiElement)file2, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                boolean isCommandDefinition = element instanceof CMakeRoutine;
                if (isCommandDefinition) {
                    boolean isCommandDefinitionName;
                    CMakeArgument argumentElement = ((CMakeRoutine)element).getFirstArgument();
                    boolean argumentExists = argumentElement != null;
                    boolean bl = isCommandDefinitionName = argumentExists && argumentElement.isCommandDefinitionName();
                    if (isCommandDefinitionName) {
                        if (checkForTextEquality) {
                            boolean isOurCommandName;
                            CMakeLiteral cMakeLiteral = argumentElement.getCMakeLiteral();
                            boolean bl2 = isOurCommandName = cMakeLiteral != null && cMakeLiteral.getText().equalsIgnoreCase(CMakeCommandReference.this.myElement.getText());
                            if (isOurCommandName) {
                                commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                                return true;
                            }
                        } else {
                            commands.add(new PsiElementResolveResult((PsiElement)argumentElement));
                            return true;
                        }
                    }
                }
                return true;
            }
        });
        return commands;
    }

    @Nullable
    public PsiElement resolve() {
        ResolveResult[] resolveResults = this.multiResolve(false);
        return resolveResults.length == 1 ? resolveResults[0].getElement() : null;
    }

    public Object @NotNull [] getVariants() {
        List<ResolveResult> commands = this.collectCommandsFromProjectOrCache();
        Object[] completionForCommandDefinition = this.getCompletionForCommandDefinition();
        if (completionForCommandDefinition != null) {
            return completionForCommandDefinition;
        }
        return this.getCompletion(commands);
    }

    @NotNull
    private List<ResolveResult> collectCommandsFromProjectOrCache() {
        ArrayList<ResolveResult> commands = new ArrayList<ResolveResult>();
        ResolveCache cache = ResolveCache.getInstance((Project)this.getElement().getProject());
        ContainerUtil.addAll(commands, (Object[])cache.resolveWithCaching((PsiPolyVariantReference)this, (reference, incompleteCode) -> {
            ArrayList<ResolveResult> cacheResults = new ArrayList<ResolveResult>();
            this.fillCommandsFromProject(cacheResults, false);
            return cacheResults.toArray(ResolveResult.EMPTY_ARRAY);
        }, false, false));
        return commands;
    }

    private Object @Nullable [] getCompletionForCommandDefinition() {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        if (this.myElement instanceof CMakeArgument) {
            if (((CMakeArgument)this.myElement).isCommandDefinitionName()) {
                return LookupElement.EMPTY_ARRAY;
            }
            if (((CMakeArgument)this.myElement).isEndCommandDefinitionName()) {
                CMakeArgument commandDefinitionName = ((CMakeArgument)this.myElement).getCommandDefinitionName();
                if (commandDefinitionName != null) {
                    variants.add(CMakeCompletionUtils.createCommandItem(commandDefinitionName.getText(), this.myElement.getContainingFile().getName(), Collections.emptyList(), true, false));
                }
                return variants.toArray();
            }
        }
        return null;
    }

    private Object @NotNull [] getCompletion(List<ResolveResult> commands) {
        ArrayList<LookupElement> variants = new ArrayList<LookupElement>();
        for (ResolveResult command : commands) {
            PsiElement psiElement = command.getElement();
            CMakeResolveLog.LOG.assertTrue(psiElement instanceof CMakeArgument);
            CMakeArgument cMakeArgument = (CMakeArgument)psiElement;
            CMakeLiteral cMakeLiteral = cMakeArgument.getCMakeLiteral();
            CMakeResolveLog.LOG.assertTrue(cMakeLiteral != null);
            String textToComplete = CMakeCompletionUtils.convertCommandToProperCase(psiElement.getContainingFile(), cMakeLiteral.getText());
            List<CMakeArgument> argumentList = cMakeArgument.getParentCommandArguments().getCMakeArgumentList();
            List<CMakeArgument> argumentsInCompletion = argumentList.subList(1, argumentList.size());
            String filename = CMakeFileLocationUtil.getLocationInFile(psiElement, false);
            boolean addParentheses = !(this.myElement instanceof CMakeArgument);
            variants.add(CMakeCompletionUtils.createCommandItem(textToComplete, filename, argumentsInCompletion, cMakeArgument.isFunctionName(), addParentheses));
        }
        return variants.toArray();
    }

    private void fillCommandsFromProject(@NotNull List<ResolveResult> commands, boolean checkForTextEquality) {
        PsiFile currentFile = this.myElement.getContainingFile();
        if (currentFile != null) {
            this.fillCommandsFromFile(commands, currentFile, checkForTextEquality);
            VirtualFile virtualFile = currentFile.getVirtualFile();
            if (virtualFile == null) {
                virtualFile = currentFile.getOriginalFile().getVirtualFile();
            }
            if (virtualFile != null) {
                Module module = ProjectRootManager.getInstance((Project)this.myElement.getProject()).getFileIndex().getModuleForFile(virtualFile);
                this.fillCommandReferencesFromModule(commands, currentFile, module, checkForTextEquality);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        PsiReferenceBase base = (PsiReferenceBase)o;
        if (this.getElement() != null ? !this.getElement().equals(base.getElement()) : base.getElement() != null) {
            return false;
        }
        return !(this.getRangeInElement() != null ? !this.getRangeInElement().equals((Object)base.getRangeInElement()) : base.getRangeInElement() != null);
    }

    public int hashCode() {
        int result = this.getElement() != null ? this.getElement().hashCode() : 0;
        result = 31 * result + (this.getRangeInElement() != null ? this.getRangeInElement().hashCode() : 0);
        return result;
    }
}

