/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.refactoring;

import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.PsiElementRenameHandler;
import com.jetbrains.cmake.completion.contributors.providers.CMakeCommandProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeLiteral;
import org.jetbrains.annotations.NotNull;

public class CMakeRenameHandler
extends PsiElementRenameHandler {
    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        PsiElement psiElementToRename = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        return psiElementToRename instanceof CMakeArgument || psiElementToRename instanceof CMakeLiteral || psiElementToRename instanceof CMakeCommandNameMixin;
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2, @NotNull DataContext dataContext) {
        if (CMakeRenameHandler.shouldInvokeRefactoring(dataContext)) {
            super.invoke(project2, editor, file2, dataContext);
        }
    }

    public static boolean shouldInvokeRefactoring(DataContext dataContext) {
        PsiElement psiElementToRename = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        CMakeArgument argumentToRename = null;
        if (psiElementToRename instanceof CMakeLiteral) {
            argumentToRename = ((CMakeLiteral)psiElementToRename).getArgument();
        } else if (psiElementToRename instanceof CMakeArgument) {
            argumentToRename = (CMakeArgument)psiElementToRename;
        }
        if (argumentToRename != null && (argumentToRename.isCommandDefinitionName() || argumentToRename.isEndCommandDefinitionName())) {
            return true;
        }
        if (psiElementToRename instanceof CMakeCommandName) {
            return !CMakeCommandProvider.isStandardCommand(psiElementToRename.getText());
        }
        return false;
    }
}

