/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterBase;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.cmake.psi.CMakeHighlightingLexer;
import com.jetbrains.cmake.psi.CMakeTokenTypes;
import com.jetbrains.cmake.psi.CMakeVarReferenceLexer;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSyntaxHighlighterFactory
extends SyntaxHighlighterFactory {
    public static final TextAttributesKey KEYWORD = DefaultLanguageHighlighterColors.KEYWORD;
    public static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    @NotNull
    public SyntaxHighlighter getSyntaxHighlighter(@Nullable Project project2, @Nullable VirtualFile virtualFile) {
        return new Highlighter();
    }

    static {
        ATTRIBUTES.put(CMakeTokenTypes.LPAR, DefaultLanguageHighlighterColors.PARENTHESES);
        ATTRIBUTES.put(CMakeTokenTypes.RPAR, DefaultLanguageHighlighterColors.PARENTHESES);
        ATTRIBUTES.put(CMakeTokenTypes.COMMENT, DefaultLanguageHighlighterColors.LINE_COMMENT);
        ATTRIBUTES.put(CMakeTokenTypes.SEMI, DefaultLanguageHighlighterColors.SEMICOLON);
        ATTRIBUTES.put(CMakeTokenTypes.LITERAL, DefaultLanguageHighlighterColors.STRING);
        ATTRIBUTES.put(CMakeHighlightingLexer.BRACKET_LITERAL, DefaultLanguageHighlighterColors.STRING);
        ATTRIBUTES.put(CMakeTokenTypes.ID, DefaultLanguageHighlighterColors.IDENTIFIER);
        ATTRIBUTES.put(CMakeTokenTypes.IF, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ELSE, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ELSEIF, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ENDIF, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.WHILE, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ENDWHILE, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.FOREACH, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ENDFOREACH, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.FUNCTION, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ENDFUNCTION, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.MACRO, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.ENDMACRO, KEYWORD);
        ATTRIBUTES.put(CMakeTokenTypes.BRACKET_ARG_START, DefaultLanguageHighlighterColors.BRACKETS);
        ATTRIBUTES.put(CMakeTokenTypes.BRACKET_ARG_END, DefaultLanguageHighlighterColors.BRACKETS);
        ATTRIBUTES.put(CMakeVarReferenceLexer.VAR_REFERENCE_START, DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        ATTRIBUTES.put(CMakeVarReferenceLexer.VAR_REFERENCE_END, DefaultLanguageHighlighterColors.VALID_STRING_ESCAPE);
        ATTRIBUTES.put(CMakeVarReferenceLexer.VAR_REFERENCE_NAME, DefaultLanguageHighlighterColors.STRING);
        ATTRIBUTES.put(TokenType.BAD_CHARACTER, DefaultLanguageHighlighterColors.INVALID_STRING_ESCAPE);
    }

    private static class Highlighter
    extends SyntaxHighlighterBase {
        private Highlighter() {
        }

        @NotNull
        public Lexer getHighlightingLexer() {
            return new CMakeHighlightingLexer();
        }

        public TextAttributesKey @NotNull [] getTokenHighlights(IElementType type) {
            return Highlighter.pack((TextAttributesKey)ATTRIBUTES.get(type));
        }
    }
}

