/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.CMakeCompletionUtils;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeArgumentImplMixin;
import com.jetbrains.cmake.psi.CMakeCommandArguments;
import com.jetbrains.cmake.psi.CMakeElementBase;
import com.jetbrains.cmake.psi.CMakeRoutineCommandMixin;
import com.jetbrains.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cmake.resolve.CMakeRenameUtils;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeRoutineCommandImplMixin
extends CMakeElementBase
implements CMakeRoutineCommandMixin {
    public CMakeRoutineCommandImplMixin(@NotNull ASTNode node) {
        super(node);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        CMakeRenameUtils.renameCommandCall(this.getProject(), name, this.getFirstChild().getNode());
        return this;
    }

    public String getName() {
        CMakeArgument argument = this.getFirstArgument();
        if (argument != null) {
            return argument.getText();
        }
        return null;
    }

    @Nullable
    public Icon getIcon(int flags) {
        CMakeArgument argument = this.getFirstArgument();
        if (argument != null) {
            return CMakeCompletionUtils.getRoutineIcon(argument.isFunctionName() || argument.isEndFunctionName());
        }
        return null;
    }

    @Override
    @Nullable
    public CMakeArgument getFirstArgument() {
        CMakeCommandArguments args = (CMakeCommandArguments)PsiTreeUtil.findChildOfType((PsiElement)this, CMakeCommandArguments.class);
        List<CMakeArgument> arguments2 = args == null ? null : args.getCMakeArgumentList();
        return (CMakeArgument)ContainerUtil.getFirstItem(arguments2);
    }

    @Override
    @NotNull
    public CMakeArgument getFirstArgumentNotNull() {
        return Objects.requireNonNull(this.getFirstArgument());
    }

    public ItemPresentation getPresentation() {
        return new ItemPresentation(){

            @Nullable
            public String getPresentableText() {
                CMakeArgument cMakeArgument = CMakeRoutineCommandImplMixin.this.getFirstArgument();
                if (cMakeArgument instanceof CMakeArgumentImplMixin) {
                    return ((CMakeArgumentImplMixin)cMakeArgument).getPresentation().getPresentableText();
                }
                return CMakeRoutineCommandImplMixin.this.getText();
            }

            @Nullable
            public String getLocationString() {
                return CMakeFileLocationUtil.getLocationInFile(CMakeRoutineCommandImplMixin.this, false);
            }

            @Nullable
            public Icon getIcon(boolean unused) {
                return CMakeRoutineCommandImplMixin.this.getIcon(0);
            }
        };
    }
}

