/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.psi;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.refactoring.rename.FragmentaryPsiReference;
import com.intellij.util.IncorrectOperationException;
import com.jetbrains.cmake.CMakeFileLocationProvider;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeFileReferenceSet;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import com.jetbrains.cmake.resolve.CMakeResolveLog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CMakeFileReference
extends FileReference
implements FragmentaryPsiReference {
    @NotNull
    private static final RecursionGuard<CMakeFileReference> ourGuard = RecursionManager.createGuard((String)"CMakeFileReference_resolve_guard");
    private static final int STACK_LIMIT = 100;
    @NotNull
    protected final CMakeFileReferenceSet cmakeFileReferenceSet;
    protected final boolean isExpressionRef;

    CMakeFileReference(@NotNull CMakeFileReferenceSet fileReferenceSet, @NotNull TextRange range, int index, @NotNull String text) {
        super((FileReferenceSet)fileReferenceSet, range, index, text);
        this.cmakeFileReferenceSet = fileReferenceSet;
        this.isExpressionRef = CMakePsiUtils.isVariableRef(text);
        if (this.isExpressionRef) {
            this.cmakeFileReferenceSet.setFragmentOnlyRename(true);
        }
    }

    protected ResolveResult @NotNull [] innerResolve(boolean caseSensitive, @NotNull PsiFile containingFile) {
        if (CMakePsiUtils.isVariableRef(this.getText())) {
            return this.resolveVariable(containingFile);
        }
        if (ourGuard.currentStack().size() > 100) {
            CMakeResolveLog.LOG.warn("Too long path for resolve. Stack overflow was prevented for:" + StringUtil.first((String)this.getText(), (int)50, (boolean)true));
            ourGuard.prohibitResultCaching((Object)this);
            return ResolveResult.EMPTY_ARRAY;
        }
        ResolveResult[] resolveResults = (ResolveResult[])ourGuard.doPreventingRecursion((Object)this, false, () -> super.innerResolve(caseSensitive, containingFile));
        return resolveResults == null ? ResolveResult.EMPTY_ARRAY : resolveResults;
    }

    @NotNull
    public PsiElement handleElementRename(@NotNull String newElementName) throws IncorrectOperationException {
        return this.isReadOnlyFragment() ? this.getElement() : super.handleElementRename(newElementName);
    }

    private ResolveResult @NotNull [] resolveVariable(@NotNull PsiFile containingFile) {
        String varName = this.getText().substring(1);
        if (varName.startsWith("{")) {
            int pos = varName.indexOf(125, 1);
            String string = varName = pos < 1 ? "" : varName.substring(1, pos);
        }
        if (!varName.isEmpty()) {
            PsiFile element = null;
            if (varName.equals("CMAKE_CURRENT_LIST_FILE")) {
                element = containingFile;
            } else if (varName.equals("CMAKE_CURRENT_LIST_DIR") || varName.equals("CMAKE_CURRENT_SOURCE_DIR")) {
                element = containingFile.getParent();
            } else if (varName.equals("PROJECT_SOURCE_DIR")) {
                Project project2 = containingFile.getProject();
                for (CMakeFileLocationProvider provider : CMakeFileLocationProvider.EP_NAME.getExtensionList()) {
                    VirtualFile projectBaseDir = provider.getProjectBaseDir(project2);
                    if (projectBaseDir == null) continue;
                    element = PsiManager.getInstance((Project)project2).findDirectory(projectBaseDir);
                    break;
                }
            }
            if (element != null) {
                return new ResolveResult[]{new PsiElementResolveResult((PsiElement)element, false)};
            }
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    public Object @NotNull [] getVariants() {
        CMakeArgument thisArgument;
        if (this.getElement() instanceof CMakeLiteral && ((thisArgument = ((CMakeLiteral)this.getElement()).getArgument()).isCommandDefinitionName() || thisArgument.isEndCommandDefinitionName())) {
            return LookupElement.EMPTY_ARRAY;
        }
        return super.getVariants();
    }

    public boolean isReadOnlyFragment() {
        return this.isExpressionRef;
    }

    public boolean isFragmentOnlyRename() {
        return this.cmakeFileReferenceSet.isFragmentOnlyRename();
    }

    @Nullable
    protected String encode(@NotNull String name, @NotNull PsiElement psiElement) {
        return super.encode(name, psiElement);
    }

    @NotNull
    public String decode(@NotNull String name) {
        return super.decode(StringUtil.unescapeStringCharacters((String)name));
    }
}

