/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.interpreter;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.Stack;
import com.jetbrains.cmake.interpreter.CMakeScope;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeBodyBlock;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeEndFunctionCommand;
import com.jetbrains.cmake.psi.CMakeEndMacroCommand;
import com.jetbrains.cmake.psi.CMakeForeachCommand;
import com.jetbrains.cmake.psi.CMakeFunctionCommand;
import com.jetbrains.cmake.psi.CMakeIfCommand;
import com.jetbrains.cmake.psi.CMakeMacroCommand;
import com.jetbrains.cmake.psi.CMakeVisitor;
import com.jetbrains.cmake.psi.CMakeWhileCommand;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeInterpreter {
    public static void interpret(@NotNull PsiElement element, @NotNull Listener listener) {
        element.accept((PsiElementVisitor)new FileVisitor(listener));
    }

    public static boolean expandArguments(@Nullable List<CMakeArgument> argumentList, @NotNull CMakeScope scope, @NotNull List<String> result) {
        if (argumentList == null) {
            return false;
        }
        for (CMakeArgument arg : argumentList) {
            arg.expandIntoArgumentList(result, scope);
        }
        return true;
    }

    public static void expandListArgument(@NotNull String listArgument, @NotNull List<String> result) {
        int from;
        if (!listArgument.contains(";")) {
            result.add(listArgument);
            return;
        }
        StringBuilder arg = new StringBuilder();
        int length = listArgument.length();
        int bracketDepth = 0;
        for (int cur = from = 0; cur < length; ++cur) {
            char c = listArgument.charAt(cur);
            if (c == '\\') {
                int next = cur + 1;
                if (next >= length || listArgument.charAt(next) != ';') continue;
                arg.append(listArgument, from, cur);
                from = cur = next;
                continue;
            }
            if (c == '[') {
                ++bracketDepth;
                continue;
            }
            if (c == ']') {
                --bracketDepth;
                continue;
            }
            if (c != ';' || bracketDepth != 0) continue;
            arg.append(listArgument, from, cur);
            result.add(arg.toString());
            arg.setLength(0);
            from = cur + 1;
        }
        if (from < length) {
            arg.append(listArgument, from, length);
        }
        if (arg.length() > 0) {
            result.add(arg.toString());
        }
    }

    private static class FileVisitor
    extends CMakeVisitor {
        @NotNull
        private final Stack<CMakeScope> myScopes = new Stack();
        @NotNull
        private final Listener myListener;

        FileVisitor(@NotNull Listener listener) {
            this.myListener = listener;
            this.myScopes.push((Object)new CMakeScope());
        }

        public void visitElement(@NotNull PsiElement element) {
            for (PsiElement psiElement : element.getChildren()) {
                psiElement.accept((PsiElementVisitor)this);
            }
        }

        @Override
        public void visitCMakeFunctionCommand(@NotNull CMakeFunctionCommand o) {
            this.myListener.onEnterFunction();
            this.myScopes.push((Object)new CMakeScope());
        }

        @Override
        public void visitCMakeEndFunctionCommand(@NotNull CMakeEndFunctionCommand o) {
            this.myListener.onExitFunction();
            this.myScopes.pop();
        }

        @Override
        public void visitCMakeMacroCommand(@NotNull CMakeMacroCommand o) {
            this.myListener.onEnterMacro();
            this.myScopes.push((Object)new CMakeScope());
        }

        @Override
        public void visitCMakeEndMacroCommand(@NotNull CMakeEndMacroCommand o) {
            this.myListener.onExitMacro();
            this.myScopes.pop();
        }

        @Override
        public void visitCMakeCommand(@NotNull CMakeCommand command) {
            ArrayList<String> effectiveArgs;
            List<CMakeArgument> argumentList;
            boolean ok;
            String name = command.getName().toLowerCase(Locale.getDefault());
            CMakeScope currentScope = (CMakeScope)this.myScopes.peek();
            this.myListener.beforeCommand(command, currentScope);
            if ("set".equals(name) && (ok = CMakeInterpreter.expandArguments(argumentList = command.getCMakeArgumentList(), currentScope, effectiveArgs = new ArrayList<String>())) && !effectiveArgs.isEmpty()) {
                String varName = effectiveArgs.get(0);
                List<String> values = effectiveArgs.subList(1, effectiveArgs.size());
                int parentScopeIdx = values.indexOf("PARENT_SCOPE");
                if (parentScopeIdx < 0) {
                    int cacheIdx = values.indexOf("CACHE");
                    if (cacheIdx >= 0) {
                        values = values.subList(0, cacheIdx);
                    }
                    currentScope.setVariableValue(varName, values.isEmpty() ? null : StringUtil.join(values, (String)";"));
                }
            }
        }

        @Override
        public void visitCMakeIfCommand(@NotNull CMakeIfCommand command) {
            super.visitCMakeIfCommand(command);
            this.myListener.onEnterIf();
            List<CMakeBodyBlock> branches = command.getCMakeBodyBlockList();
            for (int i = 0; i < branches.size(); ++i) {
                CMakeBodyBlock branch = branches.get(i);
                if (!this.myListener.onEnterBranch(i)) continue;
                branch.accept(this);
                this.myListener.onExitBranch();
            }
            this.myListener.onExitIf();
        }

        @Override
        public void visitCMakeWhileCommand(@NotNull CMakeWhileCommand command) {
            super.visitCMakeWhileCommand(command);
            this.myListener.onEnterWhile();
            CMakeBodyBlock body = command.getCMakeBodyBlock();
            this.iterateLoopBody(body);
            this.myListener.onExitWhile();
        }

        @Override
        public void visitCMakeForeachCommand(@NotNull CMakeForeachCommand command) {
            super.visitCMakeForeachCommand(command);
            this.myListener.onEnterForeach();
            CMakeBodyBlock body = command.getCMakeBodyBlock();
            this.iterateLoopBody(body);
            this.myListener.onExitForeach();
        }

        private void iterateLoopBody(@Nullable CMakeBodyBlock body) {
            if (body == null) {
                return;
            }
            for (int i = 0; i < 2; ++i) {
                if (!this.myListener.onEnterLoop(i)) continue;
                body.accept(this);
                this.myListener.onExitLoop();
            }
        }
    }

    public static interface Listener {
        public void beforeCommand(@NotNull CMakeCommand var1, @NotNull CMakeScope var2);

        public void onEnterIf();

        public void onExitIf();

        public boolean onEnterBranch(int var1);

        public void onExitBranch();

        public void onEnterWhile();

        public void onExitWhile();

        public void onEnterForeach();

        public void onExitForeach();

        public boolean onEnterLoop(int var1);

        public void onExitLoop();

        public void onEnterFunction();

        public void onExitFunction();

        public void onEnterMacro();

        public void onExitMacro();
    }
}

