/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.formatting;

import com.intellij.formatting.ASTBlock;
import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.SpacingBuilder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cmake.formatting.CMakeCodeBlock;
import com.jetbrains.cmake.formatting.CMakeFormattingUtils;
import com.jetbrains.cmake.psi.CMakeElementTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeSpacingProcessor {
    private static final TokenSet ARGUMENT_ELEMENTS = TokenSet.create((IElementType[])new IElementType[]{CMakeElementTypes.LPAR, CMakeElementTypes.C_MAKE_ARGUMENT, CMakeElementTypes.RPAR, CMakeElementTypes.COMMENT});
    private static final TokenSet PARENTHESES = TokenSet.create((IElementType[])new IElementType[]{CMakeElementTypes.LPAR, CMakeElementTypes.RPAR});
    @NotNull
    private final CommonCodeStyleSettings mySettings;
    @NotNull
    private final SpacingBuilder mySpacingBuilder;

    public CMakeSpacingProcessor(@NotNull CommonCodeStyleSettings settings) {
        this.mySettings = settings;
        this.mySpacingBuilder = new SpacingBuilder(settings).betweenInside(CMakeElementTypes.C_MAKE_COMMAND_NAME, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_IF_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_IF_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_ELSE_IF_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_ELSE_IF_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_ELSE_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_ELSE_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_END_IF_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_END_IF_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_WHILE_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_WHILE_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_END_WHILE_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_END_WHILE_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_FOREACH_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_FOREACH_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_END_FOREACH_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_END_FOREACH_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_MACRO_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_MACRO_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_END_MACRO_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_END_MACRO_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_FUNCTION_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_FUNCTION_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES).betweenInside(CMakeElementTypes.C_MAKE_END_FUNCTION_COMMAND_CALL, CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS, CMakeElementTypes.C_MAKE_END_FUNCTION_COMMAND).spaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
    }

    @Nullable
    public Spacing getSpacing(@NotNull CMakeCodeBlock parentBlock, @Nullable Block child1, @Nullable Block child2) {
        IElementType leftNodeType = CMakeSpacingProcessor.getBlockType(child1);
        IElementType rightNodeType = CMakeSpacingProcessor.getBlockType(child2);
        if (child1 == null || child2 == null) {
            return Spacing.getReadOnlySpacing();
        }
        Spacing defaultSpacing = this.mySpacingBuilder.getSpacing((Block)parentBlock, child1, child2);
        if (defaultSpacing != null) {
            return defaultSpacing;
        }
        ASTNode parentNode = parentBlock.getNode();
        IElementType parentType = parentNode.getElementType();
        if (leftNodeType == CMakeElementTypes.LPAR && rightNodeType == CMakeElementTypes.C_MAKE_ARGUMENT && parentType == CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS) {
            return this.getLoopSpacing(parentNode);
        }
        if (leftNodeType == CMakeElementTypes.C_MAKE_ARGUMENT && rightNodeType == CMakeElementTypes.RPAR && parentType == CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS) {
            return this.getLoopSpacing(parentNode);
        }
        if (parentType == CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS && ARGUMENT_ELEMENTS.contains(leftNodeType) && ARGUMENT_ELEMENTS.contains(rightNodeType)) {
            boolean isNotLastRightParenthesisInArguments;
            boolean isNotFirstLeftParenthesisInArguments = leftNodeType != CMakeElementTypes.LPAR || child1 instanceof ASTBlock && parentNode.getFirstChildNode() != ((ASTBlock)child1).getNode();
            boolean bl = isNotLastRightParenthesisInArguments = rightNodeType != CMakeElementTypes.RPAR || child2 instanceof ASTBlock && parentNode.getLastChildNode() != ((ASTBlock)child2).getNode();
            if (isNotFirstLeftParenthesisInArguments || isNotLastRightParenthesisInArguments) {
                if (PARENTHESES.contains(leftNodeType) && PARENTHESES.contains(rightNodeType)) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
                int spacesBetweenChildren = 1;
                if (!(leftNodeType != CMakeElementTypes.COMMENT && rightNodeType != CMakeElementTypes.COMMENT || CMakeFormattingUtils.textBetweenChildrenContainsLineBreak((CMakeCodeBlock)child1, (CMakeCodeBlock)child2))) {
                    spacesBetweenChildren = CMakeSpacingProcessor.getSpacesBetweenChildren(child1, child2);
                }
                return Spacing.createSpacing((int)spacesBetweenChildren, (int)spacesBetweenChildren, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
        if (CMakeElementTypes.CMAKE_BLOCK_START_TOKENS.contains(leftNodeType) && (CMakeElementTypes.CMAKE_BLOCK_START_TOKENS.contains(rightNodeType) || CMakeElementTypes.CMAKE_BLOCK_END_TOKENS.contains(rightNodeType)) || leftNodeType == CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS && CMakeElementTypes.CMAKE_BLOCK_END_TOKENS.contains(rightNodeType) || leftNodeType == CMakeElementTypes.C_MAKE_BODY_BLOCK || rightNodeType == CMakeElementTypes.C_MAKE_BODY_BLOCK) {
            if (leftNodeType == CMakeElementTypes.COMMENT || rightNodeType == CMakeElementTypes.COMMENT) {
                int spacesBetweenChildren = CMakeSpacingProcessor.getSpacesBetweenChildren(child1, child2);
                if (leftNodeType == CMakeElementTypes.COMMENT && rightNodeType == CMakeElementTypes.COMMENT) {
                    return Spacing.createSpacing((int)spacesBetweenChildren, (int)spacesBetweenChildren, (int)1, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
                return Spacing.createSpacing((int)spacesBetweenChildren, (int)spacesBetweenChildren, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (leftNodeType == CMakeElementTypes.LPAR && rightNodeType == CMakeElementTypes.RPAR && parentType == CMakeElementTypes.C_MAKE_COMMAND_ARGUMENTS) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return null;
    }

    private static int getSpacesBetweenChildren(@NotNull Block child1, @NotNull Block child2) {
        return child2.getTextRange().getStartOffset() - child1.getTextRange().getEndOffset();
    }

    @Nullable
    private Spacing getLoopSpacing(@NotNull ASTNode parentNode) {
        IElementType grandParentType = parentNode.getTreeParent().getElementType();
        if (grandParentType == CMakeElementTypes.C_MAKE_WHILE_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_END_WHILE_COMMAND) {
            return this.createSpacing(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
        }
        if (grandParentType == CMakeElementTypes.C_MAKE_FOREACH_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_END_FOREACH_COMMAND) {
            return this.createSpacing(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
        }
        if (grandParentType == CMakeElementTypes.C_MAKE_IF_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_END_IF_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_ELSE_IF_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_ELSE_COMMAND) {
            return this.createSpacing(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
        }
        if (grandParentType == CMakeElementTypes.C_MAKE_COMMAND) {
            return this.createSpacing(this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES);
        }
        if (grandParentType == CMakeElementTypes.C_MAKE_MACRO_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_END_MACRO_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_FUNCTION_COMMAND || grandParentType == CMakeElementTypes.C_MAKE_END_FUNCTION_COMMAND) {
            return this.createSpacing(this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES);
        }
        return null;
    }

    @NotNull
    private Spacing createSpacing(boolean parentheses) {
        if (parentheses) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    @Nullable
    public static IElementType getBlockType(@Nullable Block block) {
        if (block instanceof ASTBlock) {
            ASTNode node = ((ASTBlock)block).getNode();
            return node.getElementType();
        }
        return null;
    }
}

