/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.lang.documentation.DocumentationResult;
import com.intellij.lang.documentation.DocumentationTarget;
import com.intellij.model.Pointer;
import com.intellij.navigation.TargetPresentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNamedElement;
import com.intellij.refactoring.suggested.UtilsKt;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.documentation.CMakeDocumentationPageProvider;
import com.jetbrains.cmake.documentation.CMakeDocumentationUsageCollector;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.CMakeElementDocumentationTargetPointer;
import com.jetbrains.cmake.documentation.DocumentationKind;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeCommandName;
import com.jetbrains.cmake.psi.CMakeCommandNameMixin;
import com.jetbrains.cmake.psi.CMakeElement;
import com.jetbrains.cmake.psi.CMakeLiteral;
import com.jetbrains.cmake.psi.util.CMakePsiUtils;
import java.util.Locale;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u0000 *2\u00020\u0001:\u0001*B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ \u0010\u0015\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\n\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u0010H\u0016J0\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J(\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0012\u0010$\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J0\u0010%\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010&\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010'\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J0\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002J\u0010\u0010)\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R\u0016\u0010\u0006\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget;", "Lcom/intellij/lang/documentation/DocumentationTarget;", "element", "Lcom/jetbrains/cmake/psi/CMakeElement;", "pageProvider", "Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "anchor", "", "(Lcom/jetbrains/cmake/psi/CMakeElement;Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;Ljava/lang/String;)V", "getAnchor", "()Ljava/lang/String;", "getElement", "()Lcom/jetbrains/cmake/psi/CMakeElement;", "getPageProvider", "()Lcom/jetbrains/cmake/documentation/CMakeDocumentationPageProvider;", "pointer", "Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTargetPointer;", "presentation", "Lcom/intellij/navigation/TargetPresentation;", "getPresentation", "()Lcom/intellij/navigation/TargetPresentation;", "checkCMakeLiteral", "Lkotlin/Pair;", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "literal", "Lcom/jetbrains/cmake/psi/CMakeLiteral;", "computeDocumentation", "Lcom/intellij/lang/documentation/DocumentationResult;", "createPointer", "isDirectoryProperty", "argument", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "command", "Lcom/jetbrains/cmake/psi/CMakeCommand;", "isGlobalProperty", "isModuleName", "isPolicyName", "isProperty", "isSourceFileProperty", "isTargetProperty", "isTestProperty", "isVariable", "Companion", "intellij.cmake.psi"})
public final class CMakeElementDocumentationTarget
implements DocumentationTarget {
    private final CMakeElementDocumentationTargetPointer pointer;
    @NotNull
    private final CMakeElement element;
    private static final Pair<String, DocumentationKind> EMPTY_PAIR;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final CMakeDocumentationPageProvider getPageProvider() {
        return this.pointer.getPageProvider();
    }

    private final String getAnchor() {
        return this.pointer.getAnchor();
    }

    @NotNull
    public CMakeElementDocumentationTargetPointer createPointer() {
        return this.pointer;
    }

    @NotNull
    public TargetPresentation getPresentation() {
        Object object;
        CMakeElement cMakeElement = this.element;
        if (!(cMakeElement instanceof PsiNamedElement)) {
            cMakeElement = null;
        }
        if ((object = (PsiNamedElement)cMakeElement) == null || (object = object.getName()) == null) {
            object = this.element.getText();
        }
        return TargetPresentation.Companion.builder((String)object).presentation();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public DocumentationResult computeDocumentation() {
        void name;
        Pair<String, DocumentationKind> pair;
        Object $this$debug$iv = CMakePsiLog.INSTANCE.getLOG();
        Exception e$iv = null;
        boolean $i$f$debug22 = false;
        if ($this$debug$iv.isDebugEnabled()) {
            Logger logger = $this$debug$iv;
            boolean bl = false;
            String string = "Requested documentation for element: " + this.element;
            logger.debug(string, (Throwable)e$iv);
        }
        CMakeDocumentationUsageCollector.REQUESTED.log(this.element.getProject(), this.element.getClass());
        CMakeElement cMakeElement = this.element;
        if (cMakeElement instanceof CMakeCommand) {
            String string;
            Object object = ((CMakeCommand)this.element).getCMakeCommandName();
            if (object != null && (object = object.getName()) != null) {
                Object object2 = object;
                String string2 = ((String)object2).toLowerCase(Locale.ROOT);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            } else {
                string = null;
            }
            pair = new Pair<String, DocumentationKind>(string, (Object)DocumentationKind.COMMAND);
        } else if (cMakeElement instanceof CMakeCommandName) {
            String string = ((CMakeCommandName)this.element).getName();
            String string3 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)string3, (Object)DocumentationKind.COMMAND);
        } else if (cMakeElement instanceof CMakeCommandNameMixin) {
            String string = ((CMakeCommandNameMixin)this.element).getName();
            String string4 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            pair = new Pair((Object)string4, (Object)DocumentationKind.COMMAND);
        } else {
            pair = cMakeElement instanceof CMakeLiteral ? this.checkCMakeLiteral((CMakeLiteral)this.element) : EMPTY_PAIR;
        }
        Pair<String, DocumentationKind> $i$f$debug22 = pair;
        $this$debug$iv = (String)$i$f$debug22.component1();
        DocumentationKind kind = (DocumentationKind)((Object)$i$f$debug22.component2());
        if (name == null || kind == null) {
            return null;
        }
        Project project2 = this.element.getProject();
        return DocumentationResult.Companion.asyncDocumentation(new Supplier(this, (String)name, kind, project2){
            final /* synthetic */ CMakeElementDocumentationTarget this$0;
            final /* synthetic */ String $name;
            final /* synthetic */ DocumentationKind $kind;
            final /* synthetic */ Project $project;

            @Nullable
            public final DocumentationResult.Data get() {
                String string = this.this$0.getPageProvider().getDocumentationPage(this.$name, this.$kind);
                if (string == null) {
                    return null;
                }
                String page = string;
                Logger $this$debug$iv = CMakePsiLog.INSTANCE.getLOG();
                Exception e$iv = null;
                boolean $i$f$debug = false;
                if ($this$debug$iv.isDebugEnabled()) {
                    Logger logger = $this$debug$iv;
                    boolean bl = false;
                    String string2 = "Showing documentation for element: " + this.this$0.getElement() + ", anchor: " + CMakeElementDocumentationTarget.access$getAnchor$p(this.this$0) + ", name: " + this.$name + ", kind: " + this.$kind;
                    logger.debug(string2, (Throwable)e$iv);
                }
                CMakeDocumentationUsageCollector.SHOWN.log(this.$project, (Object)((Object)this.$kind), (Object)(CMakeElementDocumentationTarget.access$getAnchor$p(this.this$0) != null ? 1 : 0));
                return DocumentationResult.Companion.documentation(page).anchor(CMakeElementDocumentationTarget.access$getAnchor$p(this.this$0));
            }
            {
                this.this$0 = cMakeElementDocumentationTarget;
                this.$name = string;
                this.$kind = documentationKind;
                this.$project = project2;
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, DocumentationKind> checkCMakeLiteral(CMakeLiteral literal) {
        void property;
        String policy = this.isPolicyName(literal);
        if (policy != null) {
            return new Pair((Object)policy, (Object)DocumentationKind.POLICY);
        }
        String module = this.isModuleName(literal);
        if (module != null) {
            return new Pair((Object)module, (Object)DocumentationKind.MODULE);
        }
        Pair<String, DocumentationKind> pair = this.isProperty(literal);
        String string = (String)pair.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair.component2());
        if (property != null && kind != null) {
            return new Pair((Object)property, (Object)kind);
        }
        String variable = this.isVariable(literal);
        return new Pair((Object)variable, (Object)DocumentationKind.VARIABLE);
    }

    private final String isPolicyName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.CMAKE_POLICY)) {
            return null;
        }
        CMakeArgument cMakeArgument = argument.getPreviousArgument();
        if (cMakeArgument == null) {
            return null;
        }
        CMakeArgument prevArgument = cMakeArgument;
        String prevArgumentText = prevArgument.getText();
        if (!StringsKt.equals((String)prevArgumentText, (String)"SET", (boolean)true) && !StringsKt.equals((String)prevArgumentText, (String)"GET", (boolean)true)) {
            return null;
        }
        if (prevArgument.getPreviousArgument() != null) {
            return null;
        }
        String string = literal.getText();
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string2;
    }

    private final String isModuleName(CMakeLiteral literal) {
        CMakeArgument argument = literal.getArgument();
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return null;
        }
        CMakeCommand command = cMakeCommand;
        if (!CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME) && !CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return null;
        }
        if (argument.getPreviousArgument() != null) {
            return null;
        }
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.INCLUDE_COMMAND_NAME)) {
            String text = literal.getText();
            if (!StringsKt.contains$default((CharSequence)text, (CharSequence)"/", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)text, (CharSequence)".", (boolean)false, (int)2, null)) {
                return text;
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.FIND_PACKAGE)) {
            return "Find" + literal.getText();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<String, DocumentationKind> isProperty(CMakeLiteral literal) {
        void name;
        Pair<String, DocumentationKind> pair;
        CMakeCommand command;
        CMakeArgument argument = literal.getArgument();
        CMakeCommand cMakeCommand = CMakePsiUtils.getCommand(argument);
        if (cMakeCommand == null) {
            return EMPTY_PAIR;
        }
        CMakeCommand $this$with = command = cMakeCommand;
        boolean bl = false;
        if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) || CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_PROPERTY)) {
            pair = this.isProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_CMAKE_PROPERTY)) {
            pair = this.isGlobalProperty(literal, argument);
        } else if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES) || CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            pair = this.isDirectoryProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.SET_TARGET_PROPERTIES) || CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            pair = this.isTargetProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME) || CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            pair = this.isSourceFileProperty(literal, argument, command);
        } else if (CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.SET_TESTS_PROPERTIES) || CMakePsiUtils.isCommand($this$with, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            pair = this.isTestProperty(literal, argument, command);
        } else {
            return EMPTY_PAIR;
        }
        Pair<String, DocumentationKind> pair2 = pair;
        String string = (String)pair2.component1();
        DocumentationKind kind = (DocumentationKind)((Object)pair2.component2());
        if (name == null || kind == null) {
            return EMPTY_PAIR;
        }
        pair2 = name;
        String string2 = pair2.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return new Pair((Object)string2, (Object)kind);
    }

    private final Pair<String, DocumentationKind> isProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        DocumentationKind documentationKind;
        CMakeArgument kindArgument;
        CMakeArgument cMakeArgument = CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME) ? command.getFirstArgument() : (kindArgument = CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_PROPERTY) ? CMakePsiUtils.secondArgument(command) : null);
        if (kindArgument == null) {
            return EMPTY_PAIR;
        }
        String string = kindArgument.getText();
        String string2 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        switch (string2) {
            case "GLOBAL": {
                documentationKind = DocumentationKind.GLOBAL_PROPERTY;
                break;
            }
            case "DIRECTORY": {
                documentationKind = DocumentationKind.DIRECTORY_PROPERTY;
                break;
            }
            case "TARGET": {
                documentationKind = DocumentationKind.TARGET_PROPERTY;
                break;
            }
            case "SOURCE": {
                documentationKind = DocumentationKind.SOURCE_PROPERTY;
                break;
            }
            case "INSTALL": {
                documentationKind = DocumentationKind.INSTALL_PROPERTY;
                break;
            }
            case "TEST": {
                documentationKind = DocumentationKind.TEST_PROPERTY;
                break;
            }
            case "CACHE": {
                documentationKind = DocumentationKind.CACHE_PROPERTY;
                break;
            }
            default: {
                return EMPTY_PAIR;
            }
        }
        DocumentationKind kind = documentationKind;
        CMakeArgument prevArgument = argument.getPreviousArgument();
        if (prevArgument == null || !StringsKt.equals((String)prevArgument.getText(), (String)"PROPERTY", (boolean)true)) {
            return EMPTY_PAIR;
        }
        return new Pair((Object)literal.getText(), (Object)kind);
    }

    private final Pair<String, DocumentationKind> isGlobalProperty(CMakeLiteral literal, CMakeArgument argument) {
        if (CMakePsiUtils.isNotLastArgument(argument)) {
            return EMPTY_PAIR;
        }
        return new Pair((Object)literal.getText(), (Object)DocumentationKind.GLOBAL_PROPERTY);
    }

    private final Pair<String, DocumentationKind> isDirectoryProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_DIRECTORY_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.DIRECTORY_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_DIRECTORY_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.DIRECTORY_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isTargetProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TARGET_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.TARGET_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TARGET_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.TARGET_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isSourceFileProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.SOURCE_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_SOURCE_FILE_PROPERTY)) {
            if (CMakePsiUtils.isNotLastArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.SOURCE_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final Pair<String, DocumentationKind> isTestProperty(CMakeLiteral literal, CMakeArgument argument, CMakeCommand command) {
        if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.SET_TESTS_PROPERTIES)) {
            if (CMakeDocumentationUtilKt.findPreviousPropertiesArgument(argument) != null) {
                return new Pair((Object)literal.getText(), (Object)DocumentationKind.TEST_PROPERTY);
            }
        } else if (CMakePsiUtils.isCommand(command, CMakeStandardCommands.GET_TEST_PROPERTY)) {
            if (!CMakePsiUtils.isSecondArgument(argument)) {
                return EMPTY_PAIR;
            }
            return new Pair((Object)literal.getText(), (Object)DocumentationKind.TEST_PROPERTY);
        }
        return EMPTY_PAIR;
    }

    private final String isVariable(CMakeLiteral literal) {
        String text = literal.getText();
        if (CMakePsiUtils.isVariableRef(text)) {
            String string = CMakePsiUtils.stripVariableRef(text);
            String string2 = string.toUpperCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
            return string2;
        }
        String string = text;
        String string3 = string.toUpperCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
        return string3;
    }

    @NotNull
    public final CMakeElement getElement() {
        return this.element;
    }

    public CMakeElementDocumentationTarget(@NotNull CMakeElement element, @NotNull CMakeDocumentationPageProvider pageProvider, @Nullable String anchor) {
        this.element = element;
        this.pointer = new CMakeElementDocumentationTargetPointer((Pointer<? extends CMakeElement>)((Pointer)UtilsKt.createSmartPointer((PsiElement)this.element)), pageProvider, anchor);
    }

    public /* synthetic */ CMakeElementDocumentationTarget(CMakeElement cMakeElement, CMakeDocumentationPageProvider cMakeDocumentationPageProvider, String string, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        this(cMakeElement, cMakeDocumentationPageProvider, string);
    }

    static {
        Companion = new Companion(null);
        EMPTY_PAIR = new Pair(null, null);
    }

    public static final /* synthetic */ String access$getAnchor$p(CMakeElementDocumentationTarget $this) {
        return $this.getAnchor();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001e\u0010\u0003\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeElementDocumentationTarget$Companion;", "", "()V", "EMPTY_PAIR", "Lkotlin/Pair;", "", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "intellij.cmake.psi"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

