/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.tree.IElementType;
import com.intellij.ui.ColorUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.JBUI;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.PygmentsTokenAttribute;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeSyntaxHighlighterFactory;
import java.awt.Color;
import java.io.IOException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Path;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000F\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0010\u0010\u001d\u001a\u00020\u00012\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u001a\b\u0010\u001e\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!H\u0000\u001a\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010#\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u001a\u0018\u0010\"\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00012\u0006\u0010%\u001a\u00020&H\u0002\u001a\u000e\u0010'\u001a\u0004\u0018\u00010(*\u00020(H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"!\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006)"}, d2={"CMAKE_CACHE_PROPERTY_ARG", "", "CMAKE_DIRECTORY_PROPERTY_ARG", "CMAKE_FIND_PACKAGE_FILE_PREFIX", "CMAKE_GLOBAL_PROPERTY_ARG", "CMAKE_INSTALL_PROPERTY_ARG", "CMAKE_POLICY_ARGUMENT_GET", "CMAKE_POLICY_ARGUMENT_SET", "CMAKE_PROPERTIES_ARG", "CMAKE_PROPERTY_ARG", "CMAKE_SOURCE_PROPERTY_ARG", "CMAKE_TARGET_PROPERTY_ARG", "CMAKE_TEST_PROPERTY_ARG", "pygmentTokens", "", "Lcom/jetbrains/cmake/documentation/PygmentsTokenAttribute;", "getPygmentTokens", "()Ljava/util/List;", "pygmentTokens$delegate", "Lkotlin/Lazy;", "convertColorKey", "", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "colorKey", "Lcom/intellij/openapi/editor/colors/ColorKey;", "convertTextAttributeKey", "textAttributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "convertToPygments", "linkCss", "readFile", "path", "Ljava/nio/file/Path;", "token", "tokenName", "pygmentsToken", "cmakeToken", "Lcom/intellij/psi/tree/IElementType;", "findPreviousPropertiesArgument", "Lcom/jetbrains/cmake/psi/CMakeArgument;", "intellij.cmake.psi"})
public final class CMakeDocumentationUtilKt {
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_GET = "GET";
    @NotNull
    public static final String CMAKE_POLICY_ARGUMENT_SET = "SET";
    @NotNull
    public static final String CMAKE_GLOBAL_PROPERTY_ARG = "GLOBAL";
    @NotNull
    public static final String CMAKE_DIRECTORY_PROPERTY_ARG = "DIRECTORY";
    @NotNull
    public static final String CMAKE_TARGET_PROPERTY_ARG = "TARGET";
    @NotNull
    public static final String CMAKE_SOURCE_PROPERTY_ARG = "SOURCE";
    @NotNull
    public static final String CMAKE_INSTALL_PROPERTY_ARG = "INSTALL";
    @NotNull
    public static final String CMAKE_TEST_PROPERTY_ARG = "TEST";
    @NotNull
    public static final String CMAKE_CACHE_PROPERTY_ARG = "CACHE";
    @NotNull
    public static final String CMAKE_PROPERTY_ARG = "PROPERTY";
    @NotNull
    public static final String CMAKE_PROPERTIES_ARG = "PROPERTIES";
    @NotNull
    public static final String CMAKE_FIND_PACKAGE_FILE_PREFIX = "Find";
    private static final Lazy pygmentTokens$delegate = LazyKt.lazy((Function0)pygmentTokens.2.INSTANCE);

    @Nullable
    public static final CMakeArgument findPreviousPropertiesArgument(@NotNull CMakeArgument $this$findPreviousPropertiesArgument) {
        for (CMakeArgument propertiesArgument = $this$findPreviousPropertiesArgument.getPreviousArgument(); propertiesArgument != null; propertiesArgument = propertiesArgument.getPreviousArgument()) {
            if (StringsKt.equals((String)propertiesArgument.getText(), (String)CMAKE_PROPERTIES_ARG, (boolean)true)) {
                return propertiesArgument;
            }
            CMakeArgument cMakeArgument = propertiesArgument.getPreviousArgument();
            if (cMakeArgument == null) {
                return null;
            }
            propertiesArgument = cMakeArgument;
        }
        return null;
    }

    @Nullable
    public static final String readFile(@NotNull Path path) {
        try {
            return PathKt.readText((Path)path);
        }
        catch (FileSystemNotFoundException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (SecurityException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
        catch (IOException e) {
            CMakePsiLog.INSTANCE.getLOG().debug((Throwable)e);
            return null;
        }
    }

    @NotNull
    public static final String linkCss() {
        String linkColor = ColorUtil.toHtmlColor((Color)JBUI.CurrentTheme.Link.Foreground.ENABLED);
        return "a { color: " + linkColor + "}";
    }

    @NotNull
    public static final String convertToPygments(@NotNull EditorColorsScheme colorScheme) {
        StringBuilder css = new StringBuilder();
        String defaultBackground = ColorUtil.toHtmlColor((Color)colorScheme.getDefaultBackground());
        css.append(".highlight  { background: " + defaultBackground + "; }\n");
        for (PygmentsTokenAttribute token : CMakeDocumentationUtilKt.getPygmentTokens()) {
            CharSequence charSequence;
            ColorKey colorKey = token.getColorKey();
            TextAttributesKey textAttributesKey = token.getTextAttributeKey();
            if (colorKey != null) {
                charSequence = CMakeDocumentationUtilKt.convertColorKey(colorScheme, colorKey);
            } else {
                if (textAttributesKey == null) continue;
                charSequence = CMakeDocumentationUtilKt.convertTextAttributeKey(colorScheme, textAttributesKey);
            }
            CharSequence cssAttributes = charSequence;
            css.append(".highlight ." + token.getTokenName() + " { " + cssAttributes + " }\n");
        }
        return css.toString();
    }

    private static final CharSequence convertColorKey(EditorColorsScheme colorScheme, ColorKey colorKey) {
        Color color = colorScheme.getColor(colorKey);
        if (color == null) {
            color = colorScheme.getDefaultForeground();
        }
        Color color2 = color;
        return ColorUtil.toHtmlColor((Color)color2);
    }

    private static final CharSequence convertTextAttributeKey(EditorColorsScheme colorScheme, TextAttributesKey textAttributeKey) {
        int fontType;
        Color backgroundColor;
        StringBuilder css = new StringBuilder();
        TextAttributes textAttributes = colorScheme.getAttributes(textAttributeKey);
        if (textAttributes == null) {
            return css;
        }
        TextAttributes textAttributes2 = textAttributes;
        Color foregroundColor = textAttributes2.getForegroundColor();
        if (foregroundColor != null) {
            css.append("color: " + ColorUtil.toHtmlColor((Color)foregroundColor) + "; ");
        }
        if ((backgroundColor = textAttributes2.getBackgroundColor()) != null) {
            css.append("background-color: " + ColorUtil.toHtmlColor((Color)backgroundColor) + "; ");
        }
        if ((fontType = textAttributes2.getFontType()) == 2) {
            css.append("font-style: italic; ");
        }
        if (fontType == 1) {
            css.append("font-weight: bold");
        }
        return css;
    }

    private static final PygmentsTokenAttribute token(String tokenName, TextAttributesKey textAttributeKey) {
        return new PygmentsTokenAttribute(tokenName, null, textAttributeKey);
    }

    private static final PygmentsTokenAttribute token(String tokenName, ColorKey colorKey) {
        return new PygmentsTokenAttribute(tokenName, colorKey, null);
    }

    private static final PygmentsTokenAttribute token(String pygmentsToken, IElementType cmakeToken) {
        TextAttributesKey textAttributesKey = CMakeSyntaxHighlighterFactory.ATTRIBUTES.get(cmakeToken);
        if (textAttributesKey == null) {
            textAttributesKey = HighlighterColors.TEXT;
        }
        TextAttributesKey attributesKey = textAttributesKey;
        return CMakeDocumentationUtilKt.token(pygmentsToken, attributesKey);
    }

    private static final List<PygmentsTokenAttribute> getPygmentTokens() {
        Lazy lazy = pygmentTokens$delegate;
        Object var1_1 = null;
        Object var2_2 = null;
        return (List)lazy.getValue();
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String tokenName, ColorKey colorKey) {
        return CMakeDocumentationUtilKt.token(tokenName, colorKey);
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String tokenName, TextAttributesKey textAttributeKey) {
        return CMakeDocumentationUtilKt.token(tokenName, textAttributeKey);
    }

    public static final /* synthetic */ PygmentsTokenAttribute access$token(String pygmentsToken, IElementType cmakeToken) {
        return CMakeDocumentationUtilKt.token(pygmentsToken, cmakeToken);
    }
}

