/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.documentation;

import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorColorsUtil;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.jetbrains.cmake.CMakePsiLog;
import com.jetbrains.cmake.documentation.CMakeDocumentationUtilKt;
import com.jetbrains.cmake.documentation.DocumentationKind;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\bf\u0018\u0000 \r2\u00020\u0001:\u0001\rJ\b\u0010\u0002\u001a\u00020\u0003H&J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\r\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016J$\u0010\t\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u000b\u0010\n\u001a\u00070\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00052\u000b\u0010\f\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider;", "", "basePath", "Ljava/nio/file/Path;", "kind", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "css", "", "Lcom/intellij/openapi/util/NlsSafe;", "html", "name", "reversePath", "path", "Companion", "intellij.cmake.psi"})
public interface CMakeBundledDocumentationProvider {
    @NotNull
    public static final Companion Companion = com.jetbrains.cmake.documentation.CMakeBundledDocumentationProvider$Companion.$$INSTANCE;
    @NotNull
    public static final String CSS_PLACEHOLDER = "/* CLION CMAKE DOCUMENTATION CSS PLACEHOLDER */";

    @NotNull
    public Path basePath();

    @NotNull
    public Path basePath(@NotNull DocumentationKind var1);

    @Nullable
    public DocumentationKind reversePath(@NotNull String var1);

    @Nullable
    public String html(@NotNull String var1, @NotNull DocumentationKind var2);

    @NotNull
    public String css();

    @JvmStatic
    @Nullable
    public static CMakeBundledDocumentationProvider getProvider() {
        return Companion.getProvider();
    }

    @NotNull
    public static Map<DocumentationKind, String> getDOCUMENTATION_MAPPING() {
        return Companion.getDOCUMENTATION_MAPPING();
    }

    @Metadata(mv={1, 5, 1}, k=3)
    public static final class DefaultImpls {
        @NotNull
        public static Path basePath(@NotNull CMakeBundledDocumentationProvider $this, @NotNull DocumentationKind kind) {
            Path path;
            boolean bl;
            String resourcePath = Companion.getDOCUMENTATION_MAPPING().get((Object)kind);
            boolean bl2 = bl = resourcePath != null;
            if (!bl) {
                boolean bl3 = false;
                String string = "Unknown documentation path";
                throw new IllegalArgumentException(string.toString());
            }
            Path basePath = $this.basePath();
            try {
                path = basePath.resolve(resourcePath);
            }
            catch (Exception e) {
                CMakePsiLog.INSTANCE.getLOG().error("Can't resolve base documentation path, basePath = " + basePath + ", resourcePath = " + resourcePath, (Throwable)e);
                path = basePath;
            }
            return path;
        }

        @Nullable
        public static DocumentationKind reversePath(@NotNull CMakeBundledDocumentationProvider $this, @NotNull String path) {
            Object v0;
            block1: {
                Iterable iterable;
                Iterable iterable2 = iterable = (Iterable)Companion.getDOCUMENTATION_MAPPING().entrySet();
                for (Object t : iterable2) {
                    Map.Entry it = (Map.Entry)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)((String)it.getValue()), (Object)path)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            Map.Entry entry = v0;
            return entry != null ? (DocumentationKind)((Object)entry.getKey()) : null;
        }

        @Nullable
        public static String html(@NotNull CMakeBundledDocumentationProvider $this, @NotNull String name, @NotNull DocumentationKind kind) {
            Path basePath = $this.basePath(kind);
            Object htmlName = StringsKt.endsWith$default((String)name, (String)".html", (boolean)false, (int)2, null) ? name : name + ".html";
            try {
                return CMakeDocumentationUtilKt.readFile(basePath.resolve((String)htmlName));
            }
            catch (Exception e) {
                CMakePsiLog.INSTANCE.getLOG().debug("Can't find documentation page, basePath = " + basePath + ", htmlName = " + (String)htmlName, (Throwable)e);
                return null;
            }
        }

        @NotNull
        public static String css(@NotNull CMakeBundledDocumentationProvider $this) {
            String string;
            Path basePath = $this.basePath();
            try {
                String string2 = CMakeDocumentationUtilKt.readFile(basePath.resolve("_static/basic.css"));
                if (string2 == null) {
                    string2 = "";
                }
                string = string2;
            }
            catch (Exception e) {
                CMakePsiLog.INSTANCE.getLOG().error("Can't find basic CSS page, basePath = " + basePath, (Throwable)e);
                string = "";
            }
            String basicCss = string;
            EditorColorsScheme colorScheme = EditorColorsUtil.getGlobalOrDefaultColorScheme();
            String pygmentsCss = CMakeDocumentationUtilKt.convertToPygments(colorScheme);
            String linksCss = CMakeDocumentationUtilKt.linkCss();
            return basicCss + pygmentsCss + linksCss;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R(\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider$Companion;", "", "()V", "CSS_PLACEHOLDER", "", "DOCUMENTATION_MAPPING", "", "Lcom/jetbrains/cmake/documentation/DocumentationKind;", "getDOCUMENTATION_MAPPING$annotations", "getDOCUMENTATION_MAPPING", "()Ljava/util/Map;", "EP_NAME", "Lcom/intellij/openapi/extensions/ExtensionPointName;", "Lcom/jetbrains/cmake/documentation/CMakeBundledDocumentationProvider;", "getProvider", "intellij.cmake.psi"})
    public static final class Companion {
        private static final ExtensionPointName<CMakeBundledDocumentationProvider> EP_NAME;
        @NotNull
        public static final String CSS_PLACEHOLDER = "/* CLION CMAKE DOCUMENTATION CSS PLACEHOLDER */";
        @NotNull
        private static final Map<DocumentationKind, String> DOCUMENTATION_MAPPING;
        static final /* synthetic */ Companion $$INSTANCE;

        @JvmStatic
        @Nullable
        public final CMakeBundledDocumentationProvider getProvider() {
            return (CMakeBundledDocumentationProvider)CollectionsKt.firstOrNull((List)EP_NAME.getExtensionList());
        }

        @JvmStatic
        public static /* synthetic */ void getDOCUMENTATION_MAPPING$annotations() {
        }

        @NotNull
        public final Map<DocumentationKind, String> getDOCUMENTATION_MAPPING() {
            return DOCUMENTATION_MAPPING;
        }

        private Companion() {
        }

        static {
            Companion companion;
            $$INSTANCE = companion = new Companion();
            EP_NAME = new ExtensionPointName("com.intellij.cmake.bundledDocumentationProvider");
            DOCUMENTATION_MAPPING = MapsKt.mapOf((Pair[])new Pair[]{TuplesKt.to((Object)((Object)DocumentationKind.COMMAND), (Object)"command"), TuplesKt.to((Object)((Object)DocumentationKind.VARIABLE), (Object)"variable"), TuplesKt.to((Object)((Object)DocumentationKind.MODULE), (Object)"module"), TuplesKt.to((Object)((Object)DocumentationKind.POLICY), (Object)"policy"), TuplesKt.to((Object)((Object)DocumentationKind.GLOBAL_PROPERTY), (Object)"prop_gbl"), TuplesKt.to((Object)((Object)DocumentationKind.DIRECTORY_PROPERTY), (Object)"prop_dir"), TuplesKt.to((Object)((Object)DocumentationKind.TARGET_PROPERTY), (Object)"prop_tgt"), TuplesKt.to((Object)((Object)DocumentationKind.SOURCE_PROPERTY), (Object)"prop_sf"), TuplesKt.to((Object)((Object)DocumentationKind.INSTALL_PROPERTY), (Object)"prop_inst"), TuplesKt.to((Object)((Object)DocumentationKind.TEST_PROPERTY), (Object)"prop_test"), TuplesKt.to((Object)((Object)DocumentationKind.CACHE_PROPERTY), (Object)"prop_cache")});
        }
    }
}

