/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cmake.completion.contributors.providers;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cmake.completion.contributors.providers.AbstractCMakeCaseSensitiveCompletionProvider;
import com.jetbrains.cmake.completion.contributors.providers.CMakeQtCommands;
import com.jetbrains.cmake.completion.contributors.providers.CMakeQtDeprecatedCommands;
import com.jetbrains.cmake.completion.contributors.providers.CMakeStandardCommands;
import com.jetbrains.cmake.psi.CMakeCommandName;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class CMakeCommandProvider
extends AbstractCMakeCaseSensitiveCompletionProvider {
    public static final List<String> CMAKE_COMMANDS;
    private static final Set<String> CMAKE_COMMANDS_AS_SET;

    public CMakeCommandProvider() {
        super(CMAKE_COMMANDS);
    }

    public static boolean isStandardCommand(String command) {
        return CMAKE_COMMANDS_AS_SET.contains(StringUtil.toLowerCase((String)command));
    }

    public static boolean isIncludeCommand(@NotNull CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.INCLUDE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddLibraryCommand(@NotNull CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_LIBRARY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddExecutableCommand(@NotNull CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_EXECUTABLE_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isAddCustomTargetCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.ADD_CUSTOM_TARGET_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isFltkWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.FLTK_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapCppCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeQtDeprecatedCommands.QT_WRAP_CPP_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isQtWrapUiCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeQtDeprecatedCommands.QT_WRAP_UI_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetPropertyCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_PROPERTY_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isSetSourceFilesPropertiesCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.SET_SOURCE_FILES_PROPERTIES_COMMAND_NAME, cMakeCommandName);
    }

    public static boolean isTryCompileCommand(CMakeCommandName cMakeCommandName) {
        return CMakeStandardCommands.isCommand(CMakeStandardCommands.TRY_COMPILE_COMMAND_NAME, cMakeCommandName);
    }

    static {
        Stream<String> defaultCommands = Arrays.stream(CMakeStandardCommands.values()).filter(command -> !command.isLexerToken()).map(command -> command.getCommandName());
        Stream<String> qtCommands = Arrays.stream(CMakeQtCommands.values()).map(command -> command.getCommandName());
        CMAKE_COMMANDS = Stream.concat(defaultCommands, qtCommands).collect(Collectors.toList());
        CMAKE_COMMANDS_AS_SET = ContainerUtil.newHashSet(CMAKE_COMMANDS);
    }
}

