/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configuration.EnvironmentVariablesDialog;
import com.intellij.execution.configuration.EnvironmentVariablesTextFieldWithBrowseButton;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.jetbrains.cidr.ui.EnvironmentVariableDialogWithFileSelector;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrEnvironmentVariablesTextFieldWithBrowseButton
extends EnvironmentVariablesTextFieldWithBrowseButton {
    private static final Logger LOG = Logger.getInstance(CidrEnvironmentVariablesTextFieldWithBrowseButton.class);
    @NlsSafe
    private static final String SOURCE = "source ";
    @NlsSafe
    private static final String SOURCE_ALT = ". ";

    public CidrEnvironmentVariablesTextFieldWithBrowseButton() {
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CidrEnvironmentVariablesTextFieldWithBrowseButton.this.setEnvironmentFile(CidrEnvironmentVariablesTextFieldWithBrowseButton.parseEnvFile(CidrEnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
            }
        });
        this.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (!StringUtil.equals((CharSequence)CidrEnvironmentVariablesTextFieldWithBrowseButton.this.stringifyEnvs(CidrEnvironmentVariablesTextFieldWithBrowseButton.this.myData), (CharSequence)CidrEnvironmentVariablesTextFieldWithBrowseButton.this.getText())) {
                    CidrEnvironmentVariablesTextFieldWithBrowseButton.this.myData = CidrEnvironmentVariablesTextFieldWithBrowseButton.this.myData.with(CidrEnvironmentVariablesTextFieldWithBrowseButton.parseEnvFile(CidrEnvironmentVariablesTextFieldWithBrowseButton.this.getText()));
                }
            }
        });
    }

    @NotNull
    protected EnvironmentVariablesDialog createDialog() {
        return new EnvironmentVariableDialogWithFileSelector(this);
    }

    public void setEnvironmentFile(@Nullable String environmentFile) {
        this.setData(this.myData.with(environmentFile));
    }

    @Nullable
    private static String parseEnvFile(@NotNull String text) {
        int start = text.indexOf(SOURCE);
        if (start == -1) {
            start = text.indexOf(SOURCE_ALT);
            if (start == -1) {
                return null;
            }
            start += SOURCE_ALT.length();
        } else {
            start += SOURCE.length();
        }
        int end = text.indexOf(";", start);
        String path = text.substring(start, end == -1 ? text.length() : end);
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            return null;
        }
        return path.trim();
    }

    @NotNull
    protected String stringifyEnvs(@NotNull EnvironmentVariablesData environmentVariablesData) {
        StringBuilder builder = new StringBuilder(super.stringifyEnvs(environmentVariablesData));
        if (environmentVariablesData.getEnvironmentFile() != null) {
            if (!builder.toString().isEmpty()) {
                builder.append(";");
            }
            builder.append(SOURCE);
            builder.append(environmentVariablesData.getEnvironmentFile());
        }
        return builder.toString();
    }
}

