/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.project.workspace;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.impl.stores.IProjectStore;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleTypeManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ex.ProjectRootManagerEx;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.storage.ClassPathStorageUtil;
import com.intellij.openapi.roots.impl.storage.ClasspathStorage;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.impl.NullVirtualFile;
import com.intellij.project.ProjectKt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.Stack;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.CidrWorkspaceBundle;
import com.jetbrains.cidr.PathTree;
import com.jetbrains.cidr.PathTreeBase;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.jetbrains.cidr.project.CidrClasspathStorageProvider;
import com.jetbrains.cidr.project.CidrRootConfiguration;
import com.jetbrains.cidr.project.workspace.CidrKnownModuleDetector;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class OCRootsSynchronizer
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)("#" + OCRootsSynchronizer.class.getPackage().getName()));
    private static boolean onlyWarnOnRootInTests;
    private static final NotificationGroup myNotificationGroup;
    private final Map<CidrWorkspace, RootTree> myActiveRoots = new HashMap<CidrWorkspace, RootTree>();
    private boolean myUpdateContentRootsRecursionProtection;
    private volatile boolean isStarted;
    @Nullable
    private MessageBusConnection myBusConnection;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final Collection<String> myRootUrls;
    @NotNull
    private final Collection<String> myRefusedRootUrls;
    @Nullable
    private Set<LocalFileSystem.WatchRequest> myWatchRequest;
    @NotNull
    private volatile String myStorageId = "CIDR";

    @TestOnly
    static void setOnlyWarnOnRootInTests(boolean onlyWarn) {
        onlyWarnOnRootInTests = onlyWarn;
    }

    @NotNull
    public static OCRootsSynchronizer getInstance(@NotNull Project project2) {
        return (OCRootsSynchronizer)project2.getService(OCRootsSynchronizer.class);
    }

    public OCRootsSynchronizer(@NotNull Project project2) {
        String systemDrive;
        this.myProject = project2;
        ImmutableList.Builder rootUrls = ImmutableList.builderWithExpectedSize((int)2);
        if (SystemInfo.isWindows && (systemDrive = System.getenv("SystemDrive")) != null) {
            rootUrls.add((Object)VfsUtilCore.pathToUrl((String)(systemDrive + "\\")));
        }
        rootUrls.add((Object)VfsUtilCore.pathToUrl((String)"/"));
        this.myRootUrls = rootUrls.build();
        this.myRefusedRootUrls = new ArrayList<String>(this.myRootUrls.size());
    }

    private static boolean shouldMigrateToModernCidrStorage() {
        return Registry.is((String)"cidr.workspace.migrate.to.modern.storage", (boolean)false);
    }

    @Deprecated
    public void installLegacyClasspathStorage(@NotNull String id) {
        this.myStorageId = OCRootsSynchronizer.shouldMigrateToModernCidrStorage() ? "CIDR" : id;
    }

    public void startListening() {
        if (this.isStarted) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " has been already started");
        }
        this.myBusConnection = this.myProject.getMessageBus().connect();
        this.synchronizeOnFileMoves(this.myBusConnection);
        this.isStarted = true;
    }

    public void shutdown() {
        if (this.isStarted) {
            this.isStarted = false;
            if (this.myBusConnection != null) {
                this.myBusConnection.disconnect();
            }
            this.myBusConnection = null;
            this.registerWatchRoots(null);
        }
    }

    public void dispose() {
        this.shutdown();
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace) {
        this.updateRoots(workspace, false);
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace, boolean forceRootChangesEvents) {
        this.updateRoots(workspace, null, forceRootChangesEvents);
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace, @Nullable File contentRoot) {
        this.updateRoots(workspace, contentRoot, false);
    }

    public final void updateRoots(@NotNull CidrWorkspace workspace, @Nullable File contentRoot, boolean forceRootChangesEvents) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            File actualContentRoot = workspace.beforeUpdateContentRoots(contentRoot != null ? contentRoot : workspace.getContentRoot());
            RootsInfo rootsInfo = workspace.collectRootsInfo(actualContentRoot);
            this.batchUpdateRoots(Collections.singletonList(workspace), Collections.singletonList(rootsInfo), forceRootChangesEvents);
        });
        LOG.debug("Updating roots took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    @TestOnly
    final void updateRoots(@NotNull CidrWorkspace workspace, @NotNull RootsInfo rootsInfo) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> this.batchUpdateRoots(Collections.singletonList(workspace), Collections.singletonList(rootsInfo), false));
    }

    final void batchUpdateRoots(@NotNull @NotNull List<@NotNull CidrWorkspace> workspaces) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        if (this.myProject.isDefault()) {
            return;
        }
        long before = System.currentTimeMillis();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            ArrayList<@NotNull RootsInfo> rootsInfos = new ArrayList<RootsInfo>(workspaces.size());
            for (CidrWorkspace workspace : workspaces) {
                File contentRoot = workspace.beforeUpdateContentRoots(workspace.getContentRoot());
                rootsInfos.add(workspace.collectRootsInfo(contentRoot));
            }
            this.batchUpdateRoots(workspaces, rootsInfos, false);
        });
        LOG.debug("Updating roots in batch took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void batchUpdateRoots(@NotNull @NotNull List<@NotNull CidrWorkspace> workspaces, @NotNull @NotNull List<@NotNull RootsInfo> rootsInfos, boolean forceRootChangesEvents) {
        assert (workspaces.size() == rootsInfos.size());
        if (this.myUpdateContentRootsRecursionProtection) {
            return;
        }
        this.myUpdateContentRootsRecursionProtection = true;
        try {
            this.setCurrentCidrStorage(this.getModuleOrCreateNew());
            CidrRootConfiguration rootsConfiguration = null;
            Iterator<@NotNull RootsInfo> rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace workspace : workspaces) {
                RootsInfo rootsInfo = rootsInfoIterator.next();
                if (workspace.shouldEnableRootConfiguration()) {
                    if (rootsConfiguration == null) {
                        rootsConfiguration = CidrRootConfiguration.getInstance(this.myProject);
                    }
                    rootsInfo.explicitSourceFolders.addAll(rootsConfiguration.getSourceRoots());
                    rootsInfo.explicitLibraryRoots.addAll(rootsConfiguration.getLibraryRoots());
                    rootsInfo.explicitExcludeFolders.addAll(rootsConfiguration.getExcludeRoots());
                }
                this.myActiveRoots.put(workspace, OCRootsSynchronizer.prepareRootsTree(rootsInfo));
            }
            this.applyRoots(forceRootChangesEvents, rootsConfiguration != null);
            rootsInfoIterator = rootsInfos.iterator();
            for (CidrWorkspace workspace : workspaces) {
                workspace.afterUpdateContentRoots(rootsInfoIterator.next());
            }
        }
        finally {
            this.myUpdateContentRootsRecursionProtection = false;
        }
    }

    protected void applyRoots(boolean forceRootChangesEvents, boolean enableRootConfiguration) {
        ArrayList<String> watchedRoots = new ArrayList<String>();
        ProjectRootManagerEx.getInstanceEx((Project)this.myProject).mergeRootsChangesDuring(() -> {
            Module module = this.getModuleOrCreateNew();
            if (enableRootConfiguration) {
                CidrRootConfiguration.setEnabledFor(module, true);
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)module).getModifiableModel();
            try {
                this.updateModuleRoots(model, watchedRoots);
                if (model.isChanged()) {
                    model.commit();
                }
                if (forceRootChangesEvents) {
                    ProjectRootManagerEx.getInstanceEx((Project)this.myProject).makeRootsChange(EmptyRunnable.getInstance(), false, true);
                }
                for (Facet f : FacetManager.getInstance((Module)module).getAllFacets()) {
                    f.initFacet();
                }
            }
            finally {
                if (!model.isDisposed()) {
                    model.dispose();
                }
            }
        });
        this.registerWatchRoots(watchedRoots);
    }

    private void updateModuleRoots(@NotNull ModifiableRootModel model, @Nullable Collection<String> watchedRoots) {
        JpsRootsBuilder builder = new JpsRootsBuilder(model);
        this.registerRoots(builder, watchedRoots);
        builder.commitLibraryModel();
    }

    protected void registerRoots(@NotNull RootsBuilder<?> builder, @Nullable Collection<String> watchedRoots) {
        RootTree tree = (RootTree)PathTree.merge(this.myActiveRoots.values(), (boolean)true);
        if (tree != null) {
            tree.accept(new TreeVisitor(builder, watchedRoots));
        }
    }

    private static void migrateToModernCidrStorage(@NotNull Module module) {
        OCRootsSynchronizer.setStorage(module, "CIDR");
    }

    private void setCurrentCidrStorage(@NotNull Module module) {
        String storageType = ClassPathStorageUtil.getStorageType((Module)module);
        if ("default".equals(storageType) || "CIDR".equals(storageType)) {
            OCRootsSynchronizer.setStorage(module, this.myStorageId);
        }
    }

    private static void setStorage(@NotNull Module module, @NotNull String storageId) {
        ClasspathStorage.setStorageType((ModuleRootModel)ModuleRootManager.getInstance((Module)module), (String)storageId);
    }

    @Nullable
    public Module getModuleIfExists() {
        Module foundModule = null;
        Module fallbackModule = null;
        boolean foundFallbackCandidate = false;
        Module[] modules2 = ModuleManager.getInstance((Project)this.myProject).getModules();
        Application application = ApplicationManager.getApplication();
        if (!application.isUnitTestMode() && application.isInternal() && PlatformUtils.isCLion() && modules2.length > 1 && Arrays.stream(modules2).filter(CidrKnownModuleDetector::isKnownModule).count() > 1L) {
            LOG.error(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + foundModule.getName() + "' will be used.");
        }
        for (Module module : modules2) {
            String storageType;
            boolean isModernCidrStorage;
            if (CidrKnownModuleDetector.isKnownModule(module)) continue;
            if (foundFallbackCandidate) {
                fallbackModule = null;
            }
            if (!(isModernCidrStorage = "CIDR".equals(storageType = ClassPathStorageUtil.getStorageType((Module)module))) && !(ClasspathStorage.getProvider((String)storageType) instanceof CidrClasspathStorageProvider)) {
                String moduleTypeName = module.getModuleTypeName();
                if (foundFallbackCandidate || !ModuleTypeManager.getInstance().getDefaultModuleType().getId().equals(moduleTypeName) && moduleTypeName != null) continue;
                foundFallbackCandidate = true;
                fallbackModule = module;
                continue;
            }
            if (foundModule != null) {
                LOG.warn(OCRootsSynchronizer.class.getSimpleName() + " doesn't currently support multi-module projects.\nThe first available module '" + foundModule.getName() + "' will be used.");
                break;
            }
            if (!isModernCidrStorage && OCRootsSynchronizer.shouldMigrateToModernCidrStorage()) {
                OCRootsSynchronizer.migrateToModernCidrStorage(module);
            }
            foundModule = module;
        }
        if (foundModule != null || fallbackModule == null) {
            return foundModule;
        }
        if (OCRootsSynchronizer.shouldMigrateToModernCidrStorage()) {
            OCRootsSynchronizer.migrateToModernCidrStorage(fallbackModule);
        }
        return fallbackModule;
    }

    @NotNull
    public Module getModuleOrCreateNew() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module = this.getModuleIfExists();
        if (module != null) {
            return module;
        }
        return (Module)WriteAction.compute(() -> {
            VirtualFile baseDir;
            IProjectStore store = ProjectKt.getStateStore((Project)this.myProject);
            Path moduleDirPath = store.getDirectoryStorePath();
            if (moduleDirPath == null) {
                moduleDirPath = store.getProjectBasePath();
            }
            String moduleName2 = store.getProjectName();
            File moduleDir = moduleDirPath.toFile();
            File imlFile = new File(moduleDir, FileUtil.createSequentFileName((File)moduleDir, (String)moduleName2, (String)"iml"));
            Module newModule = ModuleManager.getInstance((Project)this.myProject).newModule(imlFile.getPath(), ModuleTypeManager.getInstance().getDefaultModuleType().getId());
            ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)newModule);
            ClasspathStorage.setStorageType((ModuleRootModel)rootManager, (String)"CIDR");
            ModifiableRootModel rootModel = rootManager.getModifiableModel();
            if (rootModel.getContentRoots().length == 0 && (baseDir = LocalFileSystem.getInstance().findFileByNioFile(store.getProjectBasePath())) != null) {
                rootModel.addContentEntry(baseDir);
            }
            rootModel.commit();
            return newModule;
        });
    }

    private void registerWatchRoots(@Nullable Collection<String> toStartWatching) {
        Set toStopWatching = (Set)ObjectUtils.notNull(this.myWatchRequest, Collections.emptySet());
        this.myWatchRequest = LocalFileSystem.getInstance().replaceWatchedRoots((Collection)toStopWatching, toStartWatching, null);
    }

    @NotNull
    private static RootTree prepareRootsTree(@NotNull RootsInfo info) {
        final RootTree tree = new RootTree();
        tree.addAll((Collection<File>)info.contentRoots, RootKind.CONTENT);
        if (info.registerSystemHeaderRootUnderContentRootAsLibraries) {
            tree.addAll((Collection<File>)info.contentRoots, RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT);
        }
        tree.addAll((Collection<File>)info.sourceFiles, RootKind.SOURCE);
        tree.addAll((Collection<File>)info.generatedSourceFiles, RootKind.SOURCE_GENERATED);
        tree.addAll(info.additionalBuildDirs, RootKind.EXCLUDE, RootKind.WATCHED);
        tree.addAll((Collection<File>)info.explicitLibraryRoots, RootKind.EXPLICIT_LIBRARY);
        tree.addAll((Collection<File>)info.explicitSourceFolders, RootKind.EXPLICIT_SOURCE);
        tree.addAll((Collection<File>)info.explicitExcludeFolders, RootKind.EXPLICIT_EXCLUDE);
        tree.addAll((Collection<File>)info.watchRoots, RootKind.WATCHED);
        long before = System.currentTimeMillis();
        final HashSet userHeaderRoots = new HashSet();
        HashSet<HeadersSearchRoot> seenRoots = new HashSet<HeadersSearchRoot>();
        for (final HeadersSearchRoot root : info.headersSearchRoots) {
            if (!seenRoots.add(root)) continue;
            root.processChildren(new HeadersSearchRootProcessor(){

                @Override
                public boolean shouldProcessRootsOnly() {
                    return true;
                }

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    VirtualFile virtualFile = framework.getVirtualFile();
                    if (virtualFile != null) {
                        tree.addItem(virtualFile.getUrl(), (Object)RootKind.LIBRARY_EXCLUDE);
                    }
                    return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                }

                @Override
                public boolean process(@NotNull VirtualFile file2) {
                    if (file2.isDirectory()) {
                        switch (root.getKind()) {
                            case BUILTIN: 
                            case FRAMEWORK: 
                            case SYSTEM: {
                                tree.addItem(file2.getUrl(), (Object)RootKind.LIBRARY);
                                break;
                            }
                            case USER: {
                                userHeaderRoots.add(file2);
                            }
                        }
                    }
                    return true;
                }
            });
        }
        for (VirtualFile each : OCRootsSynchronizer.removeDuplicatesAndSubdirs(userHeaderRoots)) {
            tree.addItem(each.getUrl(), (Object)RootKind.CONTENT);
        }
        LOG.debug("Roots collection took " + StringUtil.formatDuration((long)(System.currentTimeMillis() - before)) + " for " + info.headersSearchRoots.size() + " roots");
        return tree;
    }

    private void synchronizeOnFileMoves(@NotNull MessageBusConnection connection) {
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                Module module = OCRootsSynchronizer.this.getModuleIfExists();
                if (module == null) {
                    return;
                }
                Iterator it = Iterables.filter(events, VFileMoveEvent.class).iterator();
                if (!it.hasNext()) {
                    return;
                }
                ModuleRootManager rootManager = ModuleRootManager.getInstance((Module)module);
                ModuleFileIndex index = rootManager.getFileIndex();
                Map libraryModels = FactoryMap.create(key -> (LibraryEx.ModifiableModelEx)((LibraryOrderEntry)key).getLibrary().getModifiableModel());
                ExcludedRootsTree rootsToExclude = new ExcludedRootsTree(rootManager.getContentEntries());
                do {
                    VFileMoveEvent moveEvent;
                    ExcludedRootsTree rootsToExcludeUnderMovedFile;
                    if ((rootsToExcludeUnderMovedFile = rootsToExclude.getExcludedRootsSubTreeUnder((moveEvent = (VFileMoveEvent)it.next()).getFile())) == null) continue;
                    OrderEntry wasInLibrary = index.getOrderEntryForFile(moveEvent.getOldParent());
                    boolean wasInModuleLibrary = OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)wasInLibrary);
                    rootsToExcludeUnderMovedFile.processRoots((Processor<VirtualFile>)((Processor)eachRoot -> {
                        OrderEntry isInLibrary = index.getOrderEntryForFile(eachRoot.getParent());
                        boolean isInModuleLibrary = OrderEntryUtil.isModuleLibraryOrderEntry((OrderEntry)isInLibrary);
                        if (isInModuleLibrary && !wasInModuleLibrary) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(isInLibrary)).addExcludedRoot(eachRoot.getUrl());
                        } else if (wasInModuleLibrary && !isInModuleLibrary) {
                            ((LibraryEx.ModifiableModelEx)libraryModels.get(wasInLibrary)).removeExcludedRoot(eachRoot.getUrl());
                        }
                        return true;
                    }));
                } while (it.hasNext());
                for (LibraryEx.ModifiableModelEx each : libraryModels.values()) {
                    each.commit();
                }
            }
        });
    }

    @NotNull
    public static Set<File> collectFilesNotUnder(@Nullable Collection<File> parents, @Nullable Collection<File> files) {
        if (files == null) {
            return Collections.emptySet();
        }
        return files.stream().filter(file2 -> !OCRootsSynchronizer.isUnder(parents, file2)).collect(Collectors.toSet());
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable Collection<File> files) {
        return files != null && ContainerUtil.all(files, file2 -> OCRootsSynchronizer.isUnder(parents, file2));
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2) {
        return OCRootsSynchronizer.isUnder(parents, file2, false);
    }

    public static boolean isUnder(@Nullable Collection<File> parents, @Nullable File file2, boolean strict) {
        if (parents == null || file2 == null) {
            return false;
        }
        for (File parent : parents) {
            if (!FileUtil.isAncestor((File)parent, (File)file2, (boolean)strict)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static List<VirtualFile> removeDuplicatesAndSubdirs(Collection<? extends VirtualFile> files) {
        ArrayList<VirtualFile> answer = new ArrayList<VirtualFile>(files);
        answer.sort((o1, o2) -> FileUtil.comparePaths((String)o1.getPath(), (String)o2.getPath()));
        Iterator it = answer.iterator();
        VirtualFile prev = null;
        while (it.hasNext()) {
            VirtualFile next = (VirtualFile)it.next();
            if (prev != null && VfsUtilCore.isAncestor((VirtualFile)prev, (VirtualFile)next, (boolean)false)) {
                it.remove();
                continue;
            }
            prev = next;
        }
        return answer;
    }

    static {
        myNotificationGroup = NotificationGroup.balloonGroup((String)"Project Roots");
    }

    private static final class RootTree
    extends PathTree<RootTree, RootKind> {
        private RootTree() {
        }

        @NotNull
        protected RootTree createNewTree(@Nullable RootTree parent) {
            return new RootTree();
        }

        @NotNull
        protected Set<RootKind> createItemsSet(@Nullable Set<RootKind> existing) {
            return existing != null ? EnumSet.copyOf(existing) : EnumSet.noneOf(RootKind.class);
        }

        public void addAll(@NotNull @NotNull Collection<@NotNull File> files, @NotNull RootKind kind) {
            for (File each : files) {
                this.addItem(VfsUtilCore.fileToUrl((File)each), (Object)kind);
            }
        }

        public void addAll(@NotNull @NotNull Collection<@NotNull File> files, RootKind ... kinds) {
            for (File each : files) {
                this.addItems(VfsUtilCore.fileToUrl((File)each), (Object[])kinds);
            }
        }
    }

    private static enum RootKind {
        CONTENT,
        EXCLUDE,
        SOURCE,
        SOURCE_GENERATED,
        LIBRARY,
        LIBRARY_EXCLUDE,
        EXPLICIT_SOURCE,
        EXPLICIT_LIBRARY,
        EXPLICIT_EXCLUDE,
        ALLOW_LIBRARY_ROOT_IN_CONTENT,
        WATCHED;

    }

    private static class ExcludedRootsTree
    extends PathTreeBase<ExcludedRootsTree> {
        private boolean myIsExcluded;
        private VirtualFile myVirtualFile;

        private ExcludedRootsTree() {
        }

        ExcludedRootsTree(@NotNull @NotNull ContentEntry @NotNull [] contentEntries) {
            for (ContentEntry contentEntry : contentEntries) {
                ProgressManager.checkCanceled();
                ((ExcludedRootsTree)this.getNotNullSubTree((String)contentEntry.getUrl())).myIsExcluded = true;
                for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                    ProgressManager.checkCanceled();
                    ((ExcludedRootsTree)this.getNotNullSubTree((String)sourceFolder.getUrl())).myIsExcluded = true;
                }
                for (SourceFolder sourceFolder : contentEntry.getExcludeFolders()) {
                    ProgressManager.checkCanceled();
                    ((ExcludedRootsTree)this.getNotNullSubTree((String)sourceFolder.getUrl())).myIsExcluded = true;
                }
            }
        }

        @NotNull
        protected ExcludedRootsTree createNewTree(@Nullable ExcludedRootsTree parent) {
            return new ExcludedRootsTree();
        }

        @Nullable
        ExcludedRootsTree getExcludedRootsSubTreeUnder(@NotNull VirtualFile file2) {
            ExcludedRootsTree subTree = (ExcludedRootsTree)this.getSubTree(file2.getUrl(), PathTreeBase.SearchStrategy.NULL_IF_NOT_FOUND);
            if (subTree != null) {
                VirtualFile cachedFile = subTree.myVirtualFile;
                LOG.assertTrue(cachedFile == null || cachedFile.equals(file2), (Object)"Virtual file does not match tree!");
                if (cachedFile == null) {
                    subTree.myVirtualFile = file2;
                }
            }
            return subTree;
        }

        boolean processRoots(@NotNull @NotNull Processor<@NotNull VirtualFile> processor) {
            if (this.myVirtualFile == null) {
                throw new IllegalStateException("Missing virtual file.");
            }
            if (NullVirtualFile.INSTANCE.equals(this.myVirtualFile)) {
                return true;
            }
            if (this.myIsExcluded && !processor.process((Object)this.myVirtualFile)) {
                return false;
            }
            if (ContainerUtil.isEmpty((Map)this.myChildren)) {
                return true;
            }
            for (Map.Entry childEntry : this.myChildren.entrySet()) {
                ProgressManager.checkCanceled();
                ExcludedRootsTree child = (ExcludedRootsTree)((Object)childEntry.getValue());
                if (child.myVirtualFile == null) {
                    child.myVirtualFile = (VirtualFile)ObjectUtils.notNull((Object)this.myVirtualFile.findFileByRelativePath((String)childEntry.getKey()), (Object)NullVirtualFile.INSTANCE);
                }
                if (child.processRoots(processor)) continue;
                return false;
            }
            return true;
        }

        protected boolean isLeaf() {
            return this.myIsExcluded;
        }
    }

    private static final class JpsRootsBuilder
    implements RootsBuilder<JpsRootsBuilderState> {
        @NotNull
        private final ModifiableRootModel myModel;
        @NotNull
        private final LibraryEx.ModifiableModelEx myLibraryModel;

        private JpsRootsBuilder(@NotNull ModifiableRootModel model) {
            this.myModel = model;
            model.clear();
            LibraryTable table = model.getModuleLibraryTable();
            Library library = table.createLibrary("Header Search Paths");
            this.myLibraryModel = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        }

        @Override
        public JpsRootsBuilderState createEmptyState() {
            return new JpsRootsBuilderState();
        }

        @Override
        public void addContentRoot(JpsRootsBuilderState state, String url) {
            assert (state.contentEntry == null);
            state.contentEntry = this.myModel.addContentEntry(url);
        }

        @Override
        public void addSourceFolder(@NotNull JpsRootsBuilderState state, @NotNull String url, boolean isGenerated) {
            if (state.contentEntry == null) {
                this.addContentRoot(state, url);
            }
            if (state.sourceFolder == null || state.isGeneratedSources != isGenerated) {
                JavaSourceRootType rootType = JavaSourceRootType.SOURCE;
                JavaSourceRootProperties properties = rootType.createDefaultProperties();
                properties.setForGeneratedSources(isGenerated);
                state.sourceFolder = state.contentEntry.addSourceFolder(url, (JpsModuleSourceRootType)rootType, (JpsElement)properties);
                state.isGeneratedSources = isGenerated;
            }
            if (state.isLibraryRoot) {
                this.myLibraryModel.addExcludedRoot(url);
                state.isLibraryRoot = false;
            }
        }

        private static void resetSourceFolder(@NotNull JpsRootsBuilderState state) {
            state.sourceFolder = null;
            state.isGeneratedSources = false;
        }

        @Override
        public void addSourceExcludedRoot(@NotNull JpsRootsBuilderState state, @NotNull String url) {
            assert (state.contentEntry != null);
            state.contentEntry.addExcludeFolder(url);
            JpsRootsBuilder.resetSourceFolder(state);
        }

        @Override
        public void addLibraryRoot(@NotNull JpsRootsBuilderState state, @NotNull String url) {
            if (state.isLibraryRoot) {
                return;
            }
            this.myLibraryModel.addRoot(url, OrderRootType.CLASSES);
            this.myLibraryModel.addRoot(url, OrderRootType.SOURCES);
            state.isLibraryRoot = true;
            JpsRootsBuilder.resetSourceFolder(state);
        }

        @Override
        public void addLibraryExcludedRoot(@NotNull JpsRootsBuilderState state, @NotNull String url) {
            assert (state.isLibraryRoot);
            this.myLibraryModel.addExcludedRoot(url);
            state.isLibraryRoot = false;
        }

        public void commitLibraryModel() {
            this.myLibraryModel.commit();
        }

        private static final class JpsRootsBuilderState
        implements RootsBuilderState {
            @Nullable
            private ContentEntry contentEntry;
            @Nullable
            private SourceFolder sourceFolder;
            private boolean isLibraryRoot;
            private boolean isExplicitRoot;
            private boolean allowLibraryRoot;
            private boolean isGeneratedSources;

            private JpsRootsBuilderState() {
            }

            @Override
            public boolean isExplicitRoot() {
                return this.isExplicitRoot;
            }

            @Override
            public void setExplicitRoot(boolean value) {
                this.isExplicitRoot = true;
            }

            @Override
            public boolean allowLibraryRoot() {
                return this.allowLibraryRoot || this.contentEntry == null;
            }

            @Override
            public void setAllowLibraryRootInContent(boolean value) {
                this.allowLibraryRoot = value;
            }

            @Override
            public boolean isInContentRoot() {
                return this.contentEntry != null;
            }

            @Override
            public boolean isLibraryRoot() {
                return this.isLibraryRoot;
            }

            @Override
            public JpsRootsBuilderState copy() {
                JpsRootsBuilderState copy = new JpsRootsBuilderState();
                copy.contentEntry = this.contentEntry;
                copy.sourceFolder = this.sourceFolder;
                copy.isLibraryRoot = this.isLibraryRoot;
                copy.isExplicitRoot = this.isExplicitRoot;
                copy.allowLibraryRoot = this.allowLibraryRoot;
                copy.isGeneratedSources = this.isGeneratedSources;
                return copy;
            }
        }
    }

    protected static interface RootsBuilderState {
        public boolean isExplicitRoot();

        public void setExplicitRoot(boolean var1);

        public boolean allowLibraryRoot();

        public void setAllowLibraryRootInContent(boolean var1);

        public boolean isInContentRoot();

        public boolean isLibraryRoot();

        public RootsBuilderState copy();
    }

    protected static interface RootsBuilder<TState extends RootsBuilderState> {
        public TState createEmptyState();

        public void addContentRoot(TState var1, String var2);

        public void addSourceFolder(@NotNull TState var1, @NotNull String var2, boolean var3);

        public void addSourceExcludedRoot(@NotNull TState var1, @NotNull String var2);

        public void addLibraryRoot(@NotNull TState var1, @NotNull String var2);

        public void addLibraryExcludedRoot(@NotNull TState var1, @NotNull String var2);
    }

    private final class TreeVisitor<TState extends RootsBuilderState>
    implements PathTreeBase.Visitor<RootTree> {
        @NotNull
        private final RootsBuilder<TState> builder;
        @Nullable
        private final Collection<String> watchedRoots;
        @NotNull
        private final Stack<TState> stack = new Stack();
        private TState state;

        private TreeVisitor(@Nullable RootsBuilder<TState> builder, Collection<String> watchedRoots) {
            this.builder = builder;
            this.watchedRoots = watchedRoots;
        }

        public void enter() {
            ProgressManager.checkCanceled();
            this.stack.push(this.state);
            this.state = this.state == null ? this.builder.createEmptyState() : this.state.copy();
        }

        public boolean visit(@Nullable String url, @NotNull RootTree subTree) {
            Set items = subTree.getItems();
            if (items.isEmpty() || this.shouldSkip(url, items)) {
                return true;
            }
            if (items.contains((Object)RootKind.ALLOW_LIBRARY_ROOT_IN_CONTENT)) {
                this.state.setAllowLibraryRootInContent(true);
            }
            if (this.watchedRoots != null && items.contains((Object)RootKind.WATCHED)) {
                this.watchedRoots.add(VfsUtilCore.urlToPath((String)url));
            }
            if (items.contains((Object)RootKind.EXPLICIT_EXCLUDE)) {
                if (this.state.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(this.state, url);
                }
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
                return false;
            }
            boolean isContentRoot = items.contains((Object)RootKind.CONTENT);
            if (isContentRoot && !this.state.isInContentRoot()) {
                this.builder.addContentRoot(this.state, url);
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
            }
            if (items.contains((Object)RootKind.EXPLICIT_SOURCE)) {
                this.builder.addSourceFolder(this.state, url, false);
                this.state.setExplicitRoot(true);
                return true;
            }
            if (items.contains((Object)RootKind.EXPLICIT_LIBRARY)) {
                this.builder.addLibraryRoot(this.state, url);
                this.state.setExplicitRoot(true);
                return true;
            }
            if (this.state.isExplicitRoot()) {
                return true;
            }
            if (items.contains((Object)RootKind.SOURCE_GENERATED)) {
                this.builder.addSourceFolder(this.state, url, true);
                return true;
            }
            if (items.contains((Object)RootKind.SOURCE)) {
                this.builder.addSourceFolder(this.state, url, false);
                return true;
            }
            if (this.state.allowLibraryRoot()) {
                if (items.contains((Object)RootKind.LIBRARY_EXCLUDE) && this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                    return true;
                }
                if (!isContentRoot && items.contains((Object)RootKind.LIBRARY)) {
                    this.builder.addLibraryRoot(this.state, url);
                    return true;
                }
            }
            if (items.contains((Object)RootKind.EXCLUDE)) {
                if (this.state.isInContentRoot()) {
                    this.builder.addSourceExcludedRoot(this.state, url);
                }
                if (this.state.isLibraryRoot()) {
                    this.builder.addLibraryExcludedRoot(this.state, url);
                }
                return true;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Contract(value="null,_->fail")
        private boolean shouldSkip(@Nullable String url, @NotNull Collection<RootKind> kinds) {
            if (!LOG.assertTrue(url != null, (Object)"Synthetic root should not be registered")) {
                return true;
            }
            if (ContainerUtil.find(OCRootsSynchronizer.this.myRootUrls, rootUrl -> FileUtil.startsWith((String)rootUrl, (String)url)) == null) {
                return false;
            }
            @NonNls String logMessage = "Refusing to register file system root " + url + " as " + kinds + " for indexing as this may lead to degraded performance.";
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                LOG.warn(logMessage);
                Collection<String> collection = OCRootsSynchronizer.this.myRefusedRootUrls;
                synchronized (collection) {
                    if (OCRootsSynchronizer.this.myRefusedRootUrls.contains(url)) {
                        return true;
                    }
                    OCRootsSynchronizer.this.myRefusedRootUrls.add(url);
                }
                myNotificationGroup.createNotification(CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory", new Object[0]), CidrWorkspaceBundle.message("roots.synchronizer.ignoring.directory.description", url), NotificationType.WARNING).notify(OCRootsSynchronizer.this.myProject);
            } else if (onlyWarnOnRootInTests) {
                LOG.warn(logMessage);
            } else {
                LOG.error(logMessage);
            }
            return true;
        }

        public void exit() {
            this.state = (RootsBuilderState)this.stack.pop();
        }
    }

    public static final class RootsInfo {
        @NotNull
        public final List<File> watchRoots = new ArrayList<File>();
        @NotNull
        public final List<File> contentRoots = new ArrayList<File>();
        @NotNull
        public final List<File> sourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> generatedSourceFiles = new ArrayList<File>();
        @NotNull
        public final List<File> additionalBuildDirs = new ArrayList<File>();
        @NotNull
        public final List<File> explicitSourceFolders = new ArrayList<File>();
        @NotNull
        public final List<File> explicitLibraryRoots = new ArrayList<File>();
        @NotNull
        public final List<File> explicitExcludeFolders = new ArrayList<File>();
        @NotNull
        public final List<HeadersSearchRoot> headersSearchRoots = new ArrayList<HeadersSearchRoot>();
        public boolean registerSystemHeaderRootUnderContentRootAsLibraries = false;
    }
}

