/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.PsiFileSystemItemProcessor;
import com.intellij.util.SmartList;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.jetbrains.annotations.NotNull;

public class IncludedFilesProcessor {
    public static boolean processFile(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        ProgressManager.checkCanceled();
        if (IncludedFilesProcessor.shouldSkip(file2, processor)) {
            return true;
        }
        return IncludedFilesProcessor.processFileImpl(project2, file2, processor);
    }

    private static boolean processFileImpl(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        if (processor instanceof HeadersSearchRootProcessor) {
            return ((HeadersSearchRootProcessor)processor).process(file2);
        }
        if (processor instanceof PsiFileSystemItemProcessor && !((PsiFileSystemItemProcessor)processor).acceptItem(file2.getName(), file2.isDirectory())) {
            return true;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Object element = null;
        if (file2.isValid()) {
            element = file2.isDirectory() ? psiManager.findDirectory(file2) : psiManager.findFile(file2);
        }
        return element == null || processor.execute(element);
    }

    public static boolean shouldSkip(@NotNull VirtualFile file2, @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        return AppleFramework.isFrameworkRoot(file2) || FileUtilRt.extensionEquals((String)file2.getName(), (String)"swiftmodule") || processor instanceof HeadersSearchRootProcessor && ((HeadersSearchRootProcessor)processor).shouldSkip(file2);
    }

    public static boolean processFiles(final @NotNull Project project2, @NotNull Iterable<VirtualFile> files, boolean recursive, final @NotNull PsiElementProcessor<? super PsiFileSystemItem> processor) {
        for (VirtualFile each : IncludedFilesProcessor.iterateFilesFirst(files)) {
            if (recursive && each.isDirectory()) {
                class CancelException
                extends RuntimeException
                implements ControlFlowException {
                    CancelException() {
                        super(null, null, true, false);
                    }
                }
                try {
                    VfsUtilCore.visitChildrenRecursively((VirtualFile)each, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                        @NotNull
                        public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file2) {
                            ProgressManager.checkCanceled();
                            if (IncludedFilesProcessor.shouldSkip(file2, (PsiElementProcessor<? super PsiFileSystemItem>)processor)) {
                                return SKIP_CHILDREN;
                            }
                            if (!IncludedFilesProcessor.processFileImpl(project2, file2, (PsiElementProcessor<? super PsiFileSystemItem>)processor)) {
                                throw new CancelException();
                            }
                            return CONTINUE;
                        }

                        @NotNull
                        public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file2) {
                            return IncludedFilesProcessor.iterateFilesFirst(Arrays.asList(file2.getChildren()));
                        }
                    });
                    continue;
                }
                catch (CancelException ignore) {
                    return false;
                }
            }
            if (IncludedFilesProcessor.processFile(project2, each, processor)) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static Iterable<VirtualFile> iterateFilesFirst(final @NotNull Iterable<VirtualFile> files) {
        return new Iterable<VirtualFile>(){

            @Override
            public Iterator<VirtualFile> iterator() {
                return new Iterator<VirtualFile>(){
                    Iterator<VirtualFile> iterator = null;
                    List<VirtualFile> dirs = null;
                    boolean processingDirs = false;
                    VirtualFile prefetched = null;

                    @Override
                    public boolean hasNext() {
                        this.prefetchNext();
                        return this.prefetched != null;
                    }

                    @Override
                    public VirtualFile next() {
                        if (this.prefetched == null) {
                            this.prefetchNext();
                        }
                        if (this.prefetched == null) {
                            throw new NoSuchElementException("No more items");
                        }
                        VirtualFile result = this.prefetched;
                        this.prefetched = null;
                        return result;
                    }

                    private void prefetchNext() {
                        if (this.prefetched != null) {
                            return;
                        }
                        if (this.iterator == null) {
                            this.iterator = files.iterator();
                        }
                        while (this.iterator.hasNext()) {
                            VirtualFile next = this.iterator.next();
                            boolean isDir = next.isDirectory();
                            if (isDir == this.processingDirs) {
                                this.prefetched = next;
                                return;
                            }
                            if (this.processingDirs) continue;
                            if (this.dirs == null) {
                                this.dirs = new SmartList();
                            }
                            this.dirs.add(next);
                        }
                        if (this.prefetched == null && !this.processingDirs && this.dirs != null) {
                            this.processingDirs = true;
                            this.iterator = this.dirs.iterator();
                            this.prefetchNext();
                        }
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }
}

