/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.headerRoots;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchPath;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HeadersSearchRootFactory {
    public static final ExtensionPointName<HeadersSearchRootFactory> EP_NAME = ExtensionPointName.create((String)"cidr.lang.headerSearchRootFactory");

    @Nullable
    public HeadersSearchRoot pathToRoot(@NotNull HeadersSearchPath var1, @NotNull Project var2, @NotNull VirtualFilePointer var3);

    @Nullable
    public HeadersSearchPath rootToPath(@NotNull HeadersSearchRoot var1);

    @NotNull
    public static HeadersSearchRoot createSearchRoot(@NotNull HeadersSearchPath path, @NotNull Project project2, @NotNull HeadersSearchPath.FilePointerFactory filePointerFactory) {
        VirtualFilePointer pointer = filePointerFactory.create(path.getUrl());
        for (HeadersSearchRootFactory factory : EP_NAME.getExtensionList()) {
            HeadersSearchRoot rootFromExtension = factory.pathToRoot(path, project2, pointer);
            if (rootFromExtension == null) continue;
            return rootFromExtension;
        }
        return IncludedHeadersRoot.create(project2, pointer, path.isRecursive(), path.preferQuotes(), path.getKind());
    }

    @Nullable
    public static HeadersSearchPath fromSearchRoot(@NotNull HeadersSearchRoot root) {
        for (HeadersSearchRootFactory factory : EP_NAME.getExtensionList()) {
            HeadersSearchPath pathFromExtension = factory.rootToPath(root);
            if (pathFromExtension == null) continue;
            return pathFromExtension;
        }
        if (root instanceof IncludedHeadersRoot) {
            IncludedHeadersRoot r = (IncludedHeadersRoot)root;
            return new HeadersSearchPath(VfsUtilCore.urlToPath((String)r.getUrl()), r.isRecursive(), r.getKind(), r.preferQuotes());
        }
        return null;
    }
}

