/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace.compiler;

import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerSplitArgs {
    private final Map<String, String> myDefines;
    private final List<String> myIncludes;
    private final List<String> mySources;
    private final List<String> myUnrecognizedArgs;
    private final CidrCompilerSwitches myFilteredSwitches;
    private final boolean myHasPrecompiledOrImplicitHeaders;
    private static final String[] PRECOMPILED_OR_IMPLICIT_HEADER_PREFIXES = new String[]{"include", "include-pch", "Yc", "Yd", "YI", "Yu", "Fp", "FI"};

    private CompilerSplitArgs(@NotNull Map<String, String> defines, @NotNull List<String> includes, @NotNull List<String> sources, @NotNull List<String> unrecognizedArgs, @NotNull List<String> filteredArgs, boolean hasPrecompiledOrImplicitHeaders) {
        this.myDefines = Collections.unmodifiableMap(defines);
        this.myIncludes = Collections.unmodifiableList(includes);
        this.mySources = Collections.unmodifiableList(sources);
        this.myUnrecognizedArgs = Collections.unmodifiableList(unrecognizedArgs);
        this.myFilteredSwitches = new CidrCompilerSwitches(filteredArgs);
        this.myHasPrecompiledOrImplicitHeaders = hasPrecompiledOrImplicitHeaders;
    }

    private static boolean isKey(String s, boolean isWindows) {
        if (s.length() < 2) {
            return false;
        }
        if (s.equals("-I-")) {
            return false;
        }
        if (isWindows && s.startsWith("/cygdrive")) {
            return false;
        }
        char c = s.charAt(0);
        return c == '/' && isWindows || c == '-';
    }

    public static CompilerSplitArgs parse(@NotNull CidrCompilerSwitches switches, @NotNull Set<ArgType> filteredArgTypes, boolean interruptIfPrecompiledHeaderFound, boolean isWindows) {
        return CompilerSplitArgs.parse(switches.getList(CidrCompilerSwitches.Format.RAW), filteredArgTypes, interruptIfPrecompiledHeaderFound, isWindows);
    }

    public static CompilerSplitArgs parse(@NotNull List<String> args, boolean isWindows) {
        return CompilerSplitArgs.parse(args, null, false, isWindows);
    }

    private static CompilerSplitArgs parse(@NotNull List<String> args, @Nullable Set<ArgType> filteredArgTypes, boolean interruptIfPrecompiledHeaderFound, boolean isWindows) {
        LinkedHashMap<String, String> defines = new LinkedHashMap<String, String>();
        ArrayList<String> includes = new ArrayList<String>();
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> unrecognizedArgs = new ArrayList<String>();
        boolean hasPrecompiledOrImplicitHeaders = false;
        Object[] filteredArgs = new String[args.size()];
        filteredArgs = args.toArray(filteredArgs);
        HashMap<ArgType, Function<String, Boolean>> actions = new HashMap<ArgType, Function<String, Boolean>>();
        actions.put(ArgType.DEFINE, value -> CompilerSplitArgs.processDefine(value, defines));
        actions.put(ArgType.INCLUDE, value -> includes.add((String)value));
        for (int i = 0; i < args.size(); ++i) {
            String arg = args.get(i).trim();
            if (CompilerSplitArgs.isKey(arg, isWindows)) {
                ArgType argType = ArgType.of(arg);
                if (argType != null) {
                    boolean needLookup;
                    boolean bl = needLookup = arg.length() == argType.keyLength;
                    String value2 = needLookup ? (++i < args.size() ? args.get(i).trim() : null) : arg.substring(argType.keyLength).trim();
                    if (value2 == null || CompilerSplitArgs.isKey(value2, isWindows) || !((Boolean)((Function)actions.get((Object)argType)).apply(value2)).booleanValue() || filteredArgTypes != null && !filteredArgTypes.contains((Object)argType)) continue;
                    filteredArgs[i] = null;
                    if (!needLookup) continue;
                    filteredArgs[i - 1] = null;
                    continue;
                }
                if (!hasPrecompiledOrImplicitHeaders) {
                    hasPrecompiledOrImplicitHeaders = CompilerSplitArgs.isPrecompiledOrImplicitHeaderArg(arg);
                    if (interruptIfPrecompiledHeaderFound && hasPrecompiledOrImplicitHeaders) break;
                }
                unrecognizedArgs.add(arg);
                continue;
            }
            if (CompilerSplitArgs.isCExtension(arg) || CompilerSplitArgs.isCppExtension(arg)) {
                sources.add(arg);
                continue;
            }
            unrecognizedArgs.add(arg);
        }
        return new CompilerSplitArgs(defines, includes, sources, unrecognizedArgs, ContainerUtil.mapNotNull((Object[])filteredArgs, it -> it), hasPrecompiledOrImplicitHeaders);
    }

    private static boolean processDefine(@NotNull String value, @NotNull Map<String, String> defines) {
        int length = value.length();
        if (length > 1 && value.startsWith("\"") && value.endsWith("\"")) {
            value = value.substring(1, value.length() - 1);
        }
        int eqIdxEq = value.indexOf(61);
        int eqIdxHash = value.indexOf(35);
        int eqIdx = eqIdxEq >= 0 && eqIdxHash >= 0 ? Math.min(eqIdxEq, eqIdxHash) : Math.max(eqIdxEq, eqIdxHash);
        if (eqIdx > 0) {
            defines.put(value.substring(0, eqIdx).trim(), value.substring(eqIdx + 1).trim());
        } else {
            defines.put(value.trim(), "");
        }
        return true;
    }

    private static boolean isPrecompiledOrImplicitHeaderArg(@NotNull String arg) {
        arg = arg.startsWith("--") ? arg.substring(2) : arg.substring(1);
        for (String prefix : PRECOMPILED_OR_IMPLICIT_HEADER_PREFIXES) {
            if (!arg.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static boolean isCppExtension(String s) {
        String lowerCase = s.toLowerCase(Locale.ROOT);
        return lowerCase.endsWith(".c++") || lowerCase.endsWith(".cpp") || lowerCase.endsWith(".cc") || lowerCase.endsWith(".cxx");
    }

    public static boolean isCExtension(String s) {
        return s.endsWith(".c") || s.endsWith(".C");
    }

    public Map<String, String> getDefines() {
        return this.myDefines;
    }

    public List<String> getIncludes() {
        return this.myIncludes;
    }

    public List<String> getSources() {
        return this.mySources;
    }

    public List<String> getUnrecognizedArgs() {
        return this.myUnrecognizedArgs;
    }

    public CidrCompilerSwitches getFilteredSwitches() {
        return this.myFilteredSwitches;
    }

    public boolean hasPrecompiledOrImplicitHeaders() {
        return this.myHasPrecompiledOrImplicitHeaders;
    }

    public String toString() {
        return "CompilerSplitArgs{defines=" + this.myDefines + ", includes=" + this.myIncludes + ", sources=" + this.mySources + ", unrecognized args=" + this.myUnrecognizedArgs + "}";
    }

    public static enum ArgType {
        INCLUDE("I"),
        DEFINE("D");

        final String key;
        final int keyLength;

        private ArgType(String key) {
            this.key = key;
            this.keyLength = key.length() + 1;
        }

        @Nullable
        private static ArgType of(@NotNull String arg) {
            for (ArgType argType : ArgType.values()) {
                if (!arg.startsWith(argType.key, 1)) continue;
                return argType;
            }
            return null;
        }
    }
}

