/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrCompilerSwitches;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorBase;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurations;
import com.jetbrains.cidr.lang.workspace.ShowCompilerInfoForFile;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001c\u0010\u0007\u001a\u00020\u00042\n\u0010\b\u001a\u00060\tj\u0002`\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014J\u0012\u0010\r\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J$\u0010\u000e\u001a\u0016\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u000f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0012H\u0002J\u0010\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "appendAdditionalCompilerInfo", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "context", "Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "getContext", "getProjectAndFile", "Lkotlin/Triple;", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/psi/PsiFile;", "isHeaderOrSourceFile", "", "file", "update", "Context", "intellij.cidr.projectModel"})
public class ShowCompilerInfoForFile
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(this.getProjectAndFile(e) != null);
    }

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e) {
        void project2;
        void file2;
        void kind;
        Context context;
        Context context2 = this.getContext(e);
        if (context2 == null) {
            return;
        }
        Context context3 = context = context2;
        Project project3 = context3.component1();
        VirtualFile virtualFile = context3.component2();
        OCLanguageKind oCLanguageKind = context3.component3();
        OCResolveConfiguration configuration2 = context3.component4();
        OCCompilerSettings settings = configuration2.getCompilerSettings((OCLanguageKind)kind, (VirtualFile)file2);
        StringBuilder builder = new StringBuilder();
        builder.append("Compiler info for '" + file2.getName() + "' in configuration '" + configuration2.getDisplayName() + "' for language " + (OCLanguageKind)kind + "\n");
        builder.append("\nCompiler kind: " + settings.getCompilerKind() + " path: " + settings.getCompilerExecutable() + "\n");
        this.appendAdditionalCompilerInfo(builder, context);
        builder.append("\nCompiler switches:\n");
        CidrCompilerSwitches switches = settings.getCompilerSwitches();
        if (switches == null) {
            builder.append("\nnull\n");
        } else {
            Iterable $this$forEach$iv = switches.getList(CidrCompilerSwitches.Format.RAW);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                builder.append("\t").append(it).append("\n");
            }
        }
        builder.append("\nCompiler info:\n");
        builder.append("\nDefines:\n");
        for (String preprocessorDefine : settings.getPreprocessorDefines()) {
            StringBuilder stringBuilder = builder;
            StringBuilder stringBuilder2 = stringBuilder.append(preprocessorDefine);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(value)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        builder.append("\nFeatures:\n").append(CollectionsKt.joinToString$default((Iterable)settings.getCompilerFeatures().entrySet(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.2.INSTANCE, (int)30, null));
        builder.append("\n\nImplicit includes:\n" + CollectionsKt.joinToString$default((Iterable)settings.getImplicitIncludes(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.3.INSTANCE, (int)30, null));
        builder.append("\n\nHeader Search paths:\n" + CollectionsKt.joinToString$default((Iterable)settings.getHeadersSearchRoots().getAllRoots(), (CharSequence)"\n", null, null, (int)0, null, (Function1)actionPerformed.4.INSTANCE, (int)30, null));
        LightVirtualFile infoFile = new LightVirtualFile("Compiler Info for '" + file2.getName() + "' in '" + configuration2.getDisplayName() + "'", (FileType)PlainTextFileType.INSTANCE, (CharSequence)builder);
        FileEditorManager.getInstance((Project)project2).openFile((VirtualFile)infoFile, false);
    }

    protected void appendAdditionalCompilerInfo(@NotNull StringBuilder builder, @NotNull Context context) {
    }

    private final Triple<Project, VirtualFile, PsiFile> getProjectAndFile(AnActionEvent e) {
        Project project2 = AnAction.getEventProject((AnActionEvent)e);
        if (project2 == null) {
            return null;
        }
        Project project3 = project2;
        VirtualFile virtualFile = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile file2 = virtualFile;
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        if (psiFile == null) {
            return null;
        }
        PsiFile psiFile2 = psiFile;
        if (!this.isHeaderOrSourceFile(psiFile2)) {
            return null;
        }
        return new Triple((Object)project3, (Object)file2, (Object)psiFile2);
    }

    /*
     * WARNING - void declaration
     */
    private final Context getContext(AnActionEvent e) {
        void file2;
        void project2;
        Triple<Project, VirtualFile, PsiFile> triple = this.getProjectAndFile(e);
        if (triple == null) {
            return null;
        }
        Triple<Project, VirtualFile, PsiFile> triple2 = triple;
        Project project3 = (Project)triple2.component1();
        VirtualFile virtualFile = (VirtualFile)triple2.component2();
        PsiFile psiFile = (PsiFile)triple2.component3();
        OCResolveConfiguration oCResolveConfiguration = OCResolveConfigurations.getPreselectedConfiguration(psiFile.getVirtualFile(), (Project)project2);
        if (oCResolveConfiguration == null) {
            return null;
        }
        OCResolveConfiguration configuration2 = oCResolveConfiguration;
        OCLanguageKind oCLanguageKind = OCLanguageKindCalculatorBase.tryPsiFile(psiFile);
        if (oCLanguageKind == null) {
            return null;
        }
        OCLanguageKind kind = oCLanguageKind;
        return new Context((Project)project2, (VirtualFile)file2, kind, configuration2);
    }

    private final boolean isHeaderOrSourceFile(PsiFile file2) {
        return OCFileTypeHelpers.isHeaderFile(file2) || OCFileTypeHelpers.isSourceFile(file2);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0084\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J1\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/cidr/lang/workspace/ShowCompilerInfoForFile$Context;", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kind", "Lcom/jetbrains/cidr/lang/OCLanguageKind;", "configuration", "Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/jetbrains/cidr/lang/OCLanguageKind;Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;)V", "getConfiguration", "()Lcom/jetbrains/cidr/lang/workspace/OCResolveConfiguration;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getKind", "()Lcom/jetbrains/cidr/lang/OCLanguageKind;", "getProject", "()Lcom/intellij/openapi/project/Project;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.cidr.projectModel"})
    protected static final class Context {
        @NotNull
        private final Project project;
        @NotNull
        private final VirtualFile file;
        @NotNull
        private final OCLanguageKind kind;
        @NotNull
        private final OCResolveConfiguration configuration;

        @NotNull
        public final Project getProject() {
            return this.project;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind getKind() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration getConfiguration() {
            return this.configuration;
        }

        public Context(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration2) {
            this.project = project2;
            this.file = file2;
            this.kind = kind;
            this.configuration = configuration2;
        }

        @NotNull
        public final Project component1() {
            return this.project;
        }

        @NotNull
        public final VirtualFile component2() {
            return this.file;
        }

        @NotNull
        public final OCLanguageKind component3() {
            return this.kind;
        }

        @NotNull
        public final OCResolveConfiguration component4() {
            return this.configuration;
        }

        @NotNull
        public final Context copy(@NotNull Project project2, @NotNull VirtualFile file2, @NotNull OCLanguageKind kind, @NotNull OCResolveConfiguration configuration2) {
            return new Context(project2, file2, kind, configuration2);
        }

        public static /* synthetic */ Context copy$default(Context context, Project project2, VirtualFile virtualFile, OCLanguageKind oCLanguageKind, OCResolveConfiguration oCResolveConfiguration, int n, Object object) {
            if ((n & 1) != 0) {
                project2 = context.project;
            }
            if ((n & 2) != 0) {
                virtualFile = context.file;
            }
            if ((n & 4) != 0) {
                oCLanguageKind = context.kind;
            }
            if ((n & 8) != 0) {
                oCResolveConfiguration = context.configuration;
            }
            return context.copy(project2, virtualFile, oCLanguageKind, oCResolveConfiguration);
        }

        @NotNull
        public String toString() {
            return "Context(project=" + this.project + ", file=" + this.file + ", kind=" + this.kind + ", configuration=" + this.configuration + ")";
        }

        public int hashCode() {
            Project project2 = this.project;
            VirtualFile virtualFile = this.file;
            OCLanguageKind oCLanguageKind = this.kind;
            OCResolveConfiguration oCResolveConfiguration = this.configuration;
            return (((project2 != null ? project2.hashCode() : 0) * 31 + (virtualFile != null ? virtualFile.hashCode() : 0)) * 31 + (oCLanguageKind != null ? oCLanguageKind.hashCode() : 0)) * 31 + (oCResolveConfiguration != null ? oCResolveConfiguration.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Context)) break block3;
                    Context context = (Context)object;
                    if (!Intrinsics.areEqual((Object)this.project, (Object)context.project) || !Intrinsics.areEqual((Object)this.file, (Object)context.file) || !Intrinsics.areEqual((Object)this.kind, (Object)context.kind) || !Intrinsics.areEqual((Object)this.configuration, (Object)context.configuration)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

