/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetListener;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerListener;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfigurationWithResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceListener;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class OCWorkspaceRunConfigurationListener {
    private static volatile boolean ourDisableUpdatesInTests;
    @Nullable
    private volatile OCResolveConfiguration mySelectedResolveConfiguration;

    public OCWorkspaceRunConfigurationListener(@NotNull Project project2) {
        ProjectUtil.runWhenProjectOpened((Project)project2, () -> {
            OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(project2);
            OCWorkspaceRunConfigurationListener.listenChanges(project2);
        });
    }

    private static void listenChanges(@NotNull Project project2) {
        MessageBusConnection connection = project2.getMessageBus().connect();
        class MyListener
        implements RunManagerListener,
        ExecutionTargetListener,
        OCWorkspaceListener {
            final AtomicInteger bulkUpdate = new AtomicInteger(0);
            final AtomicBoolean updateTarget = new AtomicBoolean();
            final AtomicBoolean isUpdating = new AtomicBoolean();
            final /* synthetic */ Project val$project;

            MyListener(Project project2) {
                this.val$project = project2;
            }

            public void beginUpdate() {
                this.bulkUpdate.incrementAndGet();
            }

            public void endUpdate() {
                if (this.bulkUpdate.decrementAndGet() == 0) {
                    this.doUpdate();
                }
            }

            public void runConfigurationSelected(@Nullable RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationAdded(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationRemoved(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void runConfigurationChanged(@NotNull RunnerAndConfigurationSettings settings) {
                this.doUpdate();
            }

            public void activeTargetChanged(@NotNull ExecutionTarget newTarget) {
                this.doUpdate();
            }

            @Override
            public void workspaceChanged(@NotNull OCWorkspaceListener.OCWorkspaceEvent event) {
                if (event.resolveConfigurationsChanged() || event.clientVersionChanged()) {
                    this.updateTarget.set(true);
                    this.doUpdate();
                }
            }

            void doUpdate() {
                if (!ourDisableUpdatesInTests && this.bulkUpdate.get() == 0 && this.isUpdating.compareAndSet(false, true)) {
                    try {
                        if (this.updateTarget.getAndSet(false)) {
                            ExecutionTargetManager.getInstance((Project)this.val$project).update();
                        }
                        OCWorkspaceRunConfigurationListener.updateSelectedConfiguration(this.val$project);
                    }
                    finally {
                        this.isUpdating.set(false);
                    }
                }
            }
        }
        MyListener listener = new MyListener(project2);
        connection.subscribe(RunManagerListener.TOPIC, (Object)listener);
        connection.subscribe(ExecutionTargetManager.TOPIC, (Object)listener);
        connection.subscribe(OCWorkspaceListener.TOPIC, (Object)listener);
    }

    private static void updateSelectedConfiguration(@NotNull Project project2) {
        OCResolveConfiguration selectedResolveConfiguration = (OCResolveConfiguration)ReadAction.compute(() -> {
            RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project2).getSelectedConfiguration();
            ExecutionTarget target = ExecutionTargetManager.getInstance((Project)project2).getActiveTarget();
            if (settings != null && settings.getConfiguration() instanceof OCRunConfigurationWithResolveConfiguration) {
                return ((OCRunConfigurationWithResolveConfiguration)settings.getConfiguration()).getResolveConfiguration(target);
            }
            return null;
        });
        OCWorkspaceRunConfigurationListener.setSelectedResolveConfiguration(project2, selectedResolveConfiguration);
    }

    @Nullable
    public static OCResolveConfiguration getSelectedResolveConfiguration(@NotNull Project project2) {
        return project2.isDefault() ? null : OCWorkspaceRunConfigurationListener.getInstance((Project)project2).mySelectedResolveConfiguration;
    }

    public static void setSelectedResolveConfiguration(@NotNull Project project2, @Nullable OCResolveConfiguration selectedResolveConfiguration) {
        if (project2.isDefault()) {
            return;
        }
        OCWorkspaceRunConfigurationListener configurationListener = OCWorkspaceRunConfigurationListener.getInstance(project2);
        if (!Objects.equals(configurationListener.mySelectedResolveConfiguration, selectedResolveConfiguration)) {
            OCResolveConfiguration old = configurationListener.mySelectedResolveConfiguration;
            configurationListener.mySelectedResolveConfiguration = selectedResolveConfiguration;
            ApplicationManager.getApplication().runWriteAction(() -> {
                OCWorkspaceModificationTrackersImpl trackers = (OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance(project2).getModificationTrackers();
                trackers.fireSelectedResolveConfigurationChanged();
            });
            OCResolveContextSettings.getInstance(project2).onRunConfigurationChanged(old, selectedResolveConfiguration);
        }
    }

    @NotNull
    private static OCWorkspaceRunConfigurationListener getInstance(@NotNull Project project2) {
        return (OCWorkspaceRunConfigurationListener)project2.getComponent(OCWorkspaceRunConfigurationListener.class);
    }

    @TestOnly
    public static void setDisableUpdatesInTests(boolean value) {
        ourDisableUpdatesInTests = value;
    }
}

