/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.lang.toolchains.CidrFileSeparators;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCVariant;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceInterner;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface OCWorkspace {
    @NonNls
    @NotNull
    public static final String LEGACY_CLIENT_KEY = "Legacy";

    @NotNull
    public static OCWorkspace getInstance(@NotNull Project project2) {
        return (OCWorkspace)project2.getComponent(OCWorkspace.class);
    }

    public int getClientVersion(@NonNls @NotNull String var1);

    @Deprecated(forRemoval=true)
    default public int getClientVersion() {
        return this.getClientVersion(LEGACY_CLIENT_KEY);
    }

    @NotNull
    public List<OCResolveConfiguration> getConfigurations();

    @NotNull
    public List<OCResolveConfiguration> getConfigurations(@NonNls @NotNull String var1);

    @NotNull
    public List<OCResolveConfiguration> getConfigurationsForFile(@NotNull VirtualFile var1);

    @NotNull
    public List<OCResolveConfiguration> getConfigurationsForFile(@NlsSafe @NotNull String var1);

    @Nullable
    public OCResolveConfiguration getConfigurationById(@NonNls @NotNull String var1);

    @NotNull
    default public ModifiableModel getModifiableModel(@NonNls @NotNull String clientKey) {
        return this.getModifiableModel(clientKey, false);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    default public ModifiableModel getModifiableModel() {
        return this.getModifiableModel(false);
    }

    @NotNull
    public ModifiableModel getModifiableModel(@NonNls @NotNull String var1, boolean var2);

    @Deprecated(forRemoval=true)
    @NotNull
    default public ModifiableModel getModifiableModel(boolean clear) {
        return this.getModifiableModel(LEGACY_CLIENT_KEY, clear);
    }

    public OCWorkspaceModificationTrackers getModificationTrackers();

    public static interface ModifiableModel {
        public void setClientVersion(int var1);

        @NotNull
        public OCWorkspaceInterner getInterner();

        @NotNull
        public List<OCResolveConfiguration.ModifiableModel> getConfigurations();

        @Nullable
        public OCResolveConfiguration.ModifiableModel getConfigurationById(@NonNls @NotNull String var1);

        @NotNull
        default public OCResolveConfiguration.ModifiableModel addConfiguration(@NonNls @NotNull String id, @Nls @NotNull String name) {
            return this.addConfiguration(id, name, null);
        }

        @NotNull
        default public OCResolveConfiguration.ModifiableModel addConfiguration(@NonNls @NotNull String id, @Nls @NotNull String name, @Nullable OCVariant variant) {
            return this.addConfiguration(id, name, variant, OCResolveConfiguration.DEFAULT_FILE_SEPARATORS);
        }

        public @NotNull OCResolveConfiguration.ModifiableModel addConfiguration(@NonNls @NotNull String var1, @Nls @NotNull String var2, @Nullable OCVariant var3, @NotNull CidrFileSeparators var4);

        public void removeConfiguration(@NotNull OCResolveConfiguration.ModifiableModel var1);

        public void clear();

        public void preCommit();

        public boolean commit();

        public void dispose();
    }
}

