/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.NullableLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.PlatformUtils;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.settings.OCResolveContextSettings;
import com.jetbrains.cidr.lang.workspace.OCModuleMapConfigurations;
import com.jetbrains.cidr.lang.workspace.OCPCHCache;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveConfigurationSelector;
import com.jetbrains.cidr.lang.workspace.OCSupportedFileChecker;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackers;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceRunConfigurationListener;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.HeadersSearchRootProcessor;
import com.sun.jna.platform.win32.Advapi32Util;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.platform.win32.WinReg;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCResolveConfigurations {
    private static boolean ourBuildHeaderSymbolsForAllConfigurations = Boolean.parseBoolean(System.getProperty("cidr.build.header.symbols.for.all.configurations"));
    private static final NotNullLazyKey<CachedValue<Map<VirtualFile, Reference<OCResolveConfiguration>>>, Project> DIR_PREFERRED_CONFIG_CACHE = NotNullLazyKey.create((String)"DIR_PREFERRED_CONFIG_CACHE", project2 -> CachedValuesManager.getManager((Project)project2).createCachedValue(() -> {
        if (project2.isDefault()) {
            return new CachedValueProvider.Result(null, new Object[]{ModificationTracker.NEVER_CHANGED});
        }
        OCWorkspaceModificationTrackers tracker = OCWorkspace.getInstance(project2).getModificationTrackers();
        return new CachedValueProvider.Result(new ConcurrentHashMap(), new Object[]{tracker.getResolveConfigurationsTracker(), tracker.getSourceFilesTracker(), tracker.getCompilerSettingsTracker()});
    }, false));

    @Nullable
    public static OCResolveConfiguration findPreselectedConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs, @Nullable Ref<Integer> scoreRef) {
        OCResolveContextSettings settings = OCResolveContextSettings.getInstance(project2);
        Pair<OCResolveConfiguration, Integer> fromSettings = settings.findPriorityConfiguration(configs);
        OCResolveConfiguration result = (OCResolveConfiguration)fromSettings.first;
        int score = (Integer)fromSettings.second;
        if (result == null) {
            ++score;
            OCResolveConfiguration selectedByRun = OCWorkspaceRunConfigurationListener.getSelectedResolveConfiguration(project2);
            if (selectedByRun != null) {
                if (configs.contains(selectedByRun)) {
                    result = selectedByRun;
                } else {
                    ++score;
                    result = OCResolveConfigurationSelector.findClosestConfiguration(selectedByRun, configs);
                }
            }
        }
        if (scoreRef != null) {
            scoreRef.set((Object)score);
        }
        return result;
    }

    @NotNull
    public static Pair<OCResolveConfiguration, Boolean> findPreselectedOrSuitableConfiguration(@NotNull Project project2, @NotNull Collection<OCResolveConfiguration> configs) {
        OCResolveConfiguration selectedConfiguration = OCResolveConfigurations.findPreselectedConfiguration(project2, configs, null);
        if (selectedConfiguration != null) {
            return Pair.create((Object)selectedConfiguration, (Object)true);
        }
        return Pair.create((Object)(configs.isEmpty() ? null : Collections.min(configs)), (Object)false);
    }

    @Nullable
    public static OCResolveConfiguration getPreselectedConfiguration(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        return (OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project2, OCResolveConfigurations.getAllBuildConfigurationsForIndexing((VirtualFile)virtualFile, (Project)project2)).first;
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsOfTargetsOfFile(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> configOfPch = OCPCHCache.getBuildConfigurationByPchFile(virtualFile, project2);
        if (!configOfPch.isEmpty()) {
            return configOfPch;
        }
        return OCWorkspace.getInstance(project2).getConfigurationsForFile(virtualFile);
    }

    @NotNull
    public static Collection<OCResolveConfiguration> getAllBuildConfigurationsForIndexing(@NotNull VirtualFile virtualFile, @NotNull Project project2) {
        Collection<OCResolveConfiguration> result = OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile(virtualFile, project2);
        if (!result.isEmpty()) {
            return result;
        }
        Collection<OCResolveConfiguration> configurations = OCResolveConfigurations.getConfigurationsToIndexForHeaderFile(project2, virtualFile);
        if (ourBuildHeaderSymbolsForAllConfigurations && !configurations.isEmpty()) {
            return configurations;
        }
        if (ContainerUtil.isEmpty(configurations)) {
            configurations = OCWorkspace.getInstance(project2).getConfigurations();
        }
        if (!Experiments.getInstance().isFeatureEnabled("cidr.resolve.configuration.discovery")) {
            return ContainerUtil.createMaybeSingletonList((Object)((OCResolveConfiguration)OCResolveConfigurations.findPreselectedOrSuitableConfiguration((Project)project2, configurations).first));
        }
        OCResolveConfiguration preselectedConfig = OCResolveConfigurations.findPreselectedConfiguration(project2, configurations, null);
        if (preselectedConfig != null) {
            return Collections.singleton(preselectedConfig);
        }
        OCResolveConfiguration fromNeighbours = OCResolveConfigurations.findConfigurationFromNeighbours(virtualFile, project2);
        if (fromNeighbours != null) {
            return Collections.singleton(fromNeighbours);
        }
        return configurations.isEmpty() ? Collections.emptyList() : Collections.singletonList(Collections.min(configurations));
    }

    @Nullable
    private static OCResolveConfiguration findConfigurationFromNeighbours(@NotNull VirtualFile file2, @NotNull Project project2) {
        if (file2.isDirectory()) {
            return null;
        }
        VirtualFile parentDir = file2.getParent();
        if (parentDir == null) {
            return null;
        }
        Map dir2Config = (Map)((CachedValue)DIR_PREFERRED_CONFIG_CACHE.getValue((UserDataHolder)project2)).getValue();
        if (dir2Config == null) {
            return null;
        }
        Reference cached = (Reference)dir2Config.get(parentDir);
        if (cached != null) {
            return (OCResolveConfiguration)cached.get();
        }
        HashMap<String, Pair> id2Config = new HashMap<String, Pair>();
        for (VirtualFile child : parentDir.getChildren()) {
            if (child.isDirectory()) continue;
            for (OCResolveConfiguration c : OCResolveConfigurations.getAllBuildConfigurationsOfTargetsOfFile(child, project2)) {
                String id = c.getUniqueId();
                Pair data = (Pair)id2Config.get(id);
                if (data == null) {
                    data = Pair.create((Object)c, (Object)new AtomicInteger());
                    id2Config.put(id, data);
                }
                ((AtomicInteger)data.second).incrementAndGet();
            }
        }
        int maxCount = 0;
        OCResolveConfiguration result = null;
        for (Pair data : id2Config.values()) {
            OCResolveConfiguration c = (OCResolveConfiguration)data.first;
            int count = ((AtomicInteger)data.second).get();
            if (result == null || count > maxCount) {
                maxCount = count;
                result = c;
                continue;
            }
            if (count != maxCount || c.compareTo(result) >= 0) continue;
            result = c;
        }
        dir2Config.put(parentDir, new WeakReference<Object>(result));
        return result;
    }

    @NotNull
    private static Collection<OCResolveConfiguration> getConfigurationsToIndexForHeaderFile(@NotNull Project project2, @NotNull VirtualFile file2) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).get((Object)file2);
    }

    @ApiStatus.Internal
    public static void setBuildHeaderSymbolsForAllConfigurations(boolean buildHeaderSymbolsForAllConfigurations) {
        ourBuildHeaderSymbolsForAllConfigurations = buildHeaderSymbolsForAllConfigurations;
    }

    @NotNull
    public static Collection<VirtualFile> getHeaderFilesToBuildSymbols(@NotNull Project project2) {
        return HeaderFilesToBuildSymbolsProvider.get(project2).keySet();
    }

    public static final class HeaderFilesToBuildSymbolsProvider
    implements CachedValueProvider<MultiMap<VirtualFile, OCResolveConfiguration>> {
        @NotNull
        private static final Key<CachedValue<MultiMap<VirtualFile, OCResolveConfiguration>>> KEY = Key.create((String)"LIBRARY_FILES_KEY");
        @NotNull
        private static final NullableLazyValue<List<String>> ourWindowsKitsPath = NullableLazyValue.lazyNullable(() -> {
            ArrayList<String> windowsKitsPaths = null;
            if (SystemInfo.isWindows) {
                windowsKitsPaths = new ArrayList<String>();
                try {
                    String[] sdks;
                    for (String sdk : sdks = Advapi32Util.registryGetKeys((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)"SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SDKs\\Windows")) {
                        @Nullable String path = Advapi32Util.registryGetStringValue((WinReg.HKEY)WinReg.HKEY_LOCAL_MACHINE, (String)("SOFTWARE\\WOW6432Node\\Microsoft\\Microsoft SDKs\\Windows\\" + sdk), (String)"InstallationFolder");
                        if (path == null) continue;
                        windowsKitsPaths.add(path);
                    }
                }
                catch (Win32Exception win32Exception) {
                    // empty catch block
                }
            }
            return windowsKitsPaths;
        });
        @NotNull
        private final Project myProject;
        @Nullable
        private final List<String> myWindowsKitsPaths;

        private HeaderFilesToBuildSymbolsProvider(@NotNull Project project2, @Nullable List<String> windowsKitsPaths) {
            this.myProject = project2;
            this.myWindowsKitsPaths = windowsKitsPaths;
        }

        private static boolean hasAnyWindowsKits(List<HeadersSearchRoot> roots) {
            for (HeadersSearchRoot root : roots) {
                VirtualFile virtualFile = root.getVirtualFile();
                if (virtualFile == null || !virtualFile.toString().contains("/Windows Kits/")) continue;
                return true;
            }
            return false;
        }

        private List<HeadersSearchRoot> filterOutWindowsRoots(List<HeadersSearchRoot> roots) {
            if (!SystemInfo.isWindows || this.myWindowsKitsPaths == null) {
                return roots;
            }
            if (this.myWindowsKitsPaths.isEmpty()) {
                return HeaderFilesToBuildSymbolsProvider.hasAnyWindowsKits(roots) ? ContainerUtil.emptyList() : roots;
            }
            ArrayList<HeadersSearchRoot> result = new ArrayList<HeadersSearchRoot>();
            for (HeadersSearchRoot curRoot : roots) {
                String path;
                VirtualFile virtualFile = curRoot.getVirtualFile();
                if (virtualFile == null || ContainerUtil.exists(this.myWindowsKitsPaths, arg_0 -> HeaderFilesToBuildSymbolsProvider.lambda$filterOutWindowsRoots$1(path = virtualFile.toNioPath().toString(), arg_0))) continue;
                result.add(curRoot);
            }
            return result;
        }

        @NotNull
        public CachedValueProvider.Result<MultiMap<VirtualFile, OCResolveConfiguration>> compute() {
            boolean skipFrameworks = !PlatformUtils.isAppCode();
            MultiMap headerConfigs = MultiMap.createSet();
            Map scannedRootHeaders = CollectionFactory.createSmallMemoryFootprintMap();
            OCModuleMapConfigurations moduleMaps = OCModuleMapConfigurations.getInstance(this.myProject);
            HashSet alreadySeenRootInConfig = new HashSet();
            for (OCResolveConfiguration config : OCWorkspace.getInstance(this.myProject).getConfigurations()) {
                ProgressManager.checkCanceled();
                alreadySeenRootInConfig.clear();
                config.getAllCompilerSettings().forEach(settings -> {
                    ProgressManager.checkCanceled();
                    List<HeadersSearchRoot> roots = this.filterOutWindowsRoots(settings.getHeadersSearchRoots().getAllRoots());
                    for (HeadersSearchRoot eachRoot : roots) {
                        ProgressManager.checkCanceled();
                        if (!alreadySeenRootInConfig.add(eachRoot)) continue;
                        if (scannedRootHeaders.containsKey((Object)eachRoot)) {
                            for (VirtualFile header2 : (Set)scannedRootHeaders.get((Object)eachRoot)) {
                                ProgressManager.checkCanceled();
                                headerConfigs.putValue((Object)header2, (Object)config);
                            }
                            continue;
                        }
                        if (skipFrameworks && moduleMaps.isFrameworkSearchRoot(eachRoot)) continue;
                        Set headers = CollectionFactory.createSmallMemoryFootprintSet();
                        HeaderFilesToBuildSymbolsProvider.processHeadersInRoot(eachRoot, moduleMaps, header -> {
                            if (OCSupportedFileChecker.isSupported(this.myProject, header) && headers.add(header)) {
                                headerConfigs.putValue(header, (Object)config);
                            }
                        });
                        scannedRootHeaders.put(eachRoot, headers);
                    }
                });
            }
            OCWorkspaceModificationTrackers trackers = OCWorkspace.getInstance(this.myProject).getModificationTrackers();
            return CachedValueProvider.Result.create((Object)(headerConfigs.isEmpty() ? MultiMap.empty() : headerConfigs), (Object[])new Object[]{trackers.getResolveConfigurationsTracker(), trackers.getSourceFilesTracker(), trackers.getCompilerSettingsTracker()});
        }

        private static void processHeadersInRoot(@NotNull HeadersSearchRoot eachRoot, final @NotNull OCModuleMapConfigurations moduleMaps, final @NotNull Consumer<? super VirtualFile> processor) {
            eachRoot.processChildren(new HeadersSearchRootProcessor(){

                @Override
                @NotNull
                public HeadersSearchRootProcessor.FrameworkResult processFramework(@NotNull AppleFramework framework) {
                    ProgressManager.checkCanceled();
                    List<VirtualFile> publicHeadersToInclude = moduleMaps.getPublicHeadersToInclude(framework);
                    if (publicHeadersToInclude.isEmpty()) {
                        return HeadersSearchRootProcessor.FrameworkResult.PROCESS_CHILDREN;
                    }
                    publicHeadersToInclude.forEach(processor);
                    return HeadersSearchRootProcessor.FrameworkResult.SKIP_CHILDREN;
                }

                @Override
                public boolean process(@NotNull VirtualFile file2) {
                    ProgressManager.checkCanceled();
                    if (!file2.isDirectory()) {
                        processor.accept(file2);
                    }
                    return true;
                }
            });
            moduleMaps.providePublicHeadersForRoot(eachRoot, processor);
        }

        @NotNull
        static MultiMap<VirtualFile, OCResolveConfiguration> get(@NotNull Project project2) {
            CachedValuesManager cachedValuesManager = CachedValuesManager.getManager((Project)project2);
            return (MultiMap)cachedValuesManager.getCachedValue((UserDataHolder)project2, KEY, (CachedValueProvider)new HeaderFilesToBuildSymbolsProvider(project2, (List)ourWindowsKitsPath.getValue()), false);
        }

        private static /* synthetic */ boolean lambda$filterOutWindowsRoots$1(String path, String ignoredPath) {
            return path.startsWith(ignoredPath);
        }
    }
}

