/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.workspace;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculatorHelper;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCLanguageKindCalculatorBase {
    @Nullable
    public static OCLanguageKind tryPsiFile(@NotNull PsiFile file2) {
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByPsiFile(file2);
            if (result == null) continue;
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(file2.getVirtualFile().getName());
    }

    @Nullable
    public static OCLanguageKind calculateMinimalKindByExtension(@Nullable Project project2, @NotNull String name) {
        OCLanguageKind result = OCLanguageKindCalculatorBase.tryFileExtension(project2, name);
        if (result != null) {
            return result;
        }
        return OCFileTypeHelpers.getLanguageKind(name);
    }

    @Nullable
    public static OCLanguageKind tryFileExtension(@Nullable Project project2, @NotNull String name) {
        if (project2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getLanguageByExtension(project2, name);
            if (result == null) continue;
            return result;
        }
        return !OCFileTypeHelpers.isHeaderFile(name) ? OCFileTypeHelpers.getLanguageKindStrict(name) : null;
    }

    @NotNull
    static List<OCLanguageKindCalculatorHelper> getHelpers() {
        return OCLanguageKindCalculatorHelper.EP_NAME.getExtensionList();
    }

    @Nullable
    static OCLanguageKind trySpecifiedFileType(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (project2 == null || file2 == null) {
            return null;
        }
        for (OCLanguageKindCalculatorHelper each : OCLanguageKindCalculatorBase.getHelpers()) {
            OCLanguageKind result = each.getSpecifiedLanguage(project2, file2);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Nullable
    public static OCLanguageKind tryFileTypeAndExtension(@Nullable Project project2, @Nullable VirtualFile file2) {
        if (file2 == null) {
            return null;
        }
        OCLanguageKind result = OCLanguageKindCalculatorBase.trySpecifiedFileType(project2, file2);
        if (result != null) {
            return result;
        }
        result = OCLanguageKindCalculatorBase.tryFileExtension(project2, file2.getName());
        if (result != null) {
            return result;
        }
        return null;
    }
}

