/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.util;

import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Pattern;
import org.apache.velocity.runtime.parser.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCHeaderGuardUtil {
    public static final String DEFAULT_HEADER_GUARD_STYLE_PATTERN = "${PROJECT_NAME}_${FILE_NAME}_${EXT}";
    private static final Logger LOG = Logger.getInstance(OCHeaderGuardUtil.class);

    public static boolean headerGuardMatchesPattern(@NotNull String headerGuardToMatch, @NotNull String headerGuardStylePattern, @NotNull String filePath, @NotNull Project project2) {
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project2);
        String uuid = StringUtil.toUpperCase((String)builtinProperties.getProperty("UUID"));
        String builtHeaderGuardName = OCHeaderGuardUtil.doBuildHeaderGuardName(headerGuardStylePattern, builtinProperties, project2);
        Pattern headerGuardPattern = OCHeaderGuardUtil.buildHeaderGuardRegexPattern(builtHeaderGuardName, Map.of(uuid, "[A-F0-9]{32}"));
        return headerGuardPattern.matcher(headerGuardToMatch).matches();
    }

    @NotNull
    public static String buildDefaultHeaderGuardName(@NotNull String filePath, @NotNull String projectName) {
        String rawHeaderGuardName = StringUtil.join((Collection)ContainerUtil.newArrayList((Object[])new String[]{projectName, OCHeaderGuardUtil.getFileName(filePath), OCHeaderGuardUtil.getExtension(filePath)}), (String)"_");
        String headerGuard = StringUtil.toUpperCase((String)rawHeaderGuardName);
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuard)) {
            return "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
        }
        return Character.isJavaIdentifierStart(headerGuard.charAt(0)) ? headerGuard : "INC_" + headerGuard;
    }

    @NotNull
    public static String buildHeaderGuardName(@NotNull String headerGuardStylePattern, @NotNull String filePath, @NotNull Project project2) {
        Properties builtinProperties = OCHeaderGuardUtil.getBuiltinProperties(filePath, project2);
        return OCHeaderGuardUtil.doBuildHeaderGuardName(headerGuardStylePattern, builtinProperties, project2);
    }

    @NotNull
    private static String doBuildHeaderGuardName(@NotNull String headerGuardStylePattern, @NotNull Properties builtinProperties, @NotNull Project project2) {
        OCHeaderGuardUtil.convertPropertiesToMacroParts(builtinProperties);
        OCHeaderGuardUtil.setDefaultValuesForDummyProperties(headerGuardStylePattern, builtinProperties, project2);
        String rawHeaderGuardName = FileTemplateUtil.mergeTemplate((Properties)builtinProperties, (String)headerGuardStylePattern, (boolean)true, null);
        String headerGuardName = rawHeaderGuardName.trim();
        if (!OCHeaderGuardUtil.headerGuardIsCorrect(headerGuardName)) {
            return "INC_" + StringUtil.toUpperCase((String)OCHeaderGuardUtil.getRandomUUID());
        }
        return Character.isJavaIdentifierStart(headerGuardName.charAt(0)) ? headerGuardName : "INC_" + headerGuardName;
    }

    @NotNull
    private static Properties getBuiltinProperties(@NotNull String filePath, @NotNull Project project2) {
        Properties properties = new Properties(FileTemplateManager.getInstance((Project)project2).getDefaultProperties());
        properties.setProperty("FILE_NAME", OCHeaderGuardUtil.getFileName(filePath));
        properties.setProperty("EXT", OCHeaderGuardUtil.getExtension(filePath));
        properties.setProperty("PROJECT_REL_PATH", OCHeaderGuardUtil.getProjectRelativePath(filePath, project2.getBasePath()));
        properties.setProperty("UUID", OCHeaderGuardUtil.getRandomUUID());
        return properties;
    }

    @NotNull
    private static String getRandomUUID() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    private static void convertPropertiesToMacroParts(@NotNull Properties properties) {
        Set<String> propertyNames = properties.stringPropertyNames();
        for (String propertyName : propertyNames) {
            properties.setProperty(propertyName, OCHeaderGuardUtil.toMacroPart(properties.getProperty(propertyName)));
        }
    }

    private static void setDefaultValuesForDummyProperties(@NotNull String templatePattern, @NotNull Properties properties, @NotNull Project project2) {
        try {
            String[] unsetAttributes;
            for (String unsetAttribute : unsetAttributes = FileTemplateUtil.calculateAttributes((String)templatePattern, (Properties)properties, (boolean)true, (Project)project2)) {
                properties.setProperty(unsetAttribute, "");
            }
        }
        catch (ParseException e) {
            LOG.warn("Failed to parse header guard template pattern: " + e);
        }
    }

    private static boolean headerGuardIsCorrect(@NotNull String headerGuardName) {
        String trimmedHeaderGuard = StringUtil.trimLeading((String)StringUtil.trimTrailing((String)headerGuardName, (char)'_'), (char)'_');
        return !trimmedHeaderGuard.isEmpty() && trimmedHeaderGuard.chars().allMatch(c -> c == 95 || c == 36 || Character.isLetterOrDigit(c));
    }

    @NotNull
    private static String toMacroPart(@NotNull String str) {
        return StringUtil.toUpperCase((String)StringUtil.join((Collection)StringUtil.getWordsIn((String)str), (String)"_"));
    }

    @NotNull
    public static String getProjectRelativePath(@Nullable String filePath, @Nullable String projectPath) {
        if (StringUtil.isEmpty((String)filePath) || StringUtil.isEmpty((String)projectPath)) {
            return "";
        }
        String relativePath = FileUtil.getRelativePath((String)PathUtil.toSystemDependentName((String)projectPath), (String)PathUtil.toSystemDependentName((String)filePath), (char)File.separatorChar);
        return StringUtil.isNotEmpty((String)relativePath) ? PathUtil.getParentPath((String)relativePath) : "";
    }

    @NotNull
    private static String getFileName(@NotNull String filePath) {
        return FileUtilRt.getNameWithoutExtension((String)PathUtil.getFileName((String)filePath));
    }

    @NotNull
    private static String getExtension(@NotNull String filePath) {
        return StringUtil.notNullize((String)PathUtil.getFileExtension((String)filePath));
    }

    @NotNull
    private static Pattern buildHeaderGuardRegexPattern(@NotNull String headerGuard, @NotNull Map<String, String> replacements) {
        String escapedHeaderGuard = StringUtil.replace((String)headerGuard, (String)"$", (String)"\\$");
        for (Map.Entry<String, String> replacement : replacements.entrySet()) {
            escapedHeaderGuard = StringUtil.replace((String)escapedHeaderGuard, (String)replacement.getKey(), (String)replacement.getValue());
        }
        return Pattern.compile(escapedHeaderGuard, 32);
    }
}

