/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.ui;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.cidr.lang.ui.OCFieldAdapter;
import com.jetbrains.cidr.lang.ui.OCTextFieldCompletionProvider;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCTextFieldWithSymbolAutoCompletion<SUPPLEMENTED>
extends TextFieldWithAutoCompletion<SUPPLEMENTED> {
    private final ProgressIndicator myMainCollectionProgress;

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project2, @NotNull TextFieldWithAutoCompletionListProvider<SUPPLEMENTED> provider) {
        this(project2, provider, null);
    }

    public OCTextFieldWithSymbolAutoCompletion(@NotNull Project project2, @NotNull TextFieldWithAutoCompletionListProvider<SUPPLEMENTED> provider, @Nullable ProgressIndicator mainCollectionProgress) {
        super(project2, provider, false, null);
        this.myMainCollectionProgress = mainCollectionProgress;
    }

    public static <SUPPLEMENTED> OCTextFieldWithSymbolAutoCompletion<SUPPLEMENTED> create(@NotNull Project project2, @NotNull OCFieldAdapter<SUPPLEMENTED> adapter, @Nullable Condition<SUPPLEMENTED> condition) {
        return OCTextFieldWithSymbolAutoCompletion.create(project2, adapter, condition, null);
    }

    public static <SUPPLEMENTED> OCTextFieldWithSymbolAutoCompletion<SUPPLEMENTED> create(final @NotNull Project project2, final @NotNull OCFieldAdapter<SUPPLEMENTED> adapter, final @Nullable Condition<SUPPLEMENTED> condition, final @Nullable ProcessListener processListener) {
        final CountDownLatch collectionFinished = new CountDownLatch(1);
        OCTextFieldCompletionProvider provider = new OCTextFieldCompletionProvider<SUPPLEMENTED>(adapter){
            private static final int THRESHOLD_LENGTH = 2;
            private int startedEventsCount;

            @NotNull
            private Collection<SUPPLEMENTED> collectItemsForPrefix(@Nullable String prefix, CompletionParameters parameters, Computable<Collection<SUPPLEMENTED>> computable) {
                ProgressIndicator prefixIndicator;
                Ref prefixResult = Ref.create();
                if (prefix != null && prefix.length() > 2) {
                    prefixIndicator = OCTextFieldWithSymbolAutoCompletion.createIndicator();
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        Collection result = (Collection)ProgressManager.getInstance().runProcess(computable, prefixIndicator);
                        prefixResult.set((Object)result);
                    });
                } else {
                    prefixIndicator = null;
                }
                while (true) {
                    ProgressManager.checkCanceled();
                    if (!prefixResult.isNull()) {
                        return (Collection)prefixResult.get();
                    }
                    try {
                        if (!collectionFinished.await(100L, TimeUnit.MILLISECONDS)) continue;
                        if (prefixIndicator != null) {
                            prefixIndicator.cancel();
                        }
                        return super.getItems(prefix, false, parameters);
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }

            @Nullable
            public String getPrefix(@NotNull String text, int offset) {
                return this.myAdapter.getPrefix(text, offset);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @NotNull
            public Collection<SUPPLEMENTED> getItems(String prefix, boolean cached, CompletionParameters parameters) {
                Collection cachedItems = super.getItems(prefix, cached, parameters);
                if (!cachedItems.isEmpty() || cached) {
                    return cachedItems;
                }
                if (processListener != null) {
                    UIUtil.invokeAndWaitIfNeeded(() -> {
                        if (this.startedEventsCount++ == 0) {
                            processListener.onStarted();
                        }
                    });
                }
                try {
                    Collection collection = this.collectItemsForPrefix(prefix, parameters, () -> {
                        PrefixMatcher matcher = this.createPrefixMatcher(prefix);
                        return this.collectValuesFromProject(project2, item -> matcher.prefixMatches(adapter.getName(item)) && (condition == null || condition.value(item)));
                    });
                    return collection;
                }
                finally {
                    if (processListener != null) {
                        UIUtil.invokeLaterIfNeeded(() -> {
                            if (this.startedEventsCount-- > 0) {
                                processListener.onFinished();
                            }
                        });
                    }
                }
            }
        };
        ProgressIndicator progress = OCTextFieldWithSymbolAutoCompletion.createIndicator();
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().executeProcessUnderProgress(() -> {
            Collection<Object> items = ContainerUtil.emptyList();
            try {
                items = provider.collectValuesFromProject(project2, condition);
            }
            finally {
                Collection<Object> finalItems = items;
                UIUtil.invokeAndWaitIfNeeded(() -> provider.setItems(finalItems));
                collectionFinished.countDown();
            }
        }, progress));
        return new OCTextFieldWithSymbolAutoCompletion<SUPPLEMENTED>(project2, provider, progress);
    }

    private static ProgressIndicator createIndicator() {
        ProgressIndicator mainIndicator = ProgressManager.getInstance().getProgressIndicator();
        return mainIndicator != null ? new SensitiveProgressWrapper(mainIndicator) : new ProgressIndicatorBase();
    }

    public void cancelRunningTasks() {
        if (this.myMainCollectionProgress != null) {
            this.myMainCollectionProgress.cancel();
        }
    }

    public static interface ProcessListener {
        public void onStarted();

        public void onFinished();
    }
}

