/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspaceModificationTrackersImpl;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="OCResolveContextSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
public class OCResolveContextSettings
implements PersistentStateComponent<State> {
    @NotNull
    private final Project myProject;
    @Nullable
    private volatile String mySelectedConfiguration;

    public OCResolveContextSettings(@NotNull Project project2) {
        this.myProject = project2;
    }

    @NotNull
    public static OCResolveContextSettings getInstance(@NotNull Project project2) {
        return (OCResolveContextSettings)project2.getComponent(OCResolveContextSettings.class);
    }

    public synchronized void setSelectedConfiguration(@NotNull OCResolveConfiguration config) {
        this.mySelectedConfiguration = config.getUniqueId();
        this.notifyPrioritiesChange();
    }

    public synchronized void resetConfigurationPriorities() {
        this.mySelectedConfiguration = null;
        this.notifyPrioritiesChange();
    }

    public synchronized Pair<OCResolveConfiguration, Integer> findPriorityConfiguration(@NotNull Collection<OCResolveConfiguration> configs) {
        int priority = 0;
        OCResolveConfiguration result = null;
        for (OCResolveConfiguration c : configs) {
            if (!c.getUniqueId().equals(this.mySelectedConfiguration)) continue;
            result = c;
            break;
        }
        return Pair.create(result, (Object)priority);
    }

    @Nullable
    public synchronized State getState() {
        State state = new State();
        state.configuration = this.mySelectedConfiguration;
        return state;
    }

    public synchronized void loadState(@NotNull State state) {
        this.mySelectedConfiguration = state.configuration;
        this.notifyPrioritiesChange();
    }

    public synchronized void onRunConfigurationChanged(@Nullable OCResolveConfiguration oldConfig, @Nullable OCResolveConfiguration newConfig) {
        if (oldConfig == null || newConfig == null) {
            return;
        }
        if (!oldConfig.getUniqueId().equals(newConfig.getUniqueId())) {
            this.resetConfigurationPriorities();
        }
    }

    public void notifyPrioritiesChange() {
        ((OCWorkspaceModificationTrackersImpl)OCWorkspace.getInstance(this.myProject).getModificationTrackers()).fireSelectedResolveConfigurationChanged();
    }

    public static class State {
        @Nullable
        public String configuration = null;
    }
}

