/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.settings;

import com.intellij.execution.ExecutionBundle;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.CodeStyleConfigurable;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsProvider;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.settings.FileExtensionPair;
import com.jetbrains.cidr.lang.settings.NamingConventionStyle;
import com.jetbrains.cidr.lang.settings.OCFileExtensionsSettings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCFileExtensionsSettingsProvider
extends CodeStyleSettingsProvider {
    @NotNull
    public static MyMasterDetailsComponent createConfigurable(@NotNull CodeStyleSettings settings) {
        return new MyMasterDetailsComponent(settings);
    }

    @NotNull
    public CustomCodeStyleSettings createCustomSettings(CodeStyleSettings settings) {
        return new OCFileExtensionsSettings(settings);
    }

    @NotNull
    public Configurable createSettingsPage(CodeStyleSettings settings, CodeStyleSettings originalSettings) {
        return OCFileExtensionsSettingsProvider.createConfigurable(settings);
    }

    @NotNull
    public String getConfigurableDisplayName() {
        return CidrLangBundle.message("fileExtensions.tabName", new Object[0]);
    }

    public boolean hasSettingsPage() {
        return false;
    }

    @NotNull
    public Language getLanguage() {
        return OCNewFileLangBackendHandlerProvider.getHandler().getLanguage();
    }

    private static class MyMasterDetailsComponent
    extends MasterDetailsComponent
    implements CodeStyleConfigurable {
        private final CodeStyleSettings mySettings;

        MyMasterDetailsComponent(CodeStyleSettings settings) {
            this.mySettings = settings;
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.myTree.getEmptyText().setText(CidrLangBundle.message("fileExtensions.no.extensions", new Object[0]));
        }

        protected void reInitWholePanelIfNeeded() {
            boolean reinit = this.myToReInitWholePanel;
            super.reInitWholePanelIfNeeded();
            if (reinit) {
                this.getMaster().putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
                this.myWholePanel.setBorder(null);
            }
        }

        @Nullable
        protected List<AnAction> createActions(boolean fromPopup) {
            ArrayList<AnAction> result = new ArrayList<AnAction>();
            result.add(new MyAddAction());
            result.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
            result.add(new MyMoveAction(ExecutionBundle.messagePointer((String)"move.up.action.name", (Object[])new Object[0]), IconUtil.getMoveUpIcon(), -1));
            result.add(new MyMoveAction(ExecutionBundle.messagePointer((String)"move.down.action.name", (Object[])new Object[0]), IconUtil.getMoveDownIcon(), 1));
            return result;
        }

        @Nls
        public String getDisplayName() {
            return CidrLangBundle.message("fileExtensions.tabName", new Object[0]);
        }

        public void reset() {
            this.reset(this.mySettings);
        }

        public void reset(@NotNull CodeStyleSettings settings) {
            this.myRoot.removeAllChildren();
            ImmutableList<FileExtensionPair> extensions = ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
            for (FileExtensionPair pair : extensions) {
                this.myRoot.add((MutableTreeNode)new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable(pair)));
            }
            super.reset();
        }

        public void apply() throws ConfigurationException {
            this.apply(this.mySettings);
        }

        public void apply(@NotNull CodeStyleSettings settings) throws ConfigurationException {
            String title = CidrLangBundle.message("fileExtensions.error", new Object[0]);
            if (this.myRoot.getChildCount() == 0) {
                throw new ConfigurationException(CidrLangBundle.message("fileExtensions.noExtensionsError", new Object[0]), title);
            }
            this.checkForEmptyAndDuplicatedNames(CidrLangBundle.message("fileExtensions.extensionPair", new Object[0]), title, MyFileExtensionPairConfigurable.class);
            super.apply();
            Enumeration children = this.myRoot.children();
            ArrayList<FileExtensionPair> list = new ArrayList<FileExtensionPair>();
            while (children.hasMoreElements()) {
                list.add((FileExtensionPair)((MasterDetailsComponent.MyNode)children.nextElement()).getConfigurable().getEditableObject());
            }
            ((OCFileExtensionsSettings)settings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED = ContainerUtil.immutableList(list);
        }

        public boolean isModified() {
            ImmutableList<FileExtensionPair> pairs = ((OCFileExtensionsSettings)this.mySettings.getCustomSettings(OCFileExtensionsSettings.class)).FILE_EXTENSION_PAIRS_ORDERED;
            if (this.myRoot.getChildCount() != pairs.size()) {
                return true;
            }
            for (int i = 0; i < this.myRoot.getChildCount(); ++i) {
                MasterDetailsComponent.MyNode node;
                MyFileExtensionPairConfigurable configurable;
                FileExtensionPair editablePair;
                FileExtensionPair originalPair = (FileExtensionPair)pairs.get(i);
                if (!originalPair.equals(editablePair = (configurable = (MyFileExtensionPairConfigurable)(node = (MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i)).getConfigurable()).getEditableObject())) {
                    return true;
                }
                if (!this.isInitialized(configurable) || !configurable.isModified()) continue;
                return true;
            }
            return false;
        }

        private final class MyFileExtensionPairConfigurable
        extends NamedConfigurable<Object> {
            @NotNull
            private FileExtensionPair myFileExtensionPair;
            private ComboBox<String> mySourceExtField;
            private ComboBox<String> myHeaderExtField;
            private ComboBox<NamingConventionStyle> myFileNamingField;

            MyFileExtensionPairConfigurable() {
                this.myFileExtensionPair = new FileExtensionPair("cpp", "h", NamingConventionStyle.NONE);
            }

            MyFileExtensionPairConfigurable(FileExtensionPair fileExtensionPair) {
                this.myFileExtensionPair = fileExtensionPair;
            }

            public void setDisplayName(String name) {
            }

            public FileExtensionPair getEditableObject() {
                return this.myFileExtensionPair;
            }

            public String getBannerSlogan() {
                return null;
            }

            public JComponent createOptionsPanel() {
                JPanel panel = new JPanel(new GridBagLayout());
                GridBag bag = new GridBag().setDefaultWeightX(1, 1.0).setDefaultAnchor(1, 23).setDefaultInsets(0, 0, 4, 10);
                this.startNewRowWithLabel(panel, bag, CidrLangBundle.message("fileExtensions.sourceExtension", new Object[0]));
                List list = ContainerUtil.sorted(OCFileTypeHelpers.sourceExtensions());
                this.mySourceExtField = new ComboBox((Object[])ArrayUtilRt.toStringArray((Collection)list));
                panel.add((Component)this.mySourceExtField, bag.next());
                this.mySourceExtField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                this.startNewRowWithLabel(panel, bag, CidrLangBundle.message("fileExtensions.headerExtension", new Object[0]));
                list = ContainerUtil.filter(OCFileTypeHelpers.headerExtensions(), s -> !s.isEmpty() && !"pch".equals(s));
                this.myHeaderExtField = new ComboBox((Object[])ArrayUtilRt.toStringArray((Collection)ContainerUtil.sorted((Collection)list)));
                panel.add((Component)this.myHeaderExtField, bag.next());
                this.myHeaderExtField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                this.startNewRowWithLabel(panel, bag, CidrLangBundle.message("fileExtensions.fileNamingConvention", new Object[0]));
                NamingConventionStyle[] cs = NamingConventionStyle.values();
                this.myFileNamingField = new ComboBox((Object[])cs);
                panel.add((Component)this.myFileNamingField, bag.next());
                this.myFileNamingField.addItemListener(e -> MyMasterDetailsComponent.this.TREE_UPDATER.run());
                JPanel wrapper = new JPanel(new BorderLayout());
                panel.setBorder((Border)JBUI.Borders.empty((int)4, (int)10));
                wrapper.add((Component)panel, "North");
                return wrapper;
            }

            private void startNewRowWithLabel(JPanel panel, GridBag bag, @NlsContexts.Label String labelName) {
                panel.add((Component)new JBLabel(labelName, 2), bag.nextLine().next().anchor(17));
            }

            public String getDisplayName() {
                @NlsSafe String sourceExt = this.mySourceExtField == null ? this.myFileExtensionPair.mySourceExt : (String)this.mySourceExtField.getSelectedItem();
                @NlsSafe String headerExt = this.myHeaderExtField == null ? this.myFileExtensionPair.myHeaderExt : (String)this.myHeaderExtField.getSelectedItem();
                return new FileExtensionPair(sourceExt, headerExt, this.getSelectedNamingConvention()).toString();
            }

            @Nullable
            public String getHelpTopic() {
                return null;
            }

            public boolean isModified() {
                return !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.mySourceExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.mySourceExt) || !StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)this.myHeaderExtField.getSelectedItem()), (CharSequence)this.myFileExtensionPair.myHeaderExt) || !this.myFileExtensionPair.myFileNamingConvention.equals((Object)this.getSelectedNamingConvention());
            }

            public void apply() throws ConfigurationException {
                this.myFileExtensionPair = new FileExtensionPair((String)this.mySourceExtField.getSelectedItem(), (String)this.myHeaderExtField.getSelectedItem(), this.getSelectedNamingConvention());
            }

            @NotNull
            private NamingConventionStyle getSelectedNamingConvention() {
                return this.myFileNamingField == null ? this.myFileExtensionPair.myFileNamingConvention : (NamingConventionStyle)((Object)this.myFileNamingField.getSelectedItem());
            }

            public void reset() {
                @NlsSafe String sourceExt = this.myFileExtensionPair.mySourceExt.toLowerCase(Locale.getDefault());
                @NlsSafe String headerExt = this.myFileExtensionPair.myHeaderExt.toLowerCase(Locale.getDefault());
                this.mySourceExtField.setSelectedItem((Object)sourceExt);
                this.myHeaderExtField.setSelectedItem((Object)headerExt);
                this.myFileNamingField.setSelectedItem((Object)this.myFileExtensionPair.myFileNamingConvention);
            }
        }

        private class MyMoveAction
        extends AnAction {
            private final int myDirection;

            protected MyMoveAction(Supplier<String> dynamicText, Icon icon, int direction) {
                super(dynamicText, dynamicText, icon);
                this.myDirection = direction;
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                TreeUtil.moveSelectedRow((JTree)MyMasterDetailsComponent.this.myTree, (int)this.myDirection);
            }

            public void update(@NotNull AnActionEvent e) {
                boolean enabled = false;
                TreePath selectionPath = MyMasterDetailsComponent.this.myTree.getSelectionPath();
                if (selectionPath != null) {
                    DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
                    enabled = (this.myDirection < 0 ? treeNode.getPreviousSibling() : treeNode.getNextSibling()) != null;
                }
                e.getPresentation().setEnabled(enabled);
            }
        }

        private class MyAddAction
        extends AnAction {
            MyAddAction() {
                super(IdeBundle.messagePointer((String)"add.scope.popup.title", (Object[])new Object[0]), IconUtil.getAddIcon());
                this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)MyMasterDetailsComponent.this.myTree);
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                MasterDetailsComponent.MyNode node = new MasterDetailsComponent.MyNode((NamedConfigurable)new MyFileExtensionPairConfigurable());
                MyMasterDetailsComponent.this.myRoot.add((MutableTreeNode)node);
                ((DefaultTreeModel)MyMasterDetailsComponent.this.myTree.getModel()).reload((TreeNode)MyMasterDetailsComponent.this.myRoot);
                MyMasterDetailsComponent.this.selectNodeInTree((DefaultMutableTreeNode)node);
            }
        }
    }
}

