/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.search.scopes;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public final class OCExplicitSourcesSearchScope {
    private static final Key<CachedValue<Collection<VirtualFile>>> EXPLICIT_PROJECT_SOURCE_FILES = Key.create((String)"EXPLICIT_PROJECT_SOURCE_FILES");

    @NotNull
    public static Collection<VirtualFile> getExplicitlySpecifiedProjectSourceFiles(@NotNull Project project2) {
        return (Collection)CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, EXPLICIT_PROJECT_SOURCE_FILES, () -> {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            final HashSet result = new HashSet();
            ProjectRootManager rootManager = ProjectRootManager.getInstance((Project)project2);
            final ProjectFileIndex index = rootManager.getFileIndex();
            final FileTypeRegistry typeRegistry = FileTypeRegistry.getInstance();
            for (VirtualFile eachSourceRoot : rootManager.getContentSourceRoots()) {
                ProgressManager.checkCanceled();
                VfsUtilCore.visitChildrenRecursively((VirtualFile)eachSourceRoot, (VirtualFileVisitor)new VirtualFileVisitor<Void>(new VirtualFileVisitor.Option[0]){

                    public boolean visitFile(@NotNull VirtualFile each) {
                        ProgressManager.checkCanceled();
                        if (index.isExcluded(each) || typeRegistry.isFileIgnored(each)) {
                            return false;
                        }
                        if (!each.isDirectory() && OCExplicitSourcesSearchScope.isInExplicitProjectSources(index, each)) {
                            result.add(each);
                        }
                        return true;
                    }
                });
            }
            return CachedValueProvider.Result.create(Collections.unmodifiableCollection(result), (Object[])OCExplicitSourcesSearchScope.getProjectSourcesCacheDependenciesExplicitRootsOnly(project2));
        }, false);
    }

    public static boolean isInExplicitProjectSources(@NotNull ProjectFileIndex index, @NotNull VirtualFile file2) {
        return index.isInSourceContent(file2) && !index.isInLibrary(file2);
    }

    public static ModificationTracker @NotNull [] getProjectSourcesCacheDependenciesExplicitRootsOnly(@NotNull Project project2) {
        return new ModificationTracker[]{VirtualFileManager.VFS_STRUCTURE_MODIFICATIONS, ProjectRootManager.getInstance((Project)project2)};
    }
}

