/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.ResourceUtil;
import com.jetbrains.cidr.lang.inspections.CidrInspectionToolProvider;
import com.jetbrains.cidr.lang.inspections.OCInspectionBase;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCInspectionUtil {
    private static final Logger LOG = Logger.getInstance(OCInspectionUtil.class);

    private OCInspectionUtil() {
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends LocalInspectionTool> inspectionClass, @Nullable PsiElement element, @Nullable HighlightSeverity defaultHighlightSeverity) {
        return element != null ? OCInspectionUtil.getHighlightSeverity(inspectionClass, element, element.getProject(), defaultHighlightSeverity) : defaultHighlightSeverity;
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull Class<? extends LocalInspectionTool> inspectionClass, @Nullable PsiElement element, @NotNull Project project2, @Nullable HighlightSeverity defaultHighlightSeverity) {
        if (OCInspectionBase.OtherObjCMarker.class.isAssignableFrom(inspectionClass) || OCInspectionBase.OtherCppMarker.class.isAssignableFrom(inspectionClass)) {
            return defaultHighlightSeverity;
        }
        String inspectionShortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (inspectionShortName == null) {
            return null;
        }
        return OCInspectionUtil.getHighlightSeverity(inspectionShortName, element, project2, defaultHighlightSeverity);
    }

    @Nullable
    public static HighlightSeverity getHighlightSeverity(@NotNull String inspectionName, @Nullable PsiElement element, @NotNull Project project2, @Nullable HighlightSeverity defaultHighlightSeverity) {
        HighlightDisplayKey highlightDisplayKey;
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)project2);
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        if (!inspectionProfile.isToolEnabled(highlightDisplayKey = HighlightDisplayKey.find((String)inspectionName), element) && !ApplicationManager.getApplication().isUnitTestMode()) {
            return null;
        }
        if (highlightDisplayKey == null) {
            return defaultHighlightSeverity;
        }
        HighlightDisplayLevel highlightDisplayLevel = inspectionProfile.getErrorLevel(highlightDisplayKey, element);
        return highlightDisplayLevel.getSeverity();
    }

    @Nullable
    public static String getInspectionShortName(@NotNull Class<? extends LocalInspectionTool> inspectionClass) {
        try {
            return inspectionClass.newInstance().getShortName();
        }
        catch (IllegalAccessException | InstantiationException e) {
            LOG.warn("Cannot get inspection short name: " + e);
            return null;
        }
    }

    @Nullable
    @Nls
    public static String getStaticDescription(@NotNull OCInspectionBase inspection) {
        String shortName = OCInspectionUtil.getInspectionShortName(inspection.getInspectionClass());
        if (shortName != null) {
            try {
                InputStream descriptionStream = ResourceUtil.getResourceAsStream((ClassLoader)((Object)((Object)inspection)).getClass().getClassLoader(), (String)"inspectionDescriptions", (String)(shortName + ".html"));
                return descriptionStream != null ? ResourceUtil.loadText((InputStream)descriptionStream) : null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return "";
    }

    public static boolean isInspectionEnabled(@NotNull Project project2, @Nullable Class<? extends OCInspectionBase> inspectionClass) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (inspectionClass == null) {
            return false;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        HighlightDisplayKey key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile();
        return inspectionProfile.isToolEnabled(key, null);
    }

    public static void setInspectionEnabled(@NotNull Project project2, @Nullable Class<? extends OCInspectionBase> inspectionClass, boolean enabled) {
        if (inspectionClass == null) {
            return;
        }
        String shortName = OCInspectionUtil.getInspectionShortName(inspectionClass);
        if (shortName != null) {
            InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile();
            inspectionProfile.setToolEnabled(shortName, enabled, project2);
        }
    }

    public static boolean isClangdDFAEnabled(@NotNull PsiElement element) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance((Project)element.getProject());
        InspectionProfileImpl inspectionProfile = profileManager.getCurrentProfile();
        return Arrays.stream(CidrInspectionToolProvider.getInstance().getInspectionClasses()).filter(c -> OCInspectionUtil.isClangdDFAInspection(c)).anyMatch(arg_0 -> OCInspectionUtil.lambda$isClangdDFAEnabled$1((InspectionProfile)inspectionProfile, element, arg_0));
    }

    @NotNull
    public static List<Class<? extends OCInspectionBase>> setClangdDFADisabled(@NotNull Project project2) {
        InspectionProfileImpl inspectionProfile = InspectionProjectProfileManager.getInstance((Project)project2).getCurrentProfile();
        ArrayList<Class<? extends OCInspectionBase>> disabledList = new ArrayList<Class<? extends OCInspectionBase>>();
        for (Class<? extends LocalInspectionTool> c : CidrInspectionToolProvider.getInstance().getInspectionClasses()) {
            HighlightDisplayKey key;
            if (!OCInspectionUtil.isClangdDFAInspection(c)) continue;
            String shortName = OCInspectionUtil.getInspectionShortName(c);
            HighlightDisplayKey highlightDisplayKey = key = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
            if (key == null || !inspectionProfile.isToolEnabled(key)) continue;
            disabledList.add(c);
            inspectionProfile.setToolEnabled(shortName, false, project2);
        }
        return disabledList;
    }

    private static boolean isClangdDFAInspection(Class<?> klass) {
        if (!OCInspectionBase.DataFlowAnalysisMarker.class.isAssignableFrom(klass)) {
            return false;
        }
        try {
            OCInspectionBase inspection = (OCInspectionBase)((Object)klass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            return inspection.getMainToolId() != null && inspection.worksWithClangd();
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            return false;
        }
    }

    private static /* synthetic */ boolean lambda$isClangdDFAEnabled$1(InspectionProfile inspectionProfile, PsiElement element, Class c) {
        String shortName = OCInspectionUtil.getInspectionShortName(c);
        HighlightDisplayKey highlightDisplayKey = shortName != null ? HighlightDisplayKey.find((String)shortName) : null;
        return highlightDisplayKey != null && inspectionProfile.isToolEnabled(highlightDisplayKey, element);
    }
}

