/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.formatting;

import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.CidrFormattingFixture;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.fixtures.OCCodeInsightTestCase;
import org.jetbrains.annotations.NotNull;

public abstract class OCFormattingTestCase
extends OCCodeInsightTestCase {
    private String myToFormat = null;
    private OCLanguageKind languageKind = CLanguageKind.OBJ_CPP;
    private boolean myReformatWhitespacesOnly = false;
    protected CidrFormattingFixture myFormattingFixture;

    public OCFormattingTestCase() {
    }

    public OCFormattingTestCase(@NotNull String projectName) {
        super(projectName);
    }

    public OCFormattingTestCase(@NotNull String testFilesPath, @NotNull String testFilesExtension) {
        super(testFilesPath, testFilesExtension);
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myFormattingFixture.setUp();
    }

    @Override
    protected void setUpFixtures() throws Exception {
        super.setUpFixtures();
        this.myFormattingFixture = new CidrFormattingFixture(this.myCodeInsightFixture);
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myFormattingFixture.tearDown();
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
    }

    protected void prepareForFormat(String text) {
        this.prepareForFormat(text, CLanguageKind.OBJ_C);
    }

    protected void prepareForFormatCPP(String text) {
        this.prepareForFormat(text, CLanguageKind.OBJ_CPP);
    }

    protected void prepareForFormat(String text, CLanguageKind kind) {
        this.myToFormat = text;
        this.languageKind = kind;
    }

    protected void assertFormat(String before, String after) {
        this.assertFormat(before, after, CLanguageKind.OBJ_C);
    }

    protected void assertFormatCPP(String before, String after) {
        this.assertFormat(before, after, CLanguageKind.OBJ_CPP);
    }

    protected void assertFormat(String before, String after, CLanguageKind kind) {
        this.assertFormat(before, after, kind, false);
    }

    protected void assertFormat(String before, String after, CLanguageKind kind, boolean reformatWhitespacesOnly) {
        this.myReformatWhitespacesOnly = reformatWhitespacesOnly;
        this.prepareForFormat(before, kind);
        this.assertFormat(after);
        this.assertFormatPsi(after);
    }

    protected void assertFormat(String expected) {
        assert (this.myToFormat != null);
        this.doConfigureText();
        this.formatCurrentFile();
        this.assertFormatResult(expected);
    }

    protected void formatCurrentFile() {
        PsiFile file2 = this.getFile();
        TextRange range = this.getSelection();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            if (this.myReformatWhitespacesOnly) {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatRange((PsiElement)file2, range.getStartOffset(), range.getEndOffset(), true);
            } else {
                CodeStyleManager.getInstance((Project)this.getProject()).reformatText(file2, range.getStartOffset(), range.getEndOffset());
            }
        });
    }

    private void assertFormatPsi(String after) {
        this.doConfigureText();
        WriteCommandAction.runWriteCommandAction((Project)this.getProject(), () -> {
            PsiFile psiFile = this.getFile();
            TextRange range = this.getSelection();
            PsiElement elementAtStart = psiFile.findElementAt(range.getStartOffset());
            PsiElement elementAtEnd = psiFile.findElementAt(range.getEndOffset());
            CodeStyleManager.getInstance((Project)this.getProject()).reformat((PsiElement)(elementAtStart == elementAtEnd ? elementAtStart : psiFile), this.myReformatWhitespacesOnly);
        });
        this.assertFormatResult(after);
    }

    protected void assertFormatResult(String expected) {
        try {
            this.myCodeInsightFixture.checkResult(expected);
        }
        catch (Throwable e) {
            this.doConfigureText();
            OCFormattingTestCase.printPsiStructure((PsiElement)this.getFile());
            ExceptionUtil.rethrow((Throwable)e);
        }
    }

    protected void doConfigureText() {
        this.myCodeInsightFixture.configureByText(this.myToFormat, "test." + this.languageKind.getDefaultSourceExtension());
    }

    protected void checkCopyPaste(String from, String to, String expected) {
        this.configureByTextOCpp(from);
        this.myCodeInsightFixture.getFixture().performEditorAction("$Copy");
        this.configureByTextOCpp(to);
        this.myCodeInsightFixture.getFixture().performEditorAction("$Paste");
        this.checkResult(expected);
    }
}

