/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.fixtures;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.fixtures.impl.LightIdeaTestFixtureImpl;
import com.intellij.util.ThrowableConsumer;
import com.jetbrains.cidr.CidrProjectFixture;
import com.jetbrains.cidr.CidrTestDataFixture;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.build.CidrBuildResult;
import com.jetbrains.cidr.lang.fixtures.OCMockProjectDescriptor;
import com.jetbrains.cidr.lang.fixtures.OCMockWorkspace;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import java.io.File;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCMockProjectFixture
extends CidrProjectFixture<Object> {
    private final boolean myForceNewProject;
    private final boolean myCleanupProject;
    private LightIdeaTestFixtureImpl myIdeaLightFixture;

    public OCMockProjectFixture(@NotNull CidrTestDataFixture testDataFixture) {
        this(testDataFixture, true, true);
    }

    public OCMockProjectFixture(@NotNull CidrTestDataFixture testDataFixture, boolean forceNewProject, boolean cleanupProject) {
        super(testDataFixture);
        this.myForceNewProject = forceNewProject;
        this.myCleanupProject = cleanupProject;
    }

    @Override
    public void setUp(@NotNull String testClassFQN, @NotNull String testName) throws Exception {
        super.setUp(testClassFQN, testName);
        if (this.myForceNewProject) {
            this.closeProjectAndCleanup();
        }
    }

    @Override
    public void tearDown() throws Exception {
        if (this.myCleanupProject) {
            this.closeProjectAndCleanup();
        }
        super.tearDown();
    }

    @Override
    @NotNull
    protected String getAdjustedProjectDir(@NotNull String relativeProjectFilePath) {
        if (FileUtilRt.extensionEquals((String)relativeProjectFilePath, (String)"yaml")) {
            return new File(relativeProjectFilePath).getParent();
        }
        return super.getAdjustedProjectDir(relativeProjectFilePath);
    }

    @Override
    @NotNull
    protected Project doOpenProject(@NotNull VirtualFile projectFile) throws Exception {
        this.myIdeaLightFixture = new LightIdeaTestFixtureImpl((LightProjectDescriptor)new OCMockProjectDescriptor(projectFile), this.myCurrentTestName);
        this.myIdeaLightFixture.setUp();
        return this.myIdeaLightFixture.getProject();
    }

    @Override
    @NotNull
    protected ThrowableConsumer<Project, Throwable> getCloseProjectRunnable() {
        return project2 -> {
            Exception toRethrow = null;
            try {
                this.myIdeaLightFixture.tearDown();
            }
            catch (Exception e) {
                toRethrow = e;
            }
            try {
                LightPlatformTestCase.closeAndDeleteProject();
            }
            catch (Exception e) {
                if (toRethrow != null) {
                    e.addSuppressed(toRethrow);
                }
                toRethrow = e;
            }
            if (toRethrow != null) {
                throw toRethrow;
            }
        };
    }

    @NotNull
    public OCMockWorkspace getMockWorkspace() {
        return Objects.requireNonNull(OCMockProjectDescriptor.getMockWorkspace(this.getProject()));
    }

    @Override
    @Nullable
    public Object getBuildConfiguration(@NotNull CidrRunConfiguration runConfiguration, @Nullable ExecutionTarget executionTarget) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected ExecutionResult<CidrBuildResult> doBuildOrCleanConfig(@NotNull Object config, boolean build2, @Nullable ProcessListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected String getConfigBuildId(@NotNull Object config) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public OCMockWorkspace getCidrWorkspace() {
        return this.getMockWorkspace();
    }

    @Override
    public @NotNull OCWorkspace.ModifiableModel getWorkspaceModifiableModel(boolean clear) {
        return this.getWorkspace().getModifiableModel(this.getMockWorkspace().getClientKey(), clear);
    }
}

